/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedureParameter;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLView;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLDataSource;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLProcedure;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLView;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLViewColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class OceanbaseMySQLCatalog
extends MySQLCatalog {
    private final OceanbaseMySQLDataSource dataSource;
    private final OceanbaseProceduresCache oceanbaseProceduresCache = new OceanbaseProceduresCache();
    private final OceanbaseTableCache oceanbaseTableCache = new OceanbaseTableCache();

    OceanbaseMySQLCatalog(OceanbaseMySQLDataSource dataSource, ResultSet dbResult) {
        super((MySQLDataSource)dataSource, dbResult);
        this.dataSource = dataSource;
        this.oceanbaseTableCache.setCaseSensitive(false);
    }

    public OceanbaseProceduresCache getOceanbaseProceduresCache() {
        return this.oceanbaseProceduresCache;
    }

    public OceanbaseTableCache getOceanbaseTableCache() {
        return this.oceanbaseTableCache;
    }

    public Collection<MySQLProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().supportsInformationSchema()) {
            return Collections.emptyList();
        }
        return new ArrayList<MySQLProcedure>(this.oceanbaseProceduresCache.getAllObjects(monitor, (DBSObject)this));
    }

    public MySQLProcedure getProcedure(DBRProgressMonitor monitor, String procName) throws DBException {
        return (MySQLProcedure)this.oceanbaseProceduresCache.getObject(monitor, (DBSObject)this, procName);
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.oceanbaseProceduresCache.clearCache();
        this.oceanbaseTableCache.clearCache();
        return this;
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this.dataSource;
    }

    @Association
    public Collection<MySQLTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.oceanbaseTableCache.getTypedObjects(monitor, (DBSObject)this, MySQLTable.class);
    }

    public MySQLTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLTable)this.oceanbaseTableCache.getObject(monitor, (DBSObject)this, name, MySQLTable.class);
    }

    @Association
    public Collection<MySQLView> getViews(DBRProgressMonitor monitor) throws DBException {
        return new ArrayList<MySQLView>(this.oceanbaseTableCache.getTypedObjects(monitor, (DBSObject)this, OceanbaseMySQLView.class));
    }

    public Collection<MySQLTableBase> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.oceanbaseTableCache.getAllObjects(monitor, (DBSObject)this);
    }

    public MySQLTableBase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (MySQLTableBase)this.oceanbaseTableCache.getObject(monitor, (DBSObject)this, childName);
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        monitor.subTask("Cache tables");
        this.oceanbaseTableCache.getAllObjects(monitor, (DBSObject)this);
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.oceanbaseTableCache.loadChildren(monitor, (DBSObject)this, null);
        }
        super.cacheStructure(monitor, scope);
    }

    static class OceanbaseProceduresCache
    extends JDBCStructLookupCache<OceanbaseMySQLCatalog, OceanbaseMySQLProcedure, MySQLProcedureParameter> {
        OceanbaseProceduresCache() {
            super((Object)"PROCEDURE_NAME");
        }

        public JDBCStatement prepareLookupStatement(JDBCSession session, OceanbaseMySQLCatalog owner, OceanbaseMySQLProcedure object, String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM information_schema.ROUTINES\nWHERE ROUTINE_SCHEMA=?" + (object == null && objectName == null ? "" : " AND ROUTINE_NAME=?") + " AND ROUTINE_TYPE" + (object == null ? " IN ('PROCEDURE','FUNCTION')" : "=?") + "\nORDER BY " + "ROUTINE_NAME");
            dbStat.setString(1, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
                if (object != null) {
                    dbStat.setString(3, String.valueOf(object.getProcedureType()));
                }
            }
            return dbStat;
        }

        protected JDBCStatement prepareChildrenStatement(JDBCSession session, OceanbaseMySQLCatalog owner, OceanbaseMySQLProcedure procedure) throws SQLException {
            if (procedure.getProcedureType().equals((Object)DBSProcedureType.PROCEDURE)) {
                return session.getMetaData().getProcedureColumns(owner.getName(), null, JDBCUtils.escapeWildCards((JDBCSession)session, (String)procedure.getName()), "%").getSourceStatement();
            }
            String queryFunctionString = "select * from mysql.proc where db=? and type='FUNCTION' and name=?";
            JDBCPreparedStatement statement = session.prepareStatement(queryFunctionString);
            statement.setString(1, owner.getName());
            statement.setString(2, procedure.getName());
            return statement;
        }

        protected MySQLProcedureParameter fetchChild(JDBCSession session, OceanbaseMySQLCatalog owner, OceanbaseMySQLProcedure parent, JDBCResultSet dbResult) {
            if (parent.getProcedureType().equals((Object)DBSProcedureType.PROCEDURE)) {
                DBSProcedureParameterKind parameterType;
                String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                int columnTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_TYPE");
                int valueType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE");
                String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
                int position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
                long columnSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"LENGTH");
                boolean notNull = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NULLABLE") == 0;
                int scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SCALE");
                int precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRECISION");
                switch (columnTypeNum) {
                    case 1: {
                        parameterType = DBSProcedureParameterKind.IN;
                        break;
                    }
                    case 2: {
                        parameterType = DBSProcedureParameterKind.INOUT;
                        break;
                    }
                    case 4: {
                        parameterType = DBSProcedureParameterKind.OUT;
                        break;
                    }
                    case 5: {
                        parameterType = DBSProcedureParameterKind.RETURN;
                        break;
                    }
                    case 3: {
                        parameterType = DBSProcedureParameterKind.RESULTSET;
                        break;
                    }
                    default: {
                        parameterType = DBSProcedureParameterKind.UNKNOWN;
                    }
                }
                if (CommonUtils.isEmpty((String)columnName) && parameterType == DBSProcedureParameterKind.RETURN) {
                    columnName = "RETURN";
                }
                return new MySQLProcedureParameter((MySQLProcedure)parent, columnName, typeName, valueType, position, columnSize, Integer.valueOf(scale), Integer.valueOf(precision), notNull, parameterType);
            }
            String returnString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"returns");
            if (returnString == null) {
                return null;
            }
            String[] paramList = returnString.split("\\(");
            int columnSize = Integer.parseInt(paramList[1].split("\\)")[0]);
            return new MySQLProcedureParameter((MySQLProcedure)parent, "RETURN", paramList[0], 2, 0, (long)columnSize, null, null, true, null);
        }

        protected OceanbaseMySQLProcedure fetchObject(JDBCSession session, OceanbaseMySQLCatalog owner, JDBCResultSet resultSet) {
            return new OceanbaseMySQLProcedure(owner, (ResultSet)resultSet);
        }
    }

    static class OceanbaseTableCache
    extends JDBCStructLookupCache<OceanbaseMySQLCatalog, MySQLTableBase, MySQLTableColumn> {
        OceanbaseTableCache() {
            super((Object)"TABLE_NAME");
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull OceanbaseMySQLCatalog owner, @Nullable MySQLTableBase object, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder("SHOW ");
            MySQLDataSource dataSource = owner.getDataSource();
            if (session.getMetaData().getDatabaseMajorVersion() > 4) {
                sql.append("FULL ");
            }
            sql.append("TABLES FROM ").append(DBUtils.getQuotedIdentifier((DBSObject)owner));
            if (!session.getDataSource().getContainer().getPreferenceStore().getBoolean("database.meta.server.side.filters")) {
                if (object != null || objectName != null) {
                    sql.append(" LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)(object != null ? object.getName() : objectName)));
                }
            } else {
                String tableNameCol = DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)("Tables_in_" + owner.getName()));
                if (object != null || objectName != null) {
                    sql.append(" WHERE ").append(tableNameCol).append(" LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)(object != null ? object.getName() : objectName)));
                    if (dataSource.supportsSequences()) {
                        sql.append(" AND Table_type <> 'SEQUENCE'");
                    }
                } else {
                    DBSObjectFilter tableFilters = dataSource.getContainer().getObjectFilter(MySQLTable.class, (DBSObject)owner, true);
                    if (tableFilters != null && !tableFilters.isNotApplicable()) {
                        boolean hasCond;
                        sql.append(" WHERE ");
                        if (!CommonUtils.isEmpty((Collection)tableFilters.getInclude())) {
                            sql.append("(");
                            hasCond = false;
                            for (String incName : tableFilters.getInclude()) {
                                if (hasCond) {
                                    sql.append(" OR ");
                                }
                                hasCond = true;
                                sql.append(tableNameCol).append(" LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)SQLUtils.makeSQLLike((String)incName)));
                            }
                            sql.append(")");
                        }
                        if (!CommonUtils.isEmpty((Collection)tableFilters.getExclude())) {
                            if (!CommonUtils.isEmpty((Collection)tableFilters.getInclude())) {
                                sql.append(" AND ");
                            }
                            sql.append("(");
                            hasCond = false;
                            for (String incName : tableFilters.getExclude()) {
                                if (hasCond) {
                                    sql.append(" OR ");
                                }
                                hasCond = true;
                                sql.append(tableNameCol).append(" NOT LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)incName));
                            }
                            sql.append(")");
                        }
                    } else if (dataSource.supportsSequences()) {
                        sql.append(" WHERE Table_type <> 'SEQUENCE'");
                    }
                }
            }
            return session.prepareStatement(sql.toString());
        }

        protected MySQLTableBase fetchObject(@NotNull JDBCSession session, @NotNull OceanbaseMySQLCatalog owner, @NotNull JDBCResultSet dbResult) {
            String tableType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE");
            if (tableType != null && tableType.contains("VIEW")) {
                return new OceanbaseMySQLView(owner, (ResultSet)dbResult);
            }
            return new MySQLTable((MySQLCatalog)owner, (ResultSet)dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull OceanbaseMySQLCatalog owner, @Nullable MySQLTableBase forTable) throws SQLException {
            if (forTable instanceof OceanbaseMySQLView) {
                JDBCPreparedStatement dbStat = session.prepareStatement("desc " + owner.getName() + "." + forTable.getName());
                return dbStat;
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM ").append("information_schema.COLUMNS").append(" WHERE ").append("TABLE_SCHEMA").append("=?");
            if (forTable != null) {
                sql.append(" AND ").append("TABLE_NAME").append("=?");
            }
            sql.append(" ORDER BY ").append("ORDINAL_POSITION");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, owner.getName());
            if (forTable != null) {
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        protected MySQLTableColumn fetchChild(@NotNull JDBCSession session, @NotNull OceanbaseMySQLCatalog owner, @NotNull MySQLTableBase table, @NotNull JDBCResultSet dbResult) throws DBException {
            if (table instanceof OceanbaseMySQLView) {
                return new OceanbaseMySQLViewColumn(table, (ResultSet)dbResult);
            }
            return new MySQLTableColumn(table, (ResultSet)dbResult);
        }
    }
}

