/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.jkiss.dbeaver.model.fs.nio.NIOContainer;
import org.jkiss.dbeaver.model.fs.nio.NIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.NIOResource;

public final class NIOProject
extends NIOContainer
implements IProject {
    private final IProjectDescription description = new Description();

    public NIOProject(NIOFileSystemRoot root, java.nio.file.Path path) {
        super(root, path);
    }

    @Override
    public IPath getFullPath() {
        return new Path(this.getNioPath().toAbsolutePath().toString()).makeAbsolute();
    }

    @Override
    public IProject getProject() {
        return this;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String getName() {
        return this.description.getName();
    }

    public void build(int kind, String builderName, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void build(int kind, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void build(IBuildConfiguration config, int kind, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void close(IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void create(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void create(IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void create(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public IBuildConfiguration getActiveBuildConfig() throws CoreException {
        return this.getBuildConfig("");
    }

    public IBuildConfiguration getBuildConfig(String configName) throws CoreException {
        IBuildConfiguration[] buildConfigs = this.description.getBuildConfigReferences(configName);
        return buildConfigs.length == 0 ? null : buildConfigs[0];
    }

    public IBuildConfiguration[] getBuildConfigs() throws CoreException {
        return this.description.getBuildConfigReferences("");
    }

    public IBuildConfiguration[] getReferencedBuildConfigs(String configName, boolean includeMissing) throws CoreException {
        return this.getBuildConfigs();
    }

    public boolean hasBuildConfig(String configName) throws CoreException {
        return "".equals(configName);
    }

    public IContentTypeMatcher getContentTypeMatcher() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProjectDescription getDescription() throws CoreException {
        return this.description;
    }

    public IFile getFile(String name) {
        return null;
    }

    public IFolder getFolder(String name) {
        return null;
    }

    public IProjectNature getNature(String natureId) throws CoreException {
        if (this.description.hasNature(natureId)) {
            return new IProjectNature(){

                public IProject getProject() {
                    return NIOProject.this;
                }

                public void setProject(IProject project) {
                    throw new UnsupportedOperationException();
                }

                public void configure() throws CoreException {
                    throw new UnsupportedOperationException();
                }

                public void deconfigure() throws CoreException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    public IPath getWorkingLocation(String id) {
        throw new UnsupportedOperationException();
    }

    public IProject[] getReferencedProjects() throws CoreException {
        return new IProject[0];
    }

    public IProject[] getReferencingProjects() {
        return new IProject[0];
    }

    public void clearCachedDynamicReferences() {
    }

    public boolean hasNature(String natureId) throws CoreException {
        return this.description.hasNature(natureId);
    }

    public boolean isNatureEnabled(String natureId) throws CoreException {
        return this.hasNature(natureId);
    }

    public boolean isOpen() {
        return true;
    }

    public void loadSnapshot(int options, URI snapshotLocation, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void saveSnapshot(int options, URI snapshotLocation, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void move(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void open(int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void open(IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setDescription(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setDescription(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public final class Description
    implements IProjectDescription {
        private String name;
        private String comment;
        private IBuildConfiguration[] buildConfigurations;
        private final List<ICommand> commands = new ArrayList<ICommand>();
        private final List<String> natureIDs = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public ICommand[] getBuildSpec() {
            return this.commands.toArray(new ICommand[this.commands.size()]);
        }

        public String[] getNatureIds() {
            return this.natureIDs.toArray(new String[this.natureIDs.size()]);
        }

        public boolean hasNature(String natureId) {
            return this.natureIDs.contains(natureId);
        }

        public IBuildConfiguration[] getBuildConfigReferences(String configName) {
            if ("".equals(configName)) {
                return this.buildConfigurations;
            }
            return new IBuildConfiguration[0];
        }

        public IProject[] getDynamicReferences() {
            return new IProject[0];
        }

        @Deprecated
        public IPath getLocation() {
            return NIOProject.this.getLocation();
        }

        public URI getLocationURI() {
            return NIOProject.this.getLocationURI();
        }

        public IProject[] getReferencedProjects() {
            return new IProject[0];
        }

        public ICommand newCommand() {
            return null;
        }

        public void setActiveBuildConfig(String configName) {
        }

        public void setBuildConfigs(String[] configNames) {
        }

        public void setBuildConfigReferences(String configName, IBuildConfiguration[] references) {
        }

        public void setBuildSpec(ICommand[] buildSpec) {
        }

        public void setComment(String comment) {
        }

        @Deprecated
        public void setDynamicReferences(IProject[] projects) {
        }

        public void setLocation(IPath location) {
        }

        public void setLocationURI(URI location) {
        }

        public void setName(String projectName) {
        }

        public void setNatureIds(String[] natures) {
        }

        public void setReferencedProjects(IProject[] projects) {
        }
    }
}

