/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCTransactionIsolation;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCSavepointImpl;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCExecutionContext
extends AbstractExecutionContext<JDBCDataSource>
implements DBCTransactionManager,
IAdaptable {
    public static final String TYPE_MAIN = "Main";
    public static final String TYPE_METADATA = "Metadata";
    protected static final String TASK_TITLE_SET_SCHEMA = "Set active schema";
    private static final Log log = Log.getLog(JDBCExecutionContext.class);
    static final int TXN_INFO_READ_TIMEOUT = 5000;
    @NotNull
    private volatile JDBCRemoteInstance instance;
    private volatile Connection connection;
    private volatile Boolean autoCommit;
    private volatile Integer transactionIsolationLevel;
    private volatile transient boolean txnIsolationLevelReadInProgress;

    public JDBCExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance.getDataSource(), purpose);
        this.instance = instance;
    }

    @Override
    public JDBCRemoteInstance getOwnerInstance() {
        return this.instance;
    }

    protected void setOwnerInstance(@NotNull JDBCRemoteInstance instance) {
        this.instance = instance;
    }

    @NotNull
    private Connection getConnection() throws DBCException {
        Connection dbCon = this.connection;
        if (dbCon == null) {
            throw new DBCException("Disconnected");
        }
        return dbCon;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null, null, true);
    }

    protected void connect(@NotNull DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel, JDBCExecutionContext initFrom, boolean addContext) throws DBCException {
        block31: {
            if (this.connection != null && addContext) {
                log.error("Reopening not-closed connection");
                this.close();
            }
            ((JDBCDataSource)this.dataSource).getContainer().isConnectionReadOnly();
            JDBCRemoteInstance currentInstance = this.instance;
            DBExecUtils.startContextInitiation(((JDBCDataSource)this.dataSource).getContainer());
            Object exclusiveLock = currentInstance.getExclusiveLock().acquireExclusiveLock();
            try {
                this.connection = ((JDBCDataSource)this.dataSource).openConnection(monitor, this, this.purpose);
                if (this.connection == null) {
                    throw new DBCException("Null connection returned");
                }
                monitor.subTask("Set connection defaults");
                if (autoCommit == null) {
                    autoCommit = ((JDBCDataSource)this.dataSource).getContainer().isDefaultAutoCommit();
                }
                if (txnLevel == null) {
                    txnLevel = ((JDBCDataSource)this.dataSource).getContainer().getDefaultTransactionsIsolation();
                }
                if (txnLevel != null) {
                    try {
                        this.getConnection().setTransactionIsolation(txnLevel);
                        this.transactionIsolationLevel = txnLevel;
                    }
                    catch (Throwable e) {
                        log.debug("Can't set transaction isolation level", e);
                    }
                }
                try {
                    this.connection.setAutoCommit(autoCommit);
                    this.autoCommit = autoCommit;
                }
                catch (Throwable e) {
                    log.debug("Can't set auto-commit state: " + e.getMessage());
                }
                try {
                    this.autoCommit = this.connection.getAutoCommit();
                }
                catch (Throwable e) {
                    log.debug("Can't check auto-commit state", e);
                    this.autoCommit = false;
                }
                try {
                    this.initContextBootstrap(monitor, autoCommit);
                }
                catch (DBCException e) {
                    log.warn("Error while running context bootstrap", e);
                }
                if (addContext) {
                    currentInstance.addContext(this);
                }
            }
            finally {
                DBExecUtils.finishContextInitiation(((JDBCDataSource)this.dataSource).getContainer());
                currentInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
            }
            try {
                ((JDBCDataSource)this.dataSource).initializeContextState(monitor, this, initFrom);
            }
            catch (DBException e) {
                log.warn("Error while initializing context state", e);
            }
            try {
                if (this.autoCommit.booleanValue()) break block31;
                Throwable e = null;
                Object var9_17 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Start transaction");){
                    session.enableLogging(false);
                    session.commit();
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                log.error("Error ending transaction after context initialize", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        JDBCExecutionContext jDBCExecutionContext = this;
        synchronized (jDBCExecutionContext) {
            if (this.connection != null && !((JDBCDataSource)this.dataSource).closeConnection(this.connection, this.purpose, !this.isAutoCommit(false))) {
                log.debug("Connection close timeout");
            }
            this.connection = null;
        }
        super.closeContext();
    }

    @NotNull
    public Connection getConnection(DBRProgressMonitor monitor) throws SQLException {
        if (this.connection == null) {
            try {
                this.connect(monitor);
            }
            catch (DBCException e) {
                if (e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw new SQLException(e);
            }
        }
        return this.connection;
    }

    @Override
    @NotNull
    public JDBCSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return ((JDBCDataSource)this.dataSource).createConnection(monitor, this, purpose, taskTitle);
    }

    @Override
    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        if (!JDBCUtils.isConnectionAlive(this.getDataSource(), this.getConnection())) {
            throw new DBCException("Connection is dead");
        }
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        if (this.connection == null) {
            this.connect(monitor);
            return DBCExecutionContext.InvalidateResult.CONNECTED;
        }
        Boolean prevAutocommit = this.autoCommit;
        Integer txnLevel = this.transactionIsolationLevel;
        this.closeContext(false);
        this.connect(monitor, prevAutocommit, txnLevel, this, false);
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    @Override
    public void close() {
        this.closeContext(true);
    }

    private void closeContext(boolean removeContext) {
        if (removeContext) {
            this.instance.removeContext(this);
        }
        this.disconnect();
    }

    @Override
    public DBPTransactionIsolation getTransactionIsolation() throws DBCException {
        if (this.transactionIsolationLevel == null) {
            if (!this.txnIsolationLevelReadInProgress) {
                this.txnIsolationLevelReadInProgress = true;
                try {
                    if (!RuntimeUtils.runTask(monitor -> {
                        try {
                            DBExecUtils.tryExecuteRecover(monitor, this.getDataSource(), monitor1 -> {
                                try {
                                    this.transactionIsolationLevel = this.getConnection().getTransactionIsolation();
                                }
                                catch (Throwable e) {
                                    this.transactionIsolationLevel = 0;
                                    log.error("Error getting transaction isolation level", e);
                                }
                            });
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }, "Get transaction isolation level", 5000L, true)) {
                        throw new DBCException("Can't determine transaction isolation - timeout");
                    }
                }
                finally {
                    this.txnIsolationLevelReadInProgress = false;
                }
            }
            if (this.transactionIsolationLevel == null) {
                this.transactionIsolationLevel = 0;
                log.error("Cannot determine transaction isolation level due to connection hanging. Setting to NONE.");
            }
        }
        return JDBCTransactionIsolation.getByCode(this.transactionIsolationLevel);
    }

    @Override
    public void setTransactionIsolation(@NotNull DBRProgressMonitor monitor, @NotNull DBPTransactionIsolation transactionIsolation) throws DBCException {
        if (!(transactionIsolation instanceof JDBCTransactionIsolation)) {
            throw new DBCException(ModelMessages.model_jdbc_exception_invalid_transaction_isolation_parameter);
        }
        JDBCTransactionIsolation jdbcTIL = (JDBCTransactionIsolation)transactionIsolation;
        try {
            try {
                this.getConnection().setTransactionIsolation(jdbcTIL.getCode());
                this.transactionIsolationLevel = jdbcTIL.getCode();
            }
            catch (SQLException e) {
                throw new JDBCException(e, (DBCExecutionContext)this);
            }
        }
        finally {
            QMUtils.getDefaultHandler().handleTransactionIsolation(this, transactionIsolation);
        }
    }

    @Override
    public boolean isAutoCommit() throws DBCException {
        if (this.autoCommit == null) {
            if (!RuntimeUtils.runTask(monitor -> {
                try {
                    DBExecUtils.tryExecuteRecover(monitor, this.getDataSource(), monitor1 -> {
                        try {
                            this.autoCommit = this.getConnection().getAutoCommit();
                        }
                        catch (Exception e) {
                            log.error("Error getting auto commit state", e);
                        }
                    });
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }, "Get auto commit state", 5000L)) {
                throw new DBCException("Can't determine auto-commit state - timeout");
            }
            if (this.autoCommit == null) {
                log.error("Cannot determine autocommit state due to connection hanging. Setting to manual commit mode.");
                this.autoCommit = false;
            }
        }
        return this.autoCommit;
    }

    private boolean isAutoCommit(boolean defaultValue) {
        try {
            return this.isAutoCommit();
        }
        catch (DBCException e) {
            log.debug("Unable to determine if connection is in autocommit mode", e);
            return defaultValue;
        }
    }

    @Override
    public void setAutoCommit(@NotNull DBRProgressMonitor monitor, boolean autoCommit) throws DBCException {
        monitor.subTask("Set JDBC connection auto-commit " + autoCommit);
        try {
            try {
                Connection dbCon = this.getConnection();
                dbCon.setAutoCommit(autoCommit);
                this.autoCommit = dbCon.getAutoCommit();
            }
            catch (SQLException e) {
                throw new JDBCException(e, (DBCExecutionContext)this);
            }
        }
        finally {
            QMUtils.getDefaultHandler().handleTransactionAutocommit(this, autoCommit);
        }
    }

    @Override
    public DBCSavepoint setSavepoint(@NotNull DBRProgressMonitor monitor, String name) throws DBCException {
        Savepoint savepoint;
        try {
            Connection dbCon = this.getConnection();
            savepoint = name == null ? dbCon.setSavepoint() : dbCon.setSavepoint(name);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, this);
        }
        return new JDBCSavepointImpl(this, savepoint);
    }

    @Override
    public boolean supportsSavepoints() {
        return ((JDBCDataSource)this.getDataSource()).getInfo().supportsSavepoints();
    }

    @Override
    public void releaseSavepoint(@NotNull DBRProgressMonitor monitor, @NotNull DBCSavepoint savepoint) throws DBCException {
        block4: {
            try {
                Connection dbCon = this.getConnection();
                if (savepoint instanceof JDBCSavepointImpl) {
                    dbCon.releaseSavepoint(((JDBCSavepointImpl)savepoint).getOriginal());
                    break block4;
                }
                if (savepoint instanceof Savepoint) {
                    dbCon.releaseSavepoint((Savepoint)((Object)savepoint));
                    break block4;
                }
                throw new SQLFeatureNotSupportedException(ModelMessages.model_jdbc_exception_bad_savepoint_object);
            }
            catch (SQLException e) {
                throw new JDBCException(e, (DBCExecutionContext)this);
            }
        }
    }

    @Override
    public void commit(@NotNull DBCSession session) throws DBCException {
        try {
            try {
                this.getConnection().commit();
            }
            catch (SQLException e) {
                throw new JDBCException(e, (DBCExecutionContext)this);
            }
        }
        finally {
            if (session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleTransactionCommit(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback(@NotNull DBCSession session, DBCSavepoint savepoint) throws DBCException {
        try {
            try {
                Connection dbCon = this.getConnection();
                if (savepoint != null) {
                    if (savepoint instanceof JDBCSavepointImpl) {
                        dbCon.rollback(((JDBCSavepointImpl)savepoint).getOriginal());
                        return;
                    } else {
                        if (!(savepoint instanceof Savepoint)) throw new SQLFeatureNotSupportedException(ModelMessages.model_jdbc_exception_bad_savepoint_object);
                        dbCon.rollback((Savepoint)((Object)savepoint));
                    }
                    return;
                } else {
                    dbCon.rollback();
                }
                return;
            }
            catch (SQLException e) {
                throw new JDBCException(e, (DBCExecutionContext)this);
            }
        }
        finally {
            if (session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleTransactionRollback(this, savepoint);
            }
        }
    }

    @Override
    public boolean isSupportsTransactions() {
        return this.instance.getDataSource().getInfo().supportsTransactions();
    }

    public void reconnect(DBRProgressMonitor monitor) throws DBCException {
        this.close();
        this.connect(monitor, null, null, this, true);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBCTransactionManager.class) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public String toString() {
        if (CommonUtils.equalObjects((Object)this.instance.getName(), (Object)((JDBCDataSource)this.dataSource).getName())) {
            return super.toString();
        }
        return String.valueOf(((JDBCDataSource)this.dataSource).getName()) + " - " + this.instance.getName() + " - " + this.getContextName();
    }
}

