/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.qm.QMEvent;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.utils.CommonUtils;

public class QMMetaEventEntity
implements QMEvent {
    private final long id;
    private final QMSessionInfo sessionInfo;
    private final QMMObject object;
    private final QMEventAction action;

    public QMMetaEventEntity(QMMObject object, QMEventAction action, long id, String sessionId, @Nullable QMSessionInfo sessionInfo) {
        this.id = id;
        this.sessionInfo = sessionInfo;
        this.object = object;
        this.action = action;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public QMSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    @Override
    public QMMObject getObject() {
        return this.object;
    }

    @Override
    public QMEventAction getAction() {
        return this.action;
    }

    public static Map<String, Object> toMap(QMMetaEventEntity event) throws DBException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("objectClassName", event.getObject().getClass().getName());
        result.put("object", event.getObject().toMap());
        result.put("action", event.getAction().getId());
        result.put("id", event.getId());
        if (event.getSessionInfo() != null) {
            result.put("sessionName", event.getSessionInfo().getUserName());
            result.put("sessionId", event.getSessionInfo().getUserDomain());
        }
        return result;
    }

    public static QMMetaEventEntity fromMap(Map<String, Object> map) {
        String className = CommonUtils.toString((Object)map.get("objectClassName"));
        Map object = (Map)map.get("object");
        QMMObject eventObject = className.equals(QMMConnectionInfo.class.getName()) ? QMMConnectionInfo.fromMap(object) : (className.equals(QMMStatementExecuteInfo.class.getName()) ? QMMStatementExecuteInfo.fromMap(object) : (className.equals(QMMStatementInfo.class.getName()) ? QMMStatementInfo.fromMap(object) : (className.equals(QMMTransactionInfo.class.getName()) ? QMMTransactionInfo.fromMap(object) : null)));
        QMEventAction action = QMEventAction.getById(CommonUtils.toInt((Object)map.get("action")));
        long id = CommonUtils.toLong((Object)map.get("id"));
        QMSessionInfo sessionInfo = null;
        String sessionUserName = CommonUtils.toString((Object)map.get("sessionName"));
        String sessionUserDomain = CommonUtils.toString((Object)map.get("sessionId"));
        if (!sessionUserName.isEmpty()) {
            sessionInfo = new QMSessionInfo(sessionUserName, sessionUserDomain);
        }
        return new QMMetaEventEntity(eventObject, action, id, "", sessionInfo);
    }
}

