/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.time.OffsetDateTime;
import java.util.Set;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.rm.RMObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class RMProject
extends RMObject {
    public static final String PREFIX_GLOBAL = "g";
    public static final String PREFIX_SHARED = "s";
    public static final String PREFIX_USER = "u";
    public static final Type[] SHARED_PROJECTS = new Type[]{Type.GLOBAL, Type.SHARED};
    private String id;
    private String description;
    private Type type;
    private OffsetDateTime createTime;
    private String creator;
    private Set<String> projectPermissions;

    public RMProject() {
    }

    public RMProject(String id, String name, String description, Type type, OffsetDateTime createTime, String creator, Set<String> projectPermissions) {
        super(name);
        this.id = id;
        this.description = description;
        this.type = type;
        this.createTime = createTime;
        this.creator = creator;
        this.projectPermissions = projectPermissions;
    }

    public RMProject(String name) {
        super(name);
    }

    @Property
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Property
    public boolean isShared() {
        return ArrayUtils.contains((Object[])SHARED_PROJECTS, (Object)((Object)this.getType()));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RMProject && CommonUtils.equalObjects((Object)this.id, (Object)((RMProject)obj).id);
    }

    public void setProjectPermissions(Set<String> projectPermissions) {
        this.projectPermissions = projectPermissions;
    }

    public Set<String> getProjectPermissions() {
        return this.projectPermissions;
    }

    public static enum Type {
        GLOBAL("g"),
        SHARED("s"),
        USER("u");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

