/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class SQLSelectItem {
    private final SQLQuery query;
    private final SelectItem source;
    private final Table table;
    private final String name;
    private boolean plainColumn;

    SQLSelectItem(SQLQuery query, SelectItem item) {
        this.query = query;
        this.source = item;
        if (item instanceof SelectExpressionItem) {
            Expression itemExpression = ((SelectExpressionItem)item).getExpression();
            if (itemExpression instanceof Column) {
                this.table = ((Column)itemExpression).getTable();
                this.name = ((Column)itemExpression).getColumnName();
                this.plainColumn = true;
            } else {
                this.table = null;
                Alias alias = ((SelectExpressionItem)item).getAlias();
                this.name = alias != null ? alias.getName() : item.toString();
            }
        } else if (item instanceof AllColumns) {
            this.table = null;
            this.name = "*";
        } else if (item instanceof AllTableColumns) {
            this.table = ((AllTableColumns)item).getTable();
            this.name = "*";
        } else {
            this.table = null;
            this.name = "?";
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlainColumn() {
        return this.plainColumn;
    }

    public DBCEntityMetaData getEntityMetaData() {
        Table refTable;
        if (this.table == null) {
            return null;
        }
        Database tableDatabase = this.table.getDatabase();
        if (this.table.getAlias() == null && (tableDatabase == null || CommonUtils.isEmpty((String)tableDatabase.getDatabaseName())) && this.table.getSchemaName() == null && this.query.getStatement() instanceof Select && (refTable = SQLSemanticProcessor.findTableByNameOrAlias((Select)this.query.getStatement(), this.table.getName())) != null) {
            return this.query.createTableMetaData(refTable);
        }
        return this.query.createTableMetaData(this.table);
    }

    public String toString() {
        return this.source.toString();
    }
}

