/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.ServerType;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericDataSource;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericDatabase;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericIndex;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericProcedure;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericSchema;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericSynonym;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericTable;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericTrigger;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class SQLServerMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(SQLServerMetaModel.class);
    private final boolean sqlServer;
    private final Map<String, Boolean> sysViewsCache = new HashMap<String, Boolean>();

    public SQLServerMetaModel() {
        this(true);
    }

    public SQLServerMetaModel(boolean sqlServer) {
        this.sqlServer = sqlServer;
    }

    public boolean isSqlServer() {
        return this.sqlServer;
    }

    private boolean isSapIQ(GenericDataSource dataSource) {
        String productName = dataSource.getInfo().getDatabaseProductName();
        return productName != null && (productName.contains("IQ SAP") || productName.contains("SAP IQ") || productName.contains("Sybase IQ"));
    }

    public SQLServerGenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new SQLServerGenericDataSource(monitor, container, this);
    }

    public SQLServerGenericDatabase createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new SQLServerGenericDatabase(dataSource, catalogName);
    }

    public SQLServerGenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new SQLServerGenericSchema(dataSource, catalog, schemaName, 0L);
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return this.extractSource(monitor, (GenericDataSource)sourceObject.getDataSource(), (DBSObject)sourceObject, sourceObject.getCatalog(), sourceObject.getSchema().getName(), sourceObject.getName());
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        block32: {
            if (!this.isSqlServer()) {
                GenericDataSource dataSource = container.getDataSource();
                String dbName = DBUtils.getQuotedIdentifier((DBSObject)container.getParentObject());
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Sybase procedure list");){
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("select distinct so.name as proc_name,su.name as schema_name, so.[type] as type_name\nfrom " + dbName + ".dbo.sysobjects so, " + dbName + ".dbo.sysusers su\n" + "where so.type IN ('P', 'SF')\n" + "and su.uid = so.uid\n" + "and su.name=?");){
                            dbStat.setString(1, container.getName());
                            Throwable throwable3 = null;
                            Object var12_18 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.nextRow()) {
                                    String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type_name");
                                    DBSProcedureType procedureType = DBSProcedureType.PROCEDURE;
                                    if ("SF".equals(typeName)) {
                                        procedureType = DBSProcedureType.FUNCTION;
                                    }
                                    SQLServerGenericProcedure procedure = this.createProcedureImpl((GenericStructContainer)container, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proc_name"), null, null, procedureType, null);
                                    procedure.setSource(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"definition"));
                                    container.addProcedure((GenericProcedure)procedure);
                                }
                                break block32;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e, (DBPDataSource)dataSource);
                }
            }
            super.loadProcedures(monitor, container);
        }
    }

    public SQLServerGenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new SQLServerGenericProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    /*
     * Exception decompiling
     */
    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws SQLException {
        String schema = SQLServerUtils.getSystemSchemaFQN((JDBCDataSource)container.getDataSource(), container.getCatalog().getName(), this.getSystemSchema());
        StringBuilder query = new StringBuilder("SELECT triggers.name as TRIGGER_NAME, triggers.*, tables.name as OWNER FROM " + schema + ".sysobjects triggers");
        GenericSchema tableSchema = table == null ? null : table.getSchema();
        long schemaId = tableSchema instanceof SQLServerGenericSchema ? ((SQLServerGenericSchema)tableSchema).getSchemaId() : 0L;
        query.append(",").append(schema).append(".sysobjects tables").append("\nWHERE triggers.type = 'TR' AND triggers.deltrig = tables.id\n");
        if (table != null) {
            if (schemaId == 0L) {
                query.append("AND user_name(tables.uid) = ?");
            } else {
                query.append("AND tables.uid = ?");
            }
            query.append(" AND tables.name = ?");
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(query.toString());
        if (table != null) {
            if (schemaId == 0L) {
                dbStat.setString(1, tableSchema.getName());
            } else {
                dbStat.setLong(1, schemaId);
            }
            dbStat.setString(2, table.getName());
        }
        return dbStat;
    }

    public GenericTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer genericStructContainer, @NotNull GenericTableBase genericTableBase, String name, @NotNull JDBCResultSet resultSet) throws DBException {
        if (CommonUtils.isEmpty((String)name)) {
            name = JDBCUtils.safeGetString((ResultSet)resultSet, (int)1);
        }
        if (name == null) {
            return null;
        }
        name = name.trim();
        return new SQLServerGenericTrigger(genericTableBase, name, null);
    }

    /*
     * Loose catch block
     */
    public List<GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GenericTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block32: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = (JDBCPreparedStatement)this.prepareTableTriggersLoadStatement(session, container, table);
                    ArrayList<GenericTrigger> result = new ArrayList<GenericTrigger>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            if (name == null) continue;
                            name = name.trim();
                            SQLServerGenericTrigger trigger = new SQLServerGenericTrigger(table, name, null);
                            result.add((GenericTrigger)trigger);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block32;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        GenericTableBase table = ((GenericTableTrigger)trigger).getTable();
        assert (table != null);
        return this.extractSource(monitor, (GenericDataSource)table.getDataSource(), (DBSObject)table, table.getCatalog(), table.getSchema().getName(), trigger.getName());
    }

    public boolean isColumnNotNullByDefault() {
        return true;
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        return null;
    }

    /*
     * Exception decompiling
     */
    private String extractSource(DBRProgressMonitor monitor, GenericDataSource dataSource, DBSObject object, GenericCatalog catalog, String schema, String name) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSybaseSystemView(JDBCSession session, String systemSchema, String viewName) throws SQLException {
        Boolean check;
        Map<String, Boolean> map = this.sysViewsCache;
        synchronized (map) {
            check = this.sysViewsCache.get(viewName);
        }
        if (check == null) {
            check = JDBCUtils.queryString((Connection)session, (String)("SELECT name from " + systemSchema + ".sysobjects where name=?"), (Object[])new Object[]{viewName}) != null;
            map = this.sysViewsCache;
            synchronized (map) {
                this.sysViewsCache.put(viewName, check);
            }
        }
        return check;
    }

    public ServerType getServerType() {
        return this.sqlServer ? ServerType.SQL_SERVER : ServerType.SYBASE;
    }

    public SQLServerGenericIndex createIndexImpl(GenericTableBase table, boolean nonUnique, String qualifier, long cardinality, String indexName, DBSIndexType indexType, boolean persisted) {
        return new SQLServerGenericIndex(table, nonUnique, qualifier, cardinality, indexName, indexType, persisted);
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return "IDENTITY(1,1)";
    }

    public boolean useCatalogInObjectNames() {
        return false;
    }

    public boolean isSchemasOptional() {
        return true;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        boolean showAllSchemas = SQLServerUtils.isShowAllSchemas((DBPDataSource)dataSource);
        DBSObjectFilter schemaFilters = dataSource.getContainer().getObjectFilter(GenericSchema.class, (DBSObject)catalog, false);
        String sysSchema = SQLServerUtils.getSystemSchemaFQN((JDBCDataSource)dataSource, catalog.getName(), this.getSystemSchema());
        String sql = showAllSchemas ? (this.getServerType() == ServerType.SQL_SERVER && dataSource.isServerVersionAtLeast(9, 0) ? "SELECT * FROM " + sysSchema + ".schemas" : "SELECT * FROM " + sysSchema + ".sysusers") : (this.getServerType() == ServerType.SQL_SERVER ? "SELECT DISTINCT s.*\nFROM " + sysSchema + ".schemas s, " + sysSchema + ".sysobjects o\n" + "WHERE s.schema_id=o.uid\n" + "ORDER BY 1" : "SELECT DISTINCT u.name,u.uid\nFROM " + sysSchema + ".sysusers u, " + sysSchema + ".sysobjects o\n" + "WHERE u.uid=o.uid\n" + "ORDER BY 1");
        boolean schemaReadFailed = false;
        ArrayList<GenericSchema> result = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                Throwable throwable2 = null;
                Object var14_18 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                        if (name == null) continue;
                        name = name.trim();
                        if (schemaFilters != null && !schemaFilters.matches(name)) continue;
                        long schemaId = this.isSqlServer() ? JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"schema_id") : JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"uid");
                        SQLServerGenericSchema schema = new SQLServerGenericSchema(dataSource, catalog, name, schemaId);
                        result.add(schema);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
            log.warn((Object)"Schema read failed: empty list returned. Try generic method.", (Throwable)e);
            schemaReadFailed = true;
        }
        if (result.isEmpty()) {
            if (!schemaReadFailed && !showAllSchemas) {
                result.add(new GenericSchema(dataSource, catalog, "dbo"));
            } else {
                return super.loadSchemas(session, dataSource, catalog);
            }
        }
        return result;
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return this.getServerType() == ServerType.SQL_SERVER;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + SQLServerUtils.getSystemSchemaFQN((JDBCDataSource)container.getDataSource(), container.getCatalog().getName(), this.getSystemSchema()) + ".sequences WHERE schema_name(schema_id)=?");
        dbStat.setString(1, container.getSchema().getName());
        return dbStat;
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        name = name.trim();
        return new GenericSequence(container, name, null, (Number)CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"current_value")), (Number)CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"minimum_value")), (Number)CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"maximum_value")), (Number)CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"increment")));
    }

    public boolean supportsSynonyms(@NotNull GenericDataSource dataSource) {
        return this.isSqlServer();
    }

    public JDBCStatement prepareSynonymsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + SQLServerUtils.getSystemSchemaFQN((JDBCDataSource)container.getDataSource(), container.getCatalog().getName(), this.getSystemSchema()) + ".synonyms WHERE schema_name(schema_id)=?");
        dbStat.setString(1, container.getSchema().getName());
        return dbStat;
    }

    public GenericSynonym createSynonymImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        name = name.trim();
        return new SQLServerGenericSynonym(container, name, null, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"base_object_name"));
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new SQLServerGenericView(container, tableName, tableType, dbResult);
        }
        return new SQLServerGenericTable(container, tableName, tableType, dbResult);
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new SQLServerGenericTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public boolean isSystemTable(GenericTableBase table) {
        return table.getSchema() != null && this.getSystemSchema().equals(table.getSchema().getName()) && table.getName().startsWith("sys");
    }

    @NotNull
    private String getSystemSchema() {
        return this.sqlServer ? "sys" : "dbo";
    }
}

