/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IDataController;
import org.jkiss.dbeaver.ui.data.IRowController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;

public class ResultSetValueController
implements IAttributeController,
IRowController {
    protected final IResultSetController controller;
    protected Composite inlinePlaceholder;
    protected IValueController.EditType editType;
    protected ResultSetCellLocation cellLocation;

    public ResultSetValueController(@NotNull IResultSetController controller, @NotNull ResultSetCellLocation cellLocation, @NotNull IValueController.EditType editType, @Nullable Composite inlinePlaceholder) {
        this.controller = controller;
        this.cellLocation = cellLocation;
        this.editType = editType;
        this.inlinePlaceholder = inlinePlaceholder;
    }

    public void setCellLocation(ResultSetCellLocation cellLocation) {
        this.cellLocation = cellLocation;
    }

    public ResultSetRow getCurRow() {
        return this.cellLocation.getRow();
    }

    public void setCurRow(ResultSetRow curRow, int[] rowIndexes) {
        this.cellLocation = new ResultSetCellLocation(this.cellLocation.getAttribute(), curRow, rowIndexes);
    }

    public int[] getRowIndexes() {
        return this.cellLocation.getRowIndexes();
    }

    @Override
    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.controller.getExecutionContext();
    }

    @Override
    @NotNull
    public IDataController getDataController() {
        return this.controller;
    }

    @Override
    public String getValueName() {
        return this.getBinding().getName();
    }

    @Override
    public DBSTypedObject getValueType() {
        return this.getBinding().getPresentationAttribute();
    }

    @Override
    @NotNull
    public IRowController getRowController() {
        return this;
    }

    @Override
    @NotNull
    public DBDAttributeBinding getBinding() {
        return this.cellLocation.getAttribute();
    }

    public void setBinding(DBDAttributeBinding binding) {
        this.cellLocation = new ResultSetCellLocation(binding, this.cellLocation.getRow(), this.cellLocation.getRowIndexes());
    }

    @Override
    @NotNull
    public String getColumnId() {
        DBCExecutionContext context = this.getExecutionContext();
        DBCAttributeMetaData metaAttribute = this.getBinding().getMetaAttribute();
        if (metaAttribute == null) {
            metaAttribute = this.getBinding().getAttribute();
        }
        if (metaAttribute == null) {
            return this.getBinding().getName();
        }
        return DBUtils.getSimpleQualifiedName((Object[])new Object[]{context == null ? null : context.getDataSource().getContainer().getName(), metaAttribute instanceof DBCAttributeMetaData ? metaAttribute.getEntityName() : "", metaAttribute.getName()});
    }

    @Override
    public Object getValue() {
        return this.controller.getModel().getCellValue(this.cellLocation);
    }

    @Override
    public void updateValue(@Nullable Object value, boolean updatePresentation) {
        boolean updated;
        try {
            updated = this.controller.getModel().updateCellValue(this.cellLocation, value);
        }
        catch (Exception e) {
            UIUtils.asyncExec(() -> DBWorkbench.getPlatformUI().showError("Value update", "Error updating value: " + e.getMessage(), (Throwable)e));
            return;
        }
        if (updated && updatePresentation) {
            UIUtils.syncExec(() -> this.controller.updatePanelsContent(false));
            if (this.controller instanceof ResultSetViewer) {
                ((ResultSetViewer)this.controller).fireResultSetChange();
            }
        }
    }

    @Override
    public void updateSelectionValue(Object value) {
        this.updateValue(value, true);
    }

    @Override
    @Nullable
    public DBDRowIdentifier getRowIdentifier() {
        return this.getBinding().getRowIdentifier();
    }

    @Override
    public DBDValueHandler getValueHandler() {
        return this.getBinding().getValueHandler();
    }

    private DBPDataSourceContainer getDataSourceContainer() {
        IResultSetContainer rsContainer = this.controller.getContainer();
        if (rsContainer instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)rsContainer).getDataSourceContainer();
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        return executionContext == null ? null : executionContext.getDataSource().getContainer();
    }

    @Override
    public IValueManager getValueManager() {
        Object value;
        DBSAttributeBase valueType = this.getBinding().getPresentationAttribute();
        DBDValueHandler valueHandler = this.getBinding().getValueHandler();
        if (valueType.getDataKind() == DBPDataKind.ARRAY && this.cellLocation.getRowIndexes() != null) {
            try {
                DBSDataType componentType;
                VoidProgressMonitor monitor = new VoidProgressMonitor();
                DBSDataType arrayDataType = DBUtils.getDataType((DBSTypedObject)valueType);
                if (arrayDataType == null) {
                    arrayDataType = DBUtils.resolveDataType((DBRProgressMonitor)monitor, (DBPDataSource)this.getBinding().getDataSource(), (String)this.getBinding().getFullTypeName());
                }
                if (arrayDataType != null && (componentType = arrayDataType.getComponentType((DBRProgressMonitor)monitor)) != null) {
                    valueType = componentType;
                    valueHandler = DBUtils.findValueHandler((DBPDataSource)this.getBinding().getDataSource(), (DBSTypedObject)valueType);
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Data type resolve", "Error resolving component data type", (Throwable)e);
            }
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        Class<?> valueObjectType = valueHandler.getValueObjectType((DBSTypedObject)valueType);
        if (valueObjectType == Object.class && (value = this.getValue()) != null) {
            valueObjectType = value.getClass();
        }
        return ValueManagerRegistry.findValueManager(executionContext == null ? null : executionContext.getDataSource(), (DBSTypedObject)valueType, valueObjectType);
    }

    @Override
    public IValueController.EditType getEditType() {
        return this.editType;
    }

    public void setEditType(IValueController.EditType editType) {
        this.editType = editType;
    }

    @Override
    public boolean isReadOnly() {
        return this.controller.getAttributeReadOnlyStatus(this.getBinding()) != null;
    }

    @Override
    public IWorkbenchPartSite getValueSite() {
        return this.controller.getSite();
    }

    @Override
    @Nullable
    public Composite getEditPlaceholder() {
        return this.inlinePlaceholder;
    }

    @Override
    public void refreshEditor() {
        this.controller.updatePanelsContent(true);
    }

    @Override
    public void showMessage(String message, DBPMessageType messageType) {
        UIUtils.asyncExec(() -> this.controller.setStatus(message, messageType));
    }

    @Override
    @NotNull
    public List<DBDAttributeBinding> getRowAttributes() {
        return Arrays.asList(this.controller.getModel().getAttributes());
    }

    @Override
    @Nullable
    public Object getAttributeValue(DBDAttributeBinding attribute) {
        return this.controller.getModel().getCellValue(this.cellLocation);
    }
}

