/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.utils.CommonUtils;

final class ValidateUniqueKeyUsageDialog
extends MessageDialog {
    @NotNull
    private final ResultSetViewer viewer;

    private ValidateUniqueKeyUsageDialog(@NotNull ResultSetViewer viewer) {
        super(viewer.getControl().getShell(), ResultSetMessages.validate_unique_key_usage_dialog_title, null, ResultSetMessages.validate_unique_key_usage_dialog_main_question, 4, new String[]{ResultSetMessages.validate_unique_key_usage_dialog_use_all_columns, ResultSetMessages.validate_unique_key_usage_dialog_custom_unique_key, IDialogConstants.CANCEL_LABEL}, 2);
        this.viewer = viewer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                if (!ValidateUniqueKeyUsageDialog.useAllColumns(this.viewer)) break;
                super.buttonPressed(0);
                break;
            }
            case 1: {
                this.editCustomKey();
                break;
            }
            case 2: {
                super.buttonPressed(1);
            }
        }
    }

    private void editCustomKey() {
        if (this.viewer.editEntityIdentifier()) {
            super.buttonPressed(0);
        }
    }

    private static boolean useAllColumns(ResultSetViewer viewer) {
        DBDRowIdentifier identifier = viewer.getVirtualEntityIdentifier();
        DBVEntityConstraint constraint = (DBVEntityConstraint)identifier.getUniqueKey();
        ArrayList<DBSEntityAttribute> uniqueColumns = new ArrayList<DBSEntityAttribute>();
        DBDAttributeBinding[] dBDAttributeBindingArray = viewer.getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (binding.getEntityAttribute() != null) {
                uniqueColumns.add(binding.getEntityAttribute());
            }
            ++n2;
        }
        if (uniqueColumns.isEmpty()) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.validate_unique_key_usage_dialog_use_all_columns, ResultSetMessages.validate_unique_key_usage_dialog_use_all_columns_no_valid_columns_found);
            return false;
        }
        constraint.setAttributes(uniqueColumns);
        constraint.setUseAllColumns(true);
        try {
            identifier.reloadAttributes((DBRProgressMonitor)new VoidProgressMonitor(), viewer.getModel().getAttributes());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.validate_unique_key_usage_dialog_use_all_columns, ResultSetMessages.validate_unique_key_usage_dialog_use_all_columns_cannot_reload_unique_columns, (Throwable)e);
            return false;
        }
        return true;
    }

    static boolean validateUniqueKey(@NotNull ResultSetViewer viewer, @NotNull DBCExecutionContext executionContext) {
        DBDRowIdentifier identifier = viewer.getVirtualEntityIdentifier();
        if (identifier == null) {
            return false;
        }
        if (!CommonUtils.isEmpty((Collection)identifier.getAttributes())) {
            return true;
        }
        if (executionContext.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.edit.key.use_all_columns") && ValidateUniqueKeyUsageDialog.useAllColumns(viewer)) {
            return true;
        }
        ValidateUniqueKeyUsageDialog dialog = new ValidateUniqueKeyUsageDialog(viewer);
        int result = dialog.open();
        return result == 0;
    }
}

