/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarHandler;

class WorkbenchContextListener
implements IWindowListener,
IPageListener,
IPartListener {
    public static final String PERSPECTIVE_CONTEXT_ID = "org.jkiss.dbeaver.ui.perspective";
    private CommandExecutionListener commandExecutionListener;
    private final Set<IWorkbenchWindow> registeredWindows = new HashSet<IWorkbenchWindow>();

    public WorkbenchContextListener() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.listenWindowEvents(window);
            ++n2;
        }
        workbench.addWindowListener((IWindowListener)this);
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService != null) {
            this.commandExecutionListener = new CommandExecutionListener();
            commandService.addExecutionListener((IExecutionListener)this.commandExecutionListener);
        }
        workbench.addWindowListener((IWindowListener)this);
        workbench.addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
                DesktopPlatform.setClosing(true);
            }
        });
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            this.windowActivated(activeWindow);
            IWorkbenchPage activePage = activeWindow.getActivePage();
            if (activePage != null) {
                this.pageActivated(activePage);
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart != null) {
                    this.partActivated(activePart);
                }
            }
        }
    }

    private void listenWindowEvents(IWorkbenchWindow window) {
        if (!this.registeredWindows.contains(window)) {
            DataSourceToolbarHandler toolbarHandler = new DataSourceToolbarHandler(window);
            window.getShell().addDisposeListener(e -> toolbarHandler.dispose());
            this.registeredWindows.add(window);
        }
        IPerspectiveListener perspectiveListener = new IPerspectiveListener(){
            private IContextActivation perspectiveActivation;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
                if (contextService == null) {
                    return;
                }
                if (perspective.getId().equals("org.jkiss.dbeaver.core.perspective")) {
                    this.perspectiveActivation = contextService.activateContext(WorkbenchContextListener.PERSPECTIVE_CONTEXT_ID);
                } else if (this.perspectiveActivation != null) {
                    contextService.deactivateContext(this.perspectiveActivation);
                    this.perspectiveActivation = null;
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        window.addPerspectiveListener(perspectiveListener);
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            perspectiveListener.perspectiveActivated(activePage, activePage.getPerspective());
        }
        window.addPageListener((IPageListener)this);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            page.addPartListener((IPartListener)this);
            ++n2;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.listenWindowEvents(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        this.activatePartContexts(part);
    }

    void activatePartContexts(IWorkbenchPart part) {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        try {
            contextService.deferUpdates(true);
            ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit", "org.jkiss.dbeaver.ui.editors.sql.connection.separate"});
        }
        finally {
            contextService.deferUpdates(false);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.deactivatePartContexts(part);
    }

    void deactivatePartContexts(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    static WorkbenchContextListener registerInWorkbench() {
        return new WorkbenchContextListener();
    }

    private static class CommandExecutionListener
    implements IExecutionListener {
        private CommandExecutionListener() {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            DBRFeature commandFeature = DBRFeatureRegistry.getInstance().findCommandFeature(commandId);
            if (commandFeature != null) {
                commandFeature.use();
            }
        }

        public void preExecute(String commandId, ExecutionEvent event) {
        }
    }
}

