/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.fs.nio.NIOFile;
import org.jkiss.dbeaver.model.fs.nio.NIOFileStore;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DefaultResourceHandlerImpl
extends AbstractResourceHandler {
    public static final DefaultResourceHandlerImpl INSTANCE = new DefaultResourceHandlerImpl();

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        if (resource instanceof IFolder) {
            return 30;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        ProgramInfo program = ProgramInfo.getProgram((IResource)resource);
        if (program != null) {
            return program.getProgram().getName();
        }
        return "resource";
    }

    public String getResourceDescription(@NotNull IResource resource) {
        return "";
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        DBNResource node = super.makeNavigatorNode(parentNode, resource);
        this.updateNavigatorNodeFromResource((DBNNodeWithResource)node, resource);
        return node;
    }

    public void updateNavigatorNodeFromResource(@NotNull DBNNodeWithResource node, @NotNull IResource resource) {
        super.updateNavigatorNodeFromResource(node, resource);
        String fileExtension = resource.getFileExtension();
        if (!CommonUtils.isEmpty((String)fileExtension)) {
            this.setNodeIconFromFileType(node, fileExtension);
        }
    }

    public void setNodeIconFromFileType(@NotNull DBNNodeWithResource node, @NotNull String fileExt) {
        ProgramInfo program = ProgramInfo.getProgram((String)fileExt);
        if (program != null && program.getImage() != null) {
            node.setResourceImage(program.getImage());
        }
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        block11: {
            if (resource instanceof NIOFile) {
                IEditorDescriptor editorDesc;
                NIOFileStore fileStore = new NIOFileStore(resource.getLocationURI(), ((NIOFile)resource).getNioPath());
                try {
                    editorDesc = IDE.getEditorDescriptor((IFile)((IFile)resource), (boolean)true, (boolean)true);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
                try {
                    Path[] target = new Path[1];
                    UIUtils.runInProgressService(monitor -> {
                        try {
                            pathArray[0] = Files.createTempFile(DBWorkbench.getPlatform().getTempFolder(monitor, "external-files").toPath(), null, fileStore.getName(), new FileAttribute[0]);
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (InputStream is = fileStore.openInputStream(0, null);){
                                Throwable throwable2 = null;
                                Object var7_11 = null;
                                try (OutputStream os = Files.newOutputStream(target[0], new OpenOption[0]);){
                                    IFileInfo info = fileStore.fetchInfo(0, null);
                                    ContentUtils.copyStreams((InputStream)is, (long)info.getLength(), (OutputStream)os, (DBRProgressMonitor)monitor);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                    if ("org.eclipse.ui.systemExternalEditor".equals(editorDesc.getId())) {
                        Program.launch((String)target[0].toString());
                        break block11;
                    }
                    IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (URI)target[0].toUri(), (String)editorDesc.getId(), (boolean)true);
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Error opening resource", "Can't open resource using external editor", e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            } else if (resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
            } else if (resource instanceof IFolder) {
                DBWorkbench.getPlatformUI().executeShellProgram(resource.getLocation().toOSString());
            }
        }
    }
}

