/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.auth;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.auth.AuthProviderDescriptor;

public class AuthProviderRegistry {
    private static final Log log = Log.getLog(AuthProviderRegistry.class);
    private static final String TAG_AUTH_PROVIDER = "authProvider";
    private static final String TAG_AUTH_PROVIDER_DISABLE = "authProviderDisable";
    private static AuthProviderRegistry instance = null;
    private final Map<String, AuthProviderDescriptor> authProviders = new LinkedHashMap<String, AuthProviderDescriptor>();

    public static synchronized AuthProviderRegistry getInstance() {
        if (instance == null) {
            instance = new AuthProviderRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private AuthProviderRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.auth.provider");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_AUTH_PROVIDER.equals(ext.getName())) {
                AuthProviderDescriptor providerDescriptor = new AuthProviderDescriptor(ext);
                this.authProviders.put(providerDescriptor.getId(), providerDescriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extConfigs;
        n = extConfigs.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_AUTH_PROVIDER_DISABLE.equals(ext.getName())) {
                String providerId = ext.getAttribute("id");
                if (!this.authProviders.containsKey(providerId)) {
                    log.warn((Object)("Can't disable auth provider '" + providerId + "' - no such provider found"));
                } else {
                    this.authProviders.remove(providerId);
                }
            }
            ++n2;
        }
    }

    public List<AuthProviderDescriptor> getAuthProviders() {
        return new ArrayList<AuthProviderDescriptor>(this.authProviders.values());
    }

    public AuthProviderDescriptor getAuthProvider(String id) {
        return this.authProviders.get(id);
    }
}

