/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import java.util.Locale;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseArrayValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseBigNumberValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseBoolValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseEnumValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseStructValueHandler;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ClickhouseValueHandlerProvider
implements DBDValueHandlerProvider {
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject type) {
        String lowerTypeName = type.getTypeName().toLowerCase(Locale.ENGLISH);
        if ("enum8".equals(lowerTypeName) || "enum16".equals(lowerTypeName)) {
            return ClickhouseEnumValueHandler.INSTANCE;
        }
        if (type.getDataKind() == DBPDataKind.ARRAY) {
            return ClickhouseArrayValueHandler.INSTANCE;
        }
        if (type.getDataKind() == DBPDataKind.STRUCT) {
            return ClickhouseStructValueHandler.INSTANCE;
        }
        if ("int128".equals(lowerTypeName) || "int256".equals(lowerTypeName) || "uint64".equals(lowerTypeName) || "uint128".equals(lowerTypeName) || "uint256".equals(lowerTypeName)) {
            return new ClickhouseBigNumberValueHandler(type, preferences);
        }
        if ("bool".equals(lowerTypeName)) {
            return ClickhouseBoolValueHandler.INSTANCE;
        }
        return null;
    }
}

