/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;

public class DatabaseEditorUtils {
    public static void setPartBackground(IEditorPart editor, Composite composite) {
        DBCExecutionContext context;
        if (composite == null || composite.isDisposed()) {
            return;
        }
        CTabFolder tabFolder = null;
        Composite rootComposite = composite;
        Composite c = composite;
        while (c != null) {
            if (!c.isDisposed() && c.getParent() instanceof CTabFolder) {
                tabFolder = (CTabFolder)c.getParent();
                break;
            }
            c = c.getParent();
        }
        if (tabFolder != null) {
            tabFolder.setBorderVisible(false);
        }
        DBPDataSourceContainer dsContainer = null;
        if (editor instanceof IDataSourceContainerProvider) {
            dsContainer = ((IDataSourceContainerProvider)editor).getDataSourceContainer();
        } else if (editor instanceof DBPContextProvider && (context = ((DBPContextProvider)editor).getExecutionContext()) != null) {
            dsContainer = context.getDataSource().getContainer();
        }
        if (dsContainer == null) {
            rootComposite.setBackground(null);
        } else {
            Color bgColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)dsContainer.getConnectionConfiguration());
            rootComposite.setData("databaseEditorCompositeBackground", (Object)dsContainer);
            rootComposite.setBackground(bgColor);
        }
    }

    public static void contributeStandardEditorActions(IWorkbenchSite workbenchSite, IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.save", (String)EditorsMessages.database_editor_command_save_name, (DBPImage)UIIcon.SAVE, (String)EditorsMessages.database_editor_command_save_tip, (boolean)true));
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.revert", (String)EditorsMessages.database_editor_command_revert_name, (DBPImage)UIIcon.RESET, (String)EditorsMessages.database_editor_command_revert_tip, (boolean)true));
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.refresh", (String)EditorsMessages.database_editor_command_refresh_name, (DBPImage)UIIcon.REFRESH, (String)EditorsMessages.database_editor_command_refresh_tip, (boolean)true));
    }
}

