/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.utils.CommonUtils;

public class ResultSetPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.resultset";
    public static final String PROP_ACTIVE = "active";
    public static final String PROP_HAS_DATA = "hasData";
    public static final String PROP_HAS_MORE_DATA = "hasMoreData";
    public static final String PROP_HAS_FILTERS = "hasfilters";
    public static final String PROP_CAN_COPY = "canCopy";
    public static final String PROP_CAN_PASTE = "canPaste";
    public static final String PROP_CAN_CUT = "canCut";
    public static final String PROP_CAN_MOVE = "canMove";
    public static final String PROP_CAN_TOGGLE = "canToggle";
    public static final String PROP_CAN_SWITCH_PRESENTATION = "canSwitchPresentation";
    public static final String PROP_CAN_NAVIGATE_LINK = "canNavigateLink";
    public static final String PROP_SUPPORTS_COUNT = "supportsCount";
    public static final String PROP_CAN_NAVIGATE_HISTORY = "canNavigateHistory";
    public static final String PROP_EDITABLE = "editable";
    private static final String PROP_CHANGED = "changed";
    private static final String PROP_CAN_PERSIST_DATA = "canPersistData";
    private static final Log log = Log.getLog(ResultSetPropertyTester.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet((IWorkbenchPart)receiver);
            return rsv != null && this.checkResultSetProperty(rsv, property, expectedValue);
        }
        catch (Throwable e) {
            if (!DBWorkbench.getPlatform().isShuttingDown()) {
                log.debug((Object)e);
            }
            return false;
        }
    }

    private boolean checkResultSetProperty(ResultSetViewer rsv, String property, Object expectedValue) {
        boolean actionsDisabled = rsv.isActionsDisabled();
        switch (property) {
            case "active": {
                return true;
            }
            case "hasData": {
                return rsv.getModel().hasData();
            }
            case "hasMoreData": {
                return rsv.isHasMoreData();
            }
            case "hasfilters": {
                return rsv.getModel().getDataFilter().hasFilters();
            }
            case "canCopy": {
                return !actionsDisabled && rsv.getModel().hasData();
            }
            case "canCut": 
            case "canPaste": {
                if (actionsDisabled || !rsv.supportsEdit()) {
                    return false;
                }
                DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                return attr != null && rsv.getAttributeReadOnlyStatus(attr) == null;
            }
            case "canMove": {
                if (actionsDisabled || !rsv.supportsNavigation()) {
                    return false;
                }
                ResultSetRow currentRow = rsv.getCurrentRow();
                if ("back".equals(expectedValue)) {
                    return currentRow != null && currentRow.getVisualNumber() > 0;
                }
                if (!"forward".equals(expectedValue)) break;
                return currentRow != null && currentRow.getVisualNumber() < rsv.getModel().getRowCount() - 1;
            }
            case "editable": {
                if (actionsDisabled || !rsv.hasData() || !rsv.supportsEdit()) {
                    return false;
                }
                if ("edit".equals(expectedValue) || "inline".equals(expectedValue)) {
                    DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                    if (attr == null || !(rsv.getActivePresentation() instanceof IResultSetEditor)) {
                        return false;
                    }
                    if ("inline".equals(expectedValue)) {
                        return rsv.getAttributeReadOnlyStatus(attr) == null;
                    }
                    return rsv.getCurrentRow() != null;
                }
                if ("add".equals(expectedValue)) {
                    return rsv.isInsertable();
                }
                if ("copy".equals(expectedValue) || "delete".equals(expectedValue)) {
                    ResultSetRow currentRow = rsv.getCurrentRow();
                    return currentRow != null && rsv.isInsertable();
                }
                return false;
            }
            case "changed": {
                return rsv.isDirty();
            }
            case "canToggle": {
                return !actionsDisabled && rsv.isPresentationInFocus();
            }
            case "canSwitchPresentation": {
                return !actionsDisabled && !rsv.isRefreshInProgress() && !rsv.getAvailablePresentations().isEmpty();
            }
            case "supportsCount": {
                return rsv.hasData() && rsv.isHasMoreData() && rsv.getDataContainer() != null && rsv.getDataContainer().isFeatureSupported("data.count");
            }
            case "canNavigateLink": {
                DBDAttributeBinding attr;
                ResultSetRow row;
                if (!actionsDisabled && rsv.getModel().hasData() && (row = rsv.getCurrentRow()) != null && (attr = rsv.getActivePresentation().getCurrentAttribute()) != null) {
                    Object value = rsv.getModel().getCellValue(attr, row);
                    return !CommonUtils.isEmpty((Collection)attr.getReferrers()) && !DBUtils.isNullValue((Object)value);
                }
                return false;
            }
            case "canNavigateHistory": {
                if (!actionsDisabled && rsv.getModel().hasData()) {
                    if (expectedValue instanceof Number && ((Number)expectedValue).intValue() == 1 || "1".equals(expectedValue)) {
                        return rsv.getHistoryPosition() < rsv.getHistorySize() - 1;
                    }
                    return rsv.getHistoryPosition() > 0;
                }
                return false;
            }
            case "canPersistData": {
                return !rsv.getModel().isUpdateInProgress();
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.resultset." + propName));
    }
}

