/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ERDPersistedState {
    public static final String TAG_DIAGRAM = "diagram";
    public static final String TAG_ENTITIES = "entities";
    public static final String TAG_DATA_SOURCE = "data-source";
    public static final String TAG_ENTITY = "entity";
    public static final String TAG_PATH = "path";
    public static final String TAG_RELATIONS = "relations";
    public static final String TAG_RELATION = "relation";
    public static final String TAG_BEND = "bend";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TIME = "time";
    public static final String ATTR_ALIAS = "alias";
    public static final String ATTR_ID = "id";
    public static final String ATTR_ORDER = "order";
    public static final String ATTR_TRANSPARENT = "transparent";
    public static final String ATTR_COLOR_BG = "color-bg";
    public static final String ATTR_COLOR_FG = "color-fg";
    public static final String ATTR_FONT = "font";
    public static final String ATTR_BORDER_WIDTH = "border-width";
    public static final String ATTR_FQ_NAME = "fq-name";
    public static final String ATTR_REF_NAME = "ref-name";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_PK_REF = "pk-ref";
    public static final String ATTR_FK_REF = "fk-ref";
    public static final String ATTR_ATTRIBUTE_VISIBILITY = "showAttrs";
    public static final String TAG_COLUMN = "column";
    public static final String ATTR_X = "x";
    public static final String ATTR_Y = "y";
    public static final String ATTR_W = "w";
    public static final String ATTR_H = "h";
    public static final int ERD_VERSION_1 = 1;
    public static final String BEND_ABSOLUTE = "abs";
    public static final String BEND_RELATIVE = "rel";
    public static final String TAG_NOTES = "notes";
    public static final String TAG_NOTE = "note";

    public static List<DBPDataSourceContainer> extractContainers(DBPProject project, InputStream is) throws IOException, XMLException, DBException {
        ArrayList<DBPDataSourceContainer> containers = new ArrayList<DBPDataSourceContainer>();
        Document document = XMLUtils.parseDocument((InputStream)is);
        Element diagramElem = document.getDocumentElement();
        Element entitiesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_ENTITIES);
        if (entitiesElem != null) {
            for (Element dsElem : XMLUtils.getChildElementList((Element)entitiesElem, (String)TAG_DATA_SOURCE)) {
                DBPDataSourceContainer dataSourceContainer;
                String dsId = dsElem.getAttribute(ATTR_ID);
                if (CommonUtils.isEmpty((String)dsId) || (dataSourceContainer = project.getDataSourceRegistry().getDataSource(dsId)) == null) continue;
                containers.add(dataSourceContainer);
            }
        }
        return containers;
    }
}

