/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.spanner.ui.config;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.spanner.ui.internal.SpannerMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.utils.CommonUtils;

public class SpannerAuthConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private TextWithOpenFile privateKeyFile;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        UIUtils.createControlLabel((Composite)authPanel, (String)SpannerMessages.label_private_key_path);
        this.privateKeyFile = new TextWithOpenFile(authPanel, SpannerMessages.label_private_key_path, new String[]{"*", "*.json"});
        GridData gd = new GridData(800);
        this.privateKeyFile.setLayoutData((Object)gd);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.privateKeyFile != null) {
            this.privateKeyFile.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("PvtKeyPath")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.privateKeyFile != null) {
            connectionInfo.setProviderProperty("PvtKeyPath", this.privateKeyFile.getText().trim());
        }
        super.saveSettings(dataSource);
    }
}

