/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.task;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferJob;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.DataTransferState;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;

public class DTTaskHandlerTransfer
implements DBTTaskHandler {
    private static final Log log = Log.getLog(DTTaskHandlerTransfer.class);
    private final DBCStatistics totalStatistics = new DBCStatistics();

    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        DataTransferSettings[] settings = new DataTransferSettings[1];
        try {
            runnableContext.run(true, true, monitor -> {
                dataTransferSettingsArray[0] = new DataTransferSettings(monitor, task, log, Collections.emptyMap(), new DataTransferState());
                settings[0].loadNodeSettings(monitor);
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error loading task settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return new DBTTaskRunStatus();
        }
        this.executeWithSettings(runnableContext, task, locale, log, listener, settings[0]);
        return DBTTaskRunStatus.makeStatisticsStatus((DBCStatistics)this.totalStatistics);
    }

    public void executeWithSettings(@NotNull DBRRunnableContext runnableContext, @Nullable DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull DBTTaskExecutionListener listener, DataTransferSettings settings) throws DBException {
        listener.taskStarted(task);
        int indexOfLastPipeWithDisabledReferentialIntegrity = -1;
        try {
            try {
                indexOfLastPipeWithDisabledReferentialIntegrity = this.initializePipes(runnableContext, settings);
                Throwable error = this.runDataTransferJobs(runnableContext, task, locale, log, listener, settings);
                listener.taskFinished(task, null, error, (Object)settings);
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError(DTMessages.data_transfer_task_handler_unexpected_error_title, DTMessages.data_transfer_task_handler_unexpected_error_message, e.getCause());
                throw new DBException("Error starting data transfer", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                this.restoreReferentialIntegrity(runnableContext, settings.getDataPipes().subList(0, indexOfLastPipeWithDisabledReferentialIntegrity + 1));
            }
        }
        finally {
            this.restoreReferentialIntegrity(runnableContext, settings.getDataPipes().subList(0, indexOfLastPipeWithDisabledReferentialIntegrity + 1));
        }
    }

    private int initializePipes(@NotNull DBRRunnableContext runnableContext, @NotNull DataTransferSettings settings) throws InvocationTargetException, InterruptedException, DBException {
        int[] indexOfLastPipeWithDisabledReferentialIntegrity = new int[]{-1};
        DBException[] dbException = new DBException[1];
        List<DataTransferPipe> dataPipes = settings.getDataPipes();
        runnableContext.run(true, false, monitor -> {
            monitor.beginTask("Initialize pipes", dataPipes.size());
            try {
                try {
                    int i = 0;
                    while (i < dataPipes.size()) {
                        DataTransferPipe pipe = (DataTransferPipe)dataPipes.get(i);
                        pipe.initPipe(settings, i, dataPipes.size());
                        IDataTransferConsumer<?, ?> consumer = pipe.getConsumer();
                        consumer.startTransfer(monitor);
                        if (DTTaskHandlerTransfer.enableReferentialIntegrity(consumer, monitor, false)) {
                            nArray[0] = i;
                        }
                        monitor.worked(1);
                        ++i;
                    }
                }
                catch (DBException e) {
                    dBExceptionArray[0] = e;
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        });
        if (dbException[0] != null) {
            throw dbException[0];
        }
        return indexOfLastPipeWithDisabledReferentialIntegrity[0];
    }

    @Nullable
    private Throwable runDataTransferJobs(@NotNull DBRRunnableContext runnableContext, DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull DBTTaskExecutionListener listener, @NotNull DataTransferSettings settings) {
        int totalJobs = settings.getDataPipes().size();
        if (totalJobs > settings.getMaxJobCount()) {
            totalJobs = settings.getMaxJobCount();
        }
        Throwable error = null;
        int i = 0;
        while (i < totalJobs) {
            DataTransferJob job = new DataTransferJob(settings, task, locale, log, listener);
            try {
                runnableContext.run(true, true, (DBRRunnableWithProgress)job);
                this.totalStatistics.accumulate(job.getTotalStatistics());
            }
            catch (InvocationTargetException e) {
                error = e.getTargetException();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            ++i;
        }
        return error;
    }

    private void restoreReferentialIntegrity(@NotNull DBRRunnableContext runnableContext, @NotNull List<DataTransferPipe> pipes) throws DBException {
        DBException[] firstDBException = new DBException[1];
        try {
            runnableContext.run(true, false, monitor -> {
                try {
                    monitor.beginTask("Post transfer work", pipes.size());
                    for (DataTransferPipe pipe : pipes) {
                        block6: {
                            try {
                                DTTaskHandlerTransfer.enableReferentialIntegrity(pipe.getConsumer(), monitor, true);
                            }
                            catch (DBException e) {
                                log.debug((Object)"enabling referential integrity unexpectedly failed", (Throwable)e);
                                if (firstDBException[0] != null) break block6;
                                dBExceptionArray[0] = e;
                            }
                        }
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(DTMessages.data_transfer_task_handler_resoring_referential_integrity_unexpected_error_title, DTMessages.data_transfer_task_handler_resoring_referential_integrity_unexpected_error_message, e.getCause());
        }
        if (firstDBException[0] != null) {
            throw new DBException("Unable to restore referential integrity properly", (Throwable)firstDBException[0]);
        }
    }

    private static boolean enableReferentialIntegrity(@NotNull IDataTransferConsumer<?, ?> consumer, @NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        if (!(consumer instanceof DatabaseTransferConsumer)) {
            return false;
        }
        DatabaseTransferConsumer databaseTransferConsumer = (DatabaseTransferConsumer)consumer;
        DatabaseConsumerSettings settings = databaseTransferConsumer.getSettings();
        if (settings.isDisableReferentialIntegrity() && databaseTransferConsumer.supportsChangingReferentialIntegrity(monitor)) {
            databaseTransferConsumer.enableReferentialIntegrity(monitor, enable);
            return true;
        }
        return false;
    }
}

