/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndexColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;

public class SQLServerTableIndexColumn
extends AbstractTableIndexColumn
implements SQLServerObject {
    private SQLServerTableIndex index;
    private SQLServerTableColumn tableColumn;
    private int ordinalPosition;
    private boolean ascending;
    private boolean included;
    private long objectId;

    public SQLServerTableIndexColumn(SQLServerTableIndex index, long objectId, SQLServerTableColumn tableColumn, int ordinalPosition, boolean ascending, boolean included) {
        this.index = index;
        this.objectId = objectId;
        this.tableColumn = tableColumn;
        this.ordinalPosition = ordinalPosition;
        this.ascending = ascending;
        this.included = included;
    }

    SQLServerTableIndexColumn(DBRProgressMonitor monitor, SQLServerTableIndex toIndex, DBSTableIndexColumn source) throws DBException {
        this.index = toIndex;
        if (source.getTableColumn() != null) {
            this.tableColumn = ((SQLServerTableBase)toIndex.getTable()).getAttribute(monitor, source.getTableColumn().getName());
        }
        this.ordinalPosition = source.getOrdinalPosition();
        this.ascending = source.isAscending();
        if (source instanceof SQLServerTableIndexColumn) {
            this.included = ((SQLServerTableIndexColumn)source).isIncluded();
        }
    }

    @NotNull
    public SQLServerTableIndex getIndex() {
        return this.index;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.tableColumn.getName();
    }

    @Property(id="name", viewable=true, order=1)
    @Nullable
    public SQLServerTableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Property(viewable=false, order=2)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Property(viewable=true, order=3)
    public boolean isAscending() {
        return this.ascending;
    }

    @Property(viewable=true, order=4)
    public boolean isIncluded() {
        return this.included;
    }

    @Nullable
    public String getDescription() {
        return this.tableColumn.getDescription();
    }

    public SQLServerTableIndex getParentObject() {
        return this.index;
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.index.getDataSource();
    }

    public long getObjectId() {
        return this.objectId;
    }

    @Override
    @Nullable
    public SQLServerDatabase getDatabase() {
        return this.index.getDatabase();
    }
}

