/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLExecutionContext;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class MySQLSequenceManager
extends SQLObjectEditor<MySQLSequence, MySQLCatalog> {
    protected MySQLSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new MySQLSequence((MySQLCatalog)container, "new_sequence", false);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Sequence", "CREATE SEQUENCE " + ((MySQLSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        MySQLSequence sequence = (MySQLSequence)command.getObject();
        MySQLCatalog curCatalog = ((MySQLExecutionContext)executionContext).getDefaultCatalog();
        if (curCatalog != sequence.getCatalog()) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)sequence.getCatalog()), false));
        }
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create Sequence", sequence.getObjectDefinitionText(monitor, options), true));
        if (curCatalog != null && curCatalog != sequence.getCatalog()) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)curCatalog), false));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        String sql = "DROP SEQUENCE " + ((MySQLSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        SQLDatabasePersistAction action = new SQLDatabasePersistAction("Drop Sequence", sql);
        actions.add((DBEPersistAction)action);
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLSequence> getObjectsCache(MySQLSequence object) {
        return object.getCatalog().getSequenceCache();
    }
}

