/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class PostgrePrivilegeGrant {
    private Kind kind;
    private String grantor;
    private String grantee;
    private String objectCatalog;
    private String objectSchema;
    private String objectName;
    private PostgrePrivilegeType privilegeType;
    private boolean isGrantable;
    private boolean withHierarchy;

    public PostgrePrivilegeGrant(Kind kind, ResultSet dbResult) throws SQLException {
        this.kind = kind;
        this.grantor = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"grantor");
        this.grantee = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"grantee");
        this.privilegeType = PostgrePrivilegeType.fromString(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"privilege_type"));
        this.isGrantable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_grantable");
        switch (kind) {
            case FUNCTION: 
            case PROCEDURE: {
                this.objectCatalog = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"specific_catalog");
                this.objectSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"specific_schema");
                this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"specific_name");
                break;
            }
            case SEQUENCE: {
                this.objectCatalog = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_catalog");
                this.objectSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_schema");
                this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_name");
                break;
            }
            default: {
                this.objectCatalog = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table_catalog");
                this.objectSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table_schema");
                this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table_name");
                this.withHierarchy = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"with_hierarchy");
            }
        }
    }

    public PostgrePrivilegeGrant(String grantor, String grantee, String objectCatalog, String objectSchema, String objectName, PostgrePrivilegeType privilegeType, boolean isGrantable, boolean withHierarchy) {
        this.grantor = grantor;
        this.grantee = grantee;
        this.objectCatalog = objectCatalog;
        this.objectSchema = objectSchema;
        this.objectName = objectName;
        this.privilegeType = privilegeType;
        this.isGrantable = isGrantable;
        this.withHierarchy = withHierarchy;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getObjectCatalog() {
        return this.objectCatalog;
    }

    public String getObjectSchema() {
        return this.objectSchema;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public PostgrePrivilegeType getPrivilegeType() {
        return this.privilegeType;
    }

    public boolean isGrantable() {
        return this.isGrantable;
    }

    public boolean isWithHierarchy() {
        return this.withHierarchy;
    }

    public String toString() {
        return this.privilegeType.toString();
    }

    public static enum Kind {
        SCHEMA,
        TABLE,
        SEQUENCE,
        FUNCTION,
        PROCEDURE,
        COLUMN;

    }
}

