/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.ui.notifications.AbstractNotification;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotificationPopup;
import org.jkiss.dbeaver.ui.notifications.NotificationSinkEvent;

public class DatabaseNotificationSink {
    private static final long DELAY_OPEN = 200L;
    private static final boolean runSystem = true;
    private final WeakHashMap<Object, Object> cancelledTokens = new WeakHashMap();
    private final Set<AbstractNotification> notifications = new HashSet<AbstractNotification>();
    private final Set<AbstractNotification> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private final Job openJob = new Job("Database notifications"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        DatabaseNotificationSink.this.collectNotifications();
                        if (DatabaseNotificationSink.this.popup != null && DatabaseNotificationSink.this.popup.getReturnCode() == 1) {
                            List<AbstractNotification> notifications = DatabaseNotificationSink.this.popup.getNotifications();
                            for (AbstractNotification notification2 : notifications) {
                                if (notification2.getToken() == null) continue;
                                DatabaseNotificationSink.this.cancelledTokens.put(notification2.getToken(), null);
                            }
                        }
                        DatabaseNotificationSink.this.currentlyNotifying.removeIf(notification -> notification.getToken() != null && DatabaseNotificationSink.this.cancelledTokens.containsKey(notification.getToken()));
                        Class<DatabaseNotificationSink> clazz = DatabaseNotificationSink.class;
                        synchronized (DatabaseNotificationSink.class) {
                            if (DatabaseNotificationSink.this.currentlyNotifying.size() > 0) {
                                DatabaseNotificationSink.this.showPopup();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    });
                }
            }
            finally {
                if (DatabaseNotificationSink.this.popup != null) {
                    this.schedule(DatabaseNotificationSink.this.popup.getDelayClose() / 2L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private DatabaseNotificationPopup popup;

    public DatabaseNotificationSink() {
        this.openJob.setSystem(true);
    }

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    private void collectNotifications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractNotification> getNotifications() {
        Class<DatabaseNotificationSink> clazz = DatabaseNotificationSink.class;
        synchronized (DatabaseNotificationSink.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentlyNotifying;
        }
    }

    private boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public void notify(NotificationSinkEvent event) {
        this.currentlyNotifying.addAll(event.getNotifications());
        if (!this.openJob.cancel()) {
            try {
                this.openJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.openJob.schedule(200L);
    }

    private void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new DatabaseNotificationPopup(shell);
        this.popup.setFadingEnabled(this.isAnimationsEnabled());
        this.popup.setDelayClose(ModelPreferences.getPreferences().getInt("notifications.closeDelay"));
        ArrayList<AbstractNotification> toDisplay = new ArrayList<AbstractNotification>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        this.popup.setContents(toDisplay);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
    }
}

