/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.panel.SetTilesAction;
import org.jkiss.dbeaver.ui.gis.panel.TilesManagementDialog;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerRegistry;
import org.jkiss.dbeaver.ui.gis.registry.LeafletTilesDescriptor;

class SelectTilesAction
extends Action {
    private final IGeometryValueEditor valueEditor;

    SelectTilesAction(IGeometryValueEditor valueEditor) {
        super(valueEditor.getValueSRID() == 0 ? GISMessages.panel_select_tiles_action_text_plain : SelectTilesAction.getActionText(), 4);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE));
        this.valueEditor = valueEditor;
    }

    private static String getActionText() {
        LeafletTilesDescriptor descriptor = GeometryViewerRegistry.getInstance().getDefaultLeafletTiles();
        if (descriptor == null) {
            return GISMessages.panel_select_tiles_action_no_tiles_selected;
        }
        return descriptor.getLabel();
    }

    public boolean isEnabled() {
        return this.valueEditor.getValueSRID() != 0;
    }

    public IMenuCreator getMenuCreator() {
        return new MenuCreator(control -> {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(manager -> {
                if (!this.isEnabled()) {
                    return;
                }
                GeometryViewerRegistry registry = GeometryViewerRegistry.getInstance();
                Stream.concat(registry.getPredefinedLeafletTiles().stream(), registry.getUserDefinedLeafletTiles().stream()).filter(LeafletTilesDescriptor::isVisible).forEach(tile -> menuManager.add((IAction)new SetTilesAction(this.valueEditor, (LeafletTilesDescriptor)((Object)((Object)((Object)tile))))));
                if (!menuManager.isEmpty()) {
                    menuManager.add((IContributionItem)new Separator());
                }
                menuManager.add((IAction)new Action(GISMessages.panel_select_tiles_action_manage_tiles_action){

                    public void run() {
                        int result = new TilesManagementDialog(SelectTilesAction.this.valueEditor.getEditorControl().getShell()).open();
                        if (result == 0) {
                            SelectTilesAction.this.valueEditor.refresh();
                        }
                    }
                });
            });
            return menuManager;
        });
    }
}

