/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.osgi.framework.Version;

public class GreenplumDataSource
extends PostgreDataSource {
    private static final Log log = Log.getLog(GreenplumDataSource.class);
    private Version gpVersion;

    public GreenplumDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    public boolean isGreenplumVersionAtLeast(DBRProgressMonitor monitor, int major, int minor) {
        if (this.gpVersion == null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read Greenplum server version");){
                    Matcher matcher;
                    String versionStr = JDBCUtils.queryString((Connection)session, (String)"SELECT VERSION()", (Object[])new Object[0]);
                    if (versionStr != null && (matcher = Pattern.compile("Greenplum Database ([0-9\\.]+)").matcher(versionStr)).find()) {
                        this.gpVersion = new Version(matcher.group(1));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Error reading GP server version", e);
            }
            if (this.gpVersion == null) {
                this.gpVersion = new Version(4, 2, 0);
            }
        }
        if (this.gpVersion.getMajor() < major) {
            return false;
        }
        return this.gpVersion.getMajor() != major || this.gpVersion.getMinor() >= minor;
    }
}

