/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.Iterator;

public final class EventListenerList {
    private volatile Object[] array;

    public synchronized void addListener(Class c, Object listener) {
        if (listener == null || c == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.array == null ? 0 : this.array.length;
        Object[] newArray = new Object[oldSize + 2];
        if (oldSize != 0) {
            System.arraycopy(this.array, 0, newArray, 0, oldSize);
        }
        newArray[oldSize++] = c;
        newArray[oldSize] = listener;
        this.array = newArray;
    }

    public synchronized boolean containsListener(Class c) {
        if (this.array == null) {
            return false;
        }
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == c) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public synchronized Iterator getListeners(Class listenerType) {
        return new TypeIterator(this.array, listenerType);
    }

    public synchronized void removeListener(Class c, Object listener) {
        if (this.array == null || this.array.length == 0) {
            return;
        }
        if (listener == null || c == null) {
            throw new IllegalArgumentException();
        }
        int index = 0;
        while (index < this.array.length) {
            if (this.array[index] == c && this.array[index + 1] == listener) break;
            index += 2;
        }
        if (index == this.array.length) {
            return;
        }
        Object[] newArray = new Object[this.array.length - 2];
        System.arraycopy(this.array, 0, newArray, 0, index);
        System.arraycopy(this.array, index + 2, newArray, index, this.array.length - index - 2);
        this.array = newArray;
    }

    static class TypeIterator
    implements Iterator {
        private final Object[] items;
        private final Class type;
        private int index;

        TypeIterator(Object[] items, Class type) {
            this.items = items;
            this.type = type;
        }

        public Object next() {
            Object result = this.items[this.index + 1];
            this.index += 2;
            return result;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.items != null) ** GOTO lbl4
            return false;
lbl-1000:
            // 1 sources

            {
                this.index += 2;
lbl4:
                // 2 sources

                ** while (this.index < this.items.length && this.items[this.index] != this.type)
            }
lbl5:
            // 1 sources

            return this.index < this.items.length;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator removal not supported");
        }
    }
}

