/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.text;

import org.eclipse.draw2dl.text.FlowBox;
import org.eclipse.draw2dl.text.FlowUtilities;
import org.eclipse.draw2dl.text.InlineFlow;
import org.eclipse.draw2dl.text.LineBox;
import org.eclipse.draw2dl.text.LineRoot;

public class NestedLine
extends LineBox {
    InlineFlow owner;
    private LineRoot root;

    NestedLine(InlineFlow owner) {
        this.owner = owner;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getBaseline() - this.getAscentWithBorder() && y < this.getBaseline() + this.getDescentWithBorder();
    }

    @Override
    int getAscentWithBorder() {
        return this.contentAscent + FlowUtilities.getBorderAscent(this.owner);
    }

    @Override
    int getDescentWithBorder() {
        return this.contentDescent + FlowUtilities.getBorderDescent(this.owner);
    }

    @Override
    public int getBaseline() {
        return this.root.getBaseline();
    }

    @Override
    LineRoot getLineRoot() {
        return this.root;
    }

    @Override
    public int getOuterAscent() {
        return this.contentAscent + FlowUtilities.getBorderAscentWithMargin(this.owner);
    }

    @Override
    public int getOuterDescent() {
        return this.contentDescent + FlowUtilities.getBorderDescentWithMargin(this.owner);
    }

    @Override
    void setLineRoot(LineRoot root) {
        this.root = root;
        int i = 0;
        while (i < this.fragments.size()) {
            ((FlowBox)this.fragments.get(i)).setLineRoot(root);
            ++i;
        }
    }

    @Override
    public void setLineTop(int top) {
        throw new RuntimeException("not supported");
    }
}

