/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.parser.common.ParseResult;
import org.jkiss.dbeaver.parser.common.ParseTreeNode;
import org.jkiss.dbeaver.parser.common.Parser;
import org.jkiss.dbeaver.parser.common.ParserFactory;
import org.jkiss.dbeaver.parser.common.grammar.ExpressionFactory;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfoBuilder;
import org.jkiss.dbeaver.parser.common.grammar.RuleExpression;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class ClickhouseTypeParser {
    private static final Parser TYPE_PARSER;

    static {
        GrammarInfoBuilder builder = new GrammarInfoBuilder("EnumType");
        builder.setRule("sp", (RuleExpression)ExpressionFactory.E.regex((String)"[\\s]*"));
        builder.setSkipRuleName("sp");
        builder.setUseSkipRule(true);
        builder.setRule("string", (RuleExpression)ExpressionFactory.E.regex((String)"'[^'\\\\\\r\\n]*'"));
        builder.setRule("number", (RuleExpression)ExpressionFactory.E.regex((String)"[-]?[0-9]+"));
        builder.setRule("enum_entry", (RuleExpression)ExpressionFactory.E.seq((Object[])new Object[]{ExpressionFactory.E.call((String)"string"), "=", ExpressionFactory.E.call((String)"number")}));
        builder.setRule("enum_entry_list", (RuleExpression)ExpressionFactory.E.seq((Object[])new Object[]{ExpressionFactory.E.call((String)"enum_entry"), ExpressionFactory.E.zeroOrMore((Object[])new Object[]{",", ExpressionFactory.E.call((String)"enum_entry")})}));
        builder.setRule("enum", (RuleExpression)ExpressionFactory.E.seq((Object[])new Object[]{ExpressionFactory.E.regex((String)"enum(8|16)"), "(", ExpressionFactory.E.call((String)"enum_entry_list"), ")"}));
        builder.setStartRuleName("enum");
        TYPE_PARSER = ParserFactory.getFactory((GrammarInfo)builder.buildGrammarInfo()).createParser();
    }

    private ClickhouseTypeParser() {
    }

    @NotNull
    public static Map<String, Integer> tryParseEnumEntries(@NotNull String type) {
        if (!ClickhouseTypeParser.isEnum(type)) {
            return Collections.emptyMap();
        }
        ParseResult result = TYPE_PARSER.parse(type);
        if (!result.isSuccess()) {
            return Collections.emptyMap();
        }
        return ((ParseTreeNode)result.getTrees(false).get(0)).stream().filter(node -> node.getRule() != null && node.getRule().getName().equals("enum_entry")).map(node -> {
            ParseTreeNode keyNode = (ParseTreeNode)((ParseTreeNode)node.getChildren().get(0)).getChildren().get(0);
            ParseTreeNode valNode = (ParseTreeNode)((ParseTreeNode)node.getChildren().get(2)).getChildren().get(0);
            String key = type.substring(keyNode.getPosition() + 1, keyNode.getEndPosition() - 1);
            String val = type.substring(valNode.getPosition(), valNode.getEndPosition());
            return new Pair((Object)key, (Object)CommonUtils.toInt((Object)val));
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @NotNull
    public static String getTypeNameWithoutModifiers(@NotNull String fullTypeName) {
        int div = fullTypeName.indexOf(40);
        if (div < 0) {
            return fullTypeName;
        }
        return fullTypeName.substring(0, div);
    }

    private static boolean isEnum(@NotNull String type) {
        String name = type.toLowerCase();
        return name.startsWith("enum8(") || name.startsWith("enum16(");
    }
}

