/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.sql.RelationalSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryTransformer;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class SQLQueryTransformerCount
implements SQLQueryTransformer {
    protected static final Log log = Log.getLog(SQLQueryTransformerCount.class);
    private static final String COUNT_WRAP_PREFIX = "SELECT COUNT(*) FROM (";
    private static final String COUNT_WRAP_POSTFIX = "\n) dbvrcnt";

    @Override
    public SQLQuery transformQuery(DBPDataSource dataSource, SQLSyntaxManager syntaxManager, SQLQuery query) throws DBException {
        try {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            if (!sqlDialect.supportsSubqueries() || sqlDialect instanceof RelationalSQLDialect && ((RelationalSQLDialect)sqlDialect).isAmbiguousCountBroken()) {
                return this.tryInjectCount(dataSource, query);
            }
        }
        catch (Throwable e) {
            log.debug("Error injecting count: " + e.getMessage());
        }
        return this.wrapSourceQuery(dataSource, syntaxManager, query);
    }

    private SQLQuery wrapSourceQuery(DBPDataSource dataSource, SQLSyntaxManager syntaxManager, SQLQuery query) {
        String queryText = null;
        try {
            SelectBody selectBody;
            Statement statement = SQLSemanticProcessor.parseQuery(query.getText());
            if (statement instanceof Select && (selectBody = ((Select)statement).getSelectBody()) instanceof PlainSelect && !CommonUtils.isEmpty((Collection)((PlainSelect)selectBody).getOrderByElements())) {
                ((PlainSelect)selectBody).setOrderByElements(null);
                queryText = statement.toString();
            }
        }
        catch (Throwable e) {
            log.debug("Error parsing query for COUNT transformation: " + e.getMessage());
        }
        if (queryText == null) {
            queryText = query.getText();
        }
        String srcQuery = SQLUtils.trimQueryStatement(syntaxManager, queryText, true);
        String countQuery = COUNT_WRAP_PREFIX + srcQuery + COUNT_WRAP_POSTFIX;
        return new SQLQuery(dataSource, countQuery, query, false);
    }

    private SQLQuery tryInjectCount(DBPDataSource dataSource, SQLQuery query) throws DBException {
        try {
            Statement statement = SQLSemanticProcessor.parseQuery(query.getText());
            if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect) {
                PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
                if (select.getHaving() != null) {
                    throw new DBException("Can't inject COUNT into query with HAVING clause");
                }
                if (select.getGroupBy() != null && !CommonUtils.isEmpty((Collection)select.getGroupBy().getGroupByExpressions())) {
                    throw new DBException("Can't inject COUNT into query with GROUP BY clause");
                }
                Distinct selectDistinct = select.getDistinct();
                if (selectDistinct != null) {
                    select.setDistinct(null);
                }
                Function countFunc = new Function();
                countFunc.setName("count");
                if (selectDistinct != null) {
                    countFunc.setDistinct(true);
                    ArrayList<Expression> exprs = new ArrayList<Expression>();
                    for (SelectItem item : select.getSelectItems()) {
                        if (!(item instanceof SelectExpressionItem)) continue;
                        exprs.add(((SelectExpressionItem)item).getExpression());
                    }
                    if (!exprs.isEmpty()) {
                        countFunc.setParameters(new ExpressionList(exprs));
                    }
                } else {
                    countFunc.setParameters(new ExpressionList(new Expression[]{new AllColumns()}));
                }
                ArrayList<SelectExpressionItem> selectItems = new ArrayList<SelectExpressionItem>();
                selectItems.add(new SelectExpressionItem((Expression)countFunc));
                select.setSelectItems(selectItems);
                select.setOrderByElements(null);
                return new SQLQuery(dataSource, select.toString(), query, false);
            }
            throw new DBException("Query [" + query.getText() + "] can't be modified");
        }
        catch (DBException e) {
            throw new DBException("Can't transform query to SELECT count(*)", e);
        }
    }
}

