/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

class DecoratorOverlayIcon
extends CompositeImageDescriptor {
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;

    public DecoratorOverlayIcon(Image baseImage, ImageDescriptor[] overlaysArray, Point sizeValue) {
        this.base = baseImage;
        this.overlays = overlaysArray;
        this.size = sizeValue;
    }

    protected void drawOverlays(ImageDescriptor[] overlaysArray) {
        int i = 0;
        while (i < this.overlays.length) {
            ImageDescriptor overlay = overlaysArray[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, this.size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, this.size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecoratorOverlayIcon)) {
            return false;
        }
        DecoratorOverlayIcon other = (DecoratorOverlayIcon)((Object)o);
        return this.base.equals((Object)other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        ImageDescriptor[] imageDescriptorArray = this.overlays;
        int n = this.overlays.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor overlay = imageDescriptorArray[n2];
            if (overlay != null) {
                code ^= overlay.hashCode();
            }
            ++n2;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor underlay = this.overlays[4];
        if (underlay != null) {
            this.drawImage(underlay.getImageData(), 0, 0);
        }
        this.drawImage(this.base.getImageData(), 0, 0);
        this.drawOverlays(this.overlays);
    }

    protected Point getSize() {
        return this.size;
    }

    protected int getTransparentPixel() {
        return this.base.getImageData().transparentPixel;
    }
}

