/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPSettingsSection;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsExecutor;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.simple.CompareReport;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportRenderer;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareObjectsPageOutput;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareObjectsPageSettings;
import org.jkiss.dbeaver.tools.compare.simple.ui.internal.CompareUIMessages;
import org.jkiss.dbeaver.ui.DialogSettingsDelegate;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.CommonUtils;

public class CompareObjectsWizard
extends Wizard
implements IExportWizard {
    private static final Log log = Log.getLog(CompareObjectsWizard.class);
    private static final String RS_COMPARE_WIZARD_DIALOG_SETTINGS = "CompareWizard";
    private CompareObjectsSettings settings;

    public CompareObjectsWizard(List<DBNDatabaseNode> nodes) {
        this.settings = new CompareObjectsSettings(nodes);
        this.settings.setOutputFolder(DialogUtils.getCurDialogFolder());
        IDialogSettings section = UIUtils.getDialogSettings((String)RS_COMPARE_WIZARD_DIALOG_SETTINGS);
        this.setDialogSettings(section);
        this.settings.loadFrom((DBPSettingsSection)new DialogSettingsDelegate(section));
    }

    public void dispose() {
        super.dispose();
    }

    public CompareObjectsSettings getSettings() {
        return this.settings;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new CompareObjectsPageSettings());
        this.addPage((IWizardPage)new CompareObjectsPageOutput());
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle(CompareUIMessages.compare_objects_wizard_title);
        this.setNeedsProgressMonitor(true);
    }

    private void showError(String error) {
        if (CommonUtils.isNotEmpty((String)error)) {
            DBWorkbench.getPlatformUI().showError(CompareUIMessages.compare_objects_wizard_error_title, error);
        }
    }

    public boolean performFinish() {
        this.getSettings().saveTo((DBPSettingsSection)new DialogSettingsDelegate(this.getDialogSettings()));
        this.showError(null);
        CompareObjectsExecutor executor = new CompareObjectsExecutor(this.settings);
        try {
            try {
                UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                    try {
                        CompareReport report = this.generateReport(monitor, executor);
                        this.renderReport(monitor, report);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                UIUtils.showMessageBox((Shell)this.getShell(), (String)CompareUIMessages.compare_objects_wizard_finish_report_title, (String)CompareUIMessages.compare_objects_wizard_finish_report_info, (int)2);
            }
            catch (InvocationTargetException e) {
                if (executor.getInitializeError() != null) {
                    this.showError(executor.getInitializeError().getMessage());
                } else {
                    log.error((Object)e.getTargetException());
                    this.showError(e.getTargetException().getMessage());
                }
                executor.dispose();
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.showError("Compare interrupted");
                executor.dispose();
                return false;
            }
        }
        finally {
            executor.dispose();
        }
        return true;
    }

    private CompareReport generateReport(DBRProgressMonitor monitor, CompareObjectsExecutor executor) throws DBException, InterruptedException {
        monitor.beginTask("Compare objects", 1000);
        CompareReport report = executor.compareObjects(monitor, this.getSettings().getNodes());
        monitor.done();
        return report;
    }

    private void renderReport(DBRProgressMonitor monitor, CompareReport report) {
        try {
            File reportFile;
            switch (this.settings.getOutputType()) {
                case BROWSER: {
                    reportFile = File.createTempFile("compare-report", ".html");
                    break;
                }
                default: {
                    StringBuilder fileName = new StringBuilder("compare");
                    for (DBNDatabaseNode node : report.getNodes()) {
                        fileName.append("-").append(CommonUtils.escapeIdentifier((String)node.getName()));
                    }
                    fileName.append("-report.html");
                    File parentFolder = new File(this.settings.getOutputFolder());
                    if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                        throw new IOException("Can't create directory '" + parentFolder.getAbsolutePath() + "'");
                    }
                    reportFile = new File(parentFolder, fileName.toString());
                }
            }
            reportFile.deleteOnExit();
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileOutputStream outputStream = new FileOutputStream(reportFile);){
                monitor.beginTask("Render report", report.getReportLines().size());
                CompareReportRenderer reportRenderer = new CompareReportRenderer();
                reportRenderer.renderReport(monitor, report, this.getSettings(), (OutputStream)outputStream);
                monitor.done();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (this.settings.getOutputType() == CompareObjectsSettings.OutputType.BROWSER) {
                ShellUtils.launchProgram((String)reportFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            log.error((Object)e);
        }
    }
}

