/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.ui.config.ExasolCreateForeignKeyDialog;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class ExasolForeignKeyConfigurator
implements DBEObjectConfigurator<ExasolTableForeignKey> {
    protected static final Log log = Log.getLog(ExasolForeignKeyConfigurator.class);

    public ExasolTableForeignKey configureObject(final DBRProgressMonitor monitor, Object container, final ExasolTableForeignKey foreignKey, final Map<String, Object> options) {
        final ExasolTable table = (ExasolTable)container;
        return (ExasolTableForeignKey)new UITask<ExasolTableForeignKey>(){

            protected ExasolTableForeignKey runTask() {
                ExasolCreateForeignKeyDialog editPage = new ExasolCreateForeignKeyDialog(ExasolMessages.dialog_create_foreign_key_title, foreignKey, options);
                if (!editPage.edit()) {
                    return null;
                }
                foreignKey.setName(editPage.getName());
                foreignKey.setReferencedConstraint((ExasolTableUniqueKey)editPage.getUniqueConstraint());
                foreignKey.setEnabled(Boolean.valueOf(editPage.isEnabled()));
                ArrayList<ExasolTableForeignKeyColumn> columns = new ArrayList<ExasolTableForeignKeyColumn>();
                int cnt = 0;
                for (EditForeignKeyPage.FKColumnInfo column : editPage.getColumns()) {
                    try {
                        ExasolTable refTable = foreignKey.getReferencedConstraint().getTable();
                        columns.add(new ExasolTableForeignKeyColumn(foreignKey, table.getAttribute(monitor, column.getOwnColumn().getName()), refTable.getAttribute(monitor, column.getRefColumn().getName()), Integer.valueOf(++cnt)));
                    }
                    catch (DBException dBException) {
                        log.error((Object)"Could not get Attribute Information from Table");
                        return null;
                    }
                }
                foreignKey.setColumns(columns);
                return foreignKey;
            }
        }.execute();
    }
}

