/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ERDEditorViewer
extends Viewer {
    private static final Log log = Log.getLog(ERDEditorViewer.class);
    private final ERDEditorPart editorPart;

    public ERDEditorViewer(ERDEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public ERDEditorPart getEditorPart() {
        return this.editorPart;
    }

    public Control getControl() {
        return this.editorPart.getGraphicalViewer().getControl();
    }

    public Object getInput() {
        return this.editorPart.getGraphicalViewer().getContents();
    }

    public ISelection getSelection() {
        ERDGraphicalViewer graphicalViewer = this.editorPart.getGraphicalViewer();
        return graphicalViewer == new StructuredSelection() ? null : graphicalViewer.getSelection();
    }

    public void refresh() {
        this.editorPart.refreshDiagram(true, true);
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.editorPart.getGraphicalViewer().setSelection(selection);
    }

    private class ERDSelectionAdapter
    implements IStructuredSelection {
        private final IStructuredSelection selection;

        public ERDSelectionAdapter(IStructuredSelection selection) {
            this.selection = selection;
        }

        public Object getFirstElement() {
            Object firstElement = this.selection.getFirstElement();
            return firstElement == null ? null : this.convertObject(firstElement);
        }

        public Iterator iterator() {
            final Iterator iterator = this.selection.iterator();
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Object next() {
                    Object next = iterator.next();
                    return next == null ? null : ERDSelectionAdapter.this.convertObject(next);
                }
            };
        }

        public int size() {
            return this.selection.size();
        }

        public Object[] toArray() {
            Object[] objects = this.selection.toArray();
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                result[i] = this.convertObject(objects[i]);
                ++i;
            }
            return result;
        }

        public List toList() {
            List list = this.selection.toList();
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            int i = 0;
            while (i < list.size()) {
                result.add(this.convertObject(list.get(i)));
                ++i;
            }
            return result;
        }

        public boolean isEmpty() {
            return this.selection.isEmpty();
        }

        private Object convertObject(Object object) {
            if (object instanceof EntityPart) {
                DBSEntity entity = (DBSEntity)((EntityPart)object).getEntity().getObject();
                return entity == null ? null : DBNUtils.getNodeByObject((DBSObject)entity);
            }
            return object;
        }
    }
}

