/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.handles;

import org.eclipse.draw2dl.ColorConstants;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.Locator;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.handles.AbstractHandle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;

public abstract class SquareHandle
extends AbstractHandle {
    protected static final int DEFAULT_HANDLE_SIZE = 7;

    public SquareHandle() {
        this.init();
    }

    public SquareHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
        this.init();
    }

    public SquareHandle(GraphicalEditPart owner, Locator loc, Cursor c) {
        super(owner, loc, c);
        this.init();
    }

    protected Color getBorderColor() {
        return this.isPrimary() ? ColorConstants.white : ColorConstants.black;
    }

    protected Color getFillColor() {
        return this.isPrimary() ? ColorConstants.black : ColorConstants.white;
    }

    protected void init() {
        this.setPreferredSize(new Dimension(7, 7));
    }

    protected boolean isPrimary() {
        return this.getOwner().getSelected() == 2;
    }

    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            g.setBackgroundColor(this.getFillColor());
            g.fillRectangle(r.x, r.y, r.width, r.height);
            g.setForegroundColor(this.getBorderColor());
            g.drawRectangle(r.x, r.y, r.width, r.height);
        }
        finally {
            r.expand(1, 1);
        }
    }
}

