/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jkiss.dbeaver.parser.common.TermPatternInfo;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaBuilder;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaState;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;
import org.jkiss.dbeaver.parser.common.grammar.nfa.ParseOperationKind;

class GrammarAnalyzer {
    private final List<GrammarNfaTransition> terminalTransitions;
    private final GrammarNfaBuilder.NfaFragment root;
    private final Map<Integer, String> recursionErrorsByTargetId = new HashMap<Integer, String>();

    public GrammarAnalyzer(List<GrammarNfaTransition> terminalTransitions, GrammarNfaBuilder.NfaFragment root) {
        this.terminalTransitions = terminalTransitions;
        this.root = root;
    }

    public List<String> getErrors() {
        return List.copyOf(this.recursionErrorsByTargetId.values());
    }

    public void discoverByTermRelations() {
        LinkedList<GrammarNfaState> queue = new LinkedList<GrammarNfaState>();
        HashSet<GrammarNfaState> queued = new HashSet<GrammarNfaState>();
        queue.add(this.root.getFrom());
        while (!queue.isEmpty()) {
            GrammarNfaState state = (GrammarNfaState)queue.remove();
            this.discoverPaths(state, queue, queued);
        }
    }

    private void discoverPaths(GrammarNfaState start, Queue<GrammarNfaState> queue, Set<GrammarNfaState> queued) {
        ArrayDeque<Step> stack = new ArrayDeque<Step>();
        stack.push(Step.initial(start));
        BitSet active = new BitSet();
        while (stack.size() > 0) {
            Step currStep = (Step)stack.pop();
            if (currStep.isUp) {
                for (GrammarNfaTransition transition : currStep.state.getNext()) {
                    if (transition.getOperation().getKind() == ParseOperationKind.TERM) continue;
                    for (TermPatternInfo term : transition.getTo().getExpectedTerms()) {
                        currStep.state.registerExpectedTerm(term, transition);
                    }
                }
                active.clear(currStep.state.getId());
                continue;
            }
            if (active.get(currStep.state.getId())) {
                int targetId = currStep.state.getId();
                if (!this.recursionErrorsByTargetId.containsKey(targetId)) {
                    this.recursionErrorsByTargetId.put(targetId, "Recursion detected at " + currStep);
                }
                stack.push(currStep.exit());
                continue;
            }
            active.set(currStep.state.getId());
            stack.push(currStep.exit());
            if (currStep.state.isExpectedTermsPopulated()) continue;
            for (GrammarNfaTransition transition : currStep.state.getNext()) {
                if (this.recursionErrorsByTargetId.containsKey(transition.getTo().getId())) continue;
                if (transition.getTo() == this.root.getTo()) {
                    currStep.state.registerExpectedTerm(TermPatternInfo.EOF, transition);
                }
                if (transition.getOperation().getKind().equals((Object)ParseOperationKind.TERM)) {
                    currStep.state.registerExpectedTerm(transition.getOperation().getPattern(), transition);
                    if (!queued.add(transition.getTo())) continue;
                    queue.add(transition.getTo());
                    continue;
                }
                stack.push(currStep.enter(transition));
            }
        }
        start.prepare();
    }

    private static class Step {
        private final boolean isUp;
        private final GrammarNfaState state;
        private final GrammarNfaTransition transition;

        private Step(boolean isUp, GrammarNfaState state, GrammarNfaTransition transition) {
            this.isUp = isUp;
            this.state = state;
            this.transition = transition;
        }

        public static Step initial(GrammarNfaState state) {
            return new Step(false, state, null);
        }

        public Step enter(GrammarNfaTransition transition) {
            return new Step(false, transition.getTo(), transition);
        }

        public Step exit() {
            return new Step(true, this.state, this.transition);
        }

        public String toString() {
            return this.transition == null ? this.state.toString() : this.transition.toString();
        }
    }
}

