/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;

public class ProjectSelectorPanel {
    private DBPProject selectedProject;

    public ProjectSelectorPanel(@NotNull Composite parent, @Nullable DBPProject activeProject, int style) {
        this(parent, activeProject, style, false);
    }

    public ProjectSelectorPanel(@NotNull Composite parent, @Nullable DBPProject activeProject, int style, boolean showOnlyEditable) {
        final List projects = DBWorkbench.getPlatform().getWorkspace().getProjects();
        if (showOnlyEditable) {
            projects.removeIf(p -> !p.hasRealmPermission("project-datasource-edit"));
        }
        if (projects.size() == 1) {
            this.selectedProject = (DBPProject)projects.get(0);
        } else if (projects.size() > 1) {
            boolean showIcon = (style & 1) != 0;
            Composite projectGroup = UIUtils.createComposite((Composite)parent, (int)(showIcon ? 3 : 2));
            projectGroup.setLayoutData((Object)new GridData(128));
            if (showIcon) {
                new Label(projectGroup, 0).setImage(DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT));
            }
            UIUtils.createControlLabel((Composite)projectGroup, (String)UIConnectionMessages.dialog_connection_driver_project);
            final Combo projectCombo = new Combo(projectGroup, 12);
            projectCombo.setLayoutData((Object)new GridData(32));
            for (DBPProject project : projects) {
                projectCombo.add(project.getName());
            }
            if (this.selectedProject == null) {
                this.selectedProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
                if (!projects.contains(this.selectedProject)) {
                    this.selectedProject = (DBPProject)projects.get(0);
                }
            }
            projectCombo.setText(this.selectedProject.getName());
            projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectSelectorPanel.this.selectedProject = (DBPProject)projects.get(projectCombo.getSelectionIndex());
                    ProjectSelectorPanel.this.onProjectChange();
                }
            });
            projects.size();
        }
    }

    protected void onProjectChange() {
    }

    public DBPProject getSelectedProject() {
        return this.selectedProject;
    }
}

