/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.io.ByteOrderMark;

public class BOMInputStream
extends InputStream {
    private static final Comparator<ByteOrderMark> BOM_LENGTH_COMPARATOR = Comparator.comparing(ByteOrderMark::length).reversed();
    private final InputStream in;
    private final List<ByteOrderMark> boms;
    private ByteOrderMark bom;
    private int[] firstBytes;
    private int fbLength;
    private int fbIndex;
    private int markFbIndex;
    private boolean markedAtStart;

    public BOMInputStream(@NotNull InputStream delegate, ByteOrderMark ... boms) {
        if (boms.length == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.in = delegate;
        this.boms = Arrays.asList(boms);
        this.boms.sort(BOM_LENGTH_COMPARATOR);
    }

    public BOMInputStream(@NotNull InputStream delegate, @NotNull Charset charset) {
        this(delegate, ByteOrderMark.fromCharset(charset));
    }

    public BOMInputStream(@NotNull InputStream delegate) {
        this(delegate, ByteOrderMark.UTF_8);
    }

    @Override
    public int read() throws IOException {
        this.getBOM();
        return this.fbIndex < this.fbLength ? this.firstBytes[this.fbIndex++] : this.in.read();
    }

    @Override
    public synchronized void mark(int limit) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(limit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Nullable
    public ByteOrderMark getBOM() throws IOException {
        if (this.firstBytes == null) {
            this.fbLength = 0;
            this.firstBytes = new int[this.boms.get(0).length()];
            int i = 0;
            while (i < this.firstBytes.length) {
                this.firstBytes[i] = this.in.read();
                ++this.fbLength;
                if (this.firstBytes[i] < 0) break;
                ++i;
            }
            this.bom = this.find();
            if (this.bom != null) {
                if (this.bom.length() < this.firstBytes.length) {
                    this.fbIndex = this.bom.length();
                } else {
                    this.fbLength = 0;
                }
            }
        }
        return this.bom;
    }

    public boolean hasBOM() throws IOException {
        return this.getBOM() != null;
    }

    public boolean hasBOM(@NotNull ByteOrderMark bom) throws IOException {
        if (!this.boms.contains(bom)) {
            throw new IllegalArgumentException("Stream is not configured to detect " + bom);
        }
        this.getBOM();
        return this.bom != null && this.bom.equals(bom);
    }

    @Nullable
    private ByteOrderMark find() {
        for (ByteOrderMark bom : this.boms) {
            if (!this.matches(bom)) continue;
            return bom;
        }
        return null;
    }

    private boolean matches(@NotNull ByteOrderMark bom) {
        int i = 0;
        while (i < bom.length()) {
            if (bom.get(i) != this.firstBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

