/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security.user;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class SMUser {
    private final String userId;
    private final Map<String, String> metaParameters = new LinkedHashMap<String, String>();
    private String[] userTeams;
    private boolean enabled;
    private final String authRole;

    public SMUser(@NotNull String userId, boolean enabled, @Nullable String authRole) {
        this(userId, null, new String[0], enabled, authRole);
    }

    public SMUser(@NotNull String userId, @Nullable Map<String, String> metaParameters, @NotNull String[] teams, boolean enabled, @Nullable String authRole) {
        this.userId = userId;
        if (metaParameters != null) {
            this.metaParameters.putAll(metaParameters);
        }
        this.userTeams = teams;
        this.enabled = enabled;
        this.authRole = authRole;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @NotNull
    public Map<String, String> getMetaParameters() {
        return this.metaParameters;
    }

    @NotNull
    public String[] getUserTeams() {
        return this.userTeams;
    }

    public void setUserTeams(@NotNull String[] userTeams) {
        this.userTeams = userTeams;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableUser(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMetaParameter(String name, String value) {
        this.metaParameters.put(name, value);
    }

    @Nullable
    public String getAuthRole() {
        return this.authRole;
    }
}

