/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.model.plan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.oceanbase.model.plan.OceanbasePlanNodeJSON;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;
import org.jkiss.utils.CommonUtils;

public class OceanbasePlanJSON
extends AbstractExecutionPlan {
    private static final Gson gson = new Gson();
    private final List<OceanbasePlanNodeJSON> rootNodes;
    private OceanbaseMySQLDataSource dataSource;
    private String query;

    OceanbasePlanJSON(JDBCSession session, String query) throws DBCException {
        this.dataSource = (OceanbaseMySQLDataSource)session.getDataSource();
        this.query = query;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(this.getPlanQueryString());){
                try {
                    Throwable throwable2 = null;
                    Object var7_12 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        ArrayList<OceanbasePlanNodeJSON> nodes = new ArrayList<OceanbasePlanNodeJSON>();
                        dbResult.next();
                        String jsonPlan = dbResult.getString(1);
                        JsonObject planObject = (JsonObject)gson.fromJson(jsonPlan, JsonObject.class);
                        JsonObject queryBlock = planObject.getAsJsonObject();
                        OceanbasePlanNodeJSON rootNode = new OceanbasePlanNodeJSON(null, "select", queryBlock);
                        if (CommonUtils.isEmpty(rootNode.getNested()) && rootNode.getProperty("message") != null) {
                            throw new DBCException("Can't explain plan: " + rootNode.getProperty("message"));
                        }
                        nodes.add(rootNode);
                        this.rootNodes = nodes;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    OceanbasePlanJSON(MySQLDataSource dataSource, String query, List<OceanbasePlanNodeJSON> rootNodes) {
        this.dataSource = (OceanbaseMySQLDataSource)dataSource;
        this.query = query;
        this.rootNodes = rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN FORMAT=JSON " + this.query + ";";
    }

    public List<OceanbasePlanNodeJSON> getPlanNodes(Map<String, Object> options) {
        return Collections.unmodifiableList(this.rootNodes);
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }
}

