/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerNIO;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFileStorage;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourcePersistentRegistry;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.DataSourceSerializerLegacy;
import org.jkiss.dbeaver.registry.DataSourceSerializerModern;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceRegistry
implements DBPDataSourceRegistry,
DataSourcePersistentRegistry {
    @Deprecated
    public static final String DEFAULT_AUTO_COMMIT = "default.autocommit";
    @Deprecated
    public static final String DEFAULT_ISOLATION = "default.isolation";
    @Deprecated
    public static final String DEFAULT_ACTIVE_OBJECT = "default.activeObject";
    private static final long DISCONNECT_ALL_TIMEOUT = 5000L;
    private static final Log log = Log.getLog(DataSourceRegistry.class);
    public static final String OLD_CONFIG_FILE_NAME = "data-sources.xml";
    private final DBPProject project;
    private final DataSourceConfigurationManager configurationManager;
    private final List<DBPDataSourceConfigurationStorage> storages = new ArrayList<DBPDataSourceConfigurationStorage>();
    private final Map<String, DataSourceDescriptor> dataSources = new LinkedHashMap<String, DataSourceDescriptor>();
    private final List<DBPEventListener> dataSourceListeners = new ArrayList<DBPEventListener>();
    private final List<DataSourceFolder> dataSourceFolders = new ArrayList<DataSourceFolder>();
    private final List<DBSObjectFilter> savedFilters = new ArrayList<DBSObjectFilter>();
    private final List<DBWNetworkProfile> networkProfiles = new ArrayList<DBWNetworkProfile>();
    private final Map<String, DBAAuthProfile> authProfiles = new LinkedHashMap<String, DBAAuthProfile>();
    private volatile boolean saveInProgress = false;
    private final DBVModel.ModelChangeListener modelChangeListener = new DBVModel.ModelChangeListener();
    private volatile ConfigSaver configSaver;
    private DBACredentialsProvider authCredentialsProvider;
    protected Throwable lastError;

    public DataSourceRegistry(DBPProject project) {
        this(project, new DataSourceConfigurationManagerNIO(project));
    }

    public DataSourceRegistry(@NotNull DBPProject project, DataSourceConfigurationManager configurationManager) {
        this.project = project;
        this.configurationManager = configurationManager;
        this.loadDataSources(true);
        if (!this.isMultiUser()) {
            DataSourceProviderRegistry.getInstance().fireRegistryChange(this, true);
            this.addDataSourceListener((DBPEventListener)this.modelChangeListener);
        }
    }

    private boolean isMultiUser() {
        return DBWorkbench.getPlatform().getApplication().isMultiuser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.isMultiUser()) {
            this.removeDataSourceListener((DBPEventListener)this.modelChangeListener);
            DataSourceProviderRegistry.getInstance().fireRegistryChange(this, false);
        }
        Object object = this.dataSourceListeners;
        synchronized (object) {
            if (!this.dataSourceListeners.isEmpty()) {
                log.warn((Object)("Some data source listeners are still registered: " + this.dataSourceListeners));
            }
            this.dataSourceListeners.clear();
        }
        this.closeConnections(5000L);
        object = this.dataSources;
        synchronized (object) {
            for (DataSourceDescriptor dataSourceDescriptor : this.dataSources.values()) {
                dataSourceDescriptor.dispose();
            }
            this.dataSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(long waitTime) {
        boolean hasConnections = false;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dataSource : this.dataSources.values()) {
                if (!dataSource.isConnected()) continue;
                hasConnections = true;
                break;
            }
        }
        if (!hasConnections) {
            return;
        }
        DisconnectTask disconnectTask = new DisconnectTask();
        if (!RuntimeUtils.runTask((DBRRunnableWithProgress)disconnectTask, (String)"Disconnect from data sources", (long)waitTime)) {
            log.warn((Object)("Some data source connections wasn't closed on shutdown in " + waitTime + "ms. Probably network timeout occurred."));
        }
    }

    @NotNull
    DBPDataSourceConfigurationStorage getDefaultStorage() {
        List<DBPDataSourceConfigurationStorage> list = this.storages;
        synchronized (list) {
            for (DBPDataSourceConfigurationStorage storage : this.storages) {
                if (!storage.isDefault()) continue;
                return storage;
            }
            List<DBPDataSourceConfigurationStorage> storages = this.getConfigurationManager().getConfigurationStorages();
            for (DBPDataSourceConfigurationStorage storage : storages) {
                if (!storage.isDefault()) continue;
                this.storages.add(storage);
                return storage;
            }
            log.warn((Object)("no default storage in registry " + this));
            try {
                Path configPath = this.getProject().getMetadataFolder(false).resolve("data-sources.json");
                Files.createFile(configPath, new FileAttribute[0]);
                DataSourceFileStorage defaultStorage = new DataSourceFileStorage(configPath, false, true);
                this.storages.add(defaultStorage);
                return defaultStorage;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create a default storage in registry " + this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(String id) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            return this.dataSources.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(DBPDataSource dataSource) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dsd : this.dataSources.values()) {
                if (dsd.getDataSource() != dataSource) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor findDataSourceByName(String name) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dsd : this.dataSources.values()) {
                if (dsd.isHidden() || !dsd.getName().equals(name)) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSourcesByProfile(@NotNull DBWNetworkProfile profile) {
        List dsCopy;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            dsCopy = CommonUtils.copyList(this.dataSources.values());
        }
        dsCopy.removeIf(ds -> !CommonUtils.equalObjects((Object)ds.getConnectionConfiguration().getConfigProfileName(), (Object)profile.getProfileName()));
        return dsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DataSourceDescriptor> getDataSources() {
        List dsCopy;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            dsCopy = CommonUtils.copyList(this.dataSources.values());
        }
        dsCopy.sort((o1, o2) -> ((String)CommonUtils.notNull((Object)o1.getName(), (Object)o1.getId())).compareToIgnoreCase((String)CommonUtils.notNull((Object)o2.getName(), (Object)o2.getId())));
        return dsCopy;
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(DBPDriver driver, DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptor(this, DataSourceDescriptor.generateNewId(driver), driver, connConfig);
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(DBPDataSourceContainer source) {
        DataSourceDescriptor newDS = new DataSourceDescriptor((DataSourceDescriptor)source, this);
        newDS.setId(DataSourceDescriptor.generateNewId(source.getDriver()));
        return newDS;
    }

    @NotNull
    public List<DataSourceFolder> getAllFolders() {
        return this.dataSourceFolders;
    }

    @NotNull
    public List<DataSourceFolder> getRootFolders() {
        ArrayList<DataSourceFolder> rootFolders = new ArrayList<DataSourceFolder>();
        for (DataSourceFolder folder : this.dataSourceFolders) {
            if (folder.getParent() != null) continue;
            rootFolders.add(folder);
        }
        return rootFolders;
    }

    public DataSourceFolder addFolder(DBPDataSourceFolder parent, String name) {
        DataSourceFolder folder = new DataSourceFolder(this, (DataSourceFolder)parent, name, null);
        this.dataSourceFolders.add(folder);
        return folder;
    }

    public void removeFolder(DBPDataSourceFolder folder, boolean dropContents) {
        DataSourceFolder folderImpl = (DataSourceFolder)folder;
        DataSourceFolder[] dataSourceFolderArray = folderImpl.getChildren();
        int n = dataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder child = dataSourceFolderArray[n2];
            this.removeFolder(child, dropContents);
            ++n2;
        }
        DBPDataSourceFolder parent = folder.getParent();
        if (parent != null) {
            folderImpl.setParent(null);
        }
        for (DataSourceDescriptor ds : this.dataSources.values()) {
            if (ds.getFolder() != folder) continue;
            if (dropContents) {
                this.removeDataSource(ds);
                continue;
            }
            ds.setFolder(parent);
        }
        this.dataSourceFolders.remove(folderImpl);
    }

    private DataSourceFolder findRootFolder(String name) {
        for (DataSourceFolder root : this.getRootFolders()) {
            if (!root.getName().equals(name)) continue;
            return root;
        }
        return null;
    }

    public DBPDataSourceFolder getFolder(String path) {
        return this.findFolderByPath(path, true);
    }

    DataSourceFolder findFolderByPath(String path, boolean create) {
        DataSourceFolder parent = null;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder folder;
            String name = stringArray[n2];
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.findRootFolder(name) : parent.getChild(name);
            if (folder == null) {
                if (!create) {
                    log.warn((Object)("Folder '" + path + "' not found"));
                    break;
                }
                folder = this.addFolder(parent, name);
            }
            parent = folder;
            ++n2;
        }
        return parent;
    }

    void addDataSourceFolder(DataSourceFolder folder) {
        this.dataSourceFolders.add(folder);
    }

    @Nullable
    public DBSObjectFilter getSavedFilter(String name) {
        for (DBSObjectFilter filter : this.savedFilters) {
            if (!CommonUtils.equalObjects((Object)filter.getName(), (Object)name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public List<DBSObjectFilter> getSavedFilters() {
        return this.savedFilters;
    }

    public void updateSavedFilter(DBSObjectFilter filter) {
        DBSObjectFilter filterCopy = new DBSObjectFilter(filter);
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filter.getName())) {
                this.savedFilters.set(i, filterCopy);
                return;
            }
            ++i;
        }
        this.savedFilters.add(filterCopy);
    }

    public void removeSavedFilter(String filterName) {
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filterName)) {
                this.savedFilters.remove(i);
                continue;
            }
            ++i;
        }
    }

    void addSavedFilter(DBSObjectFilter filter) {
        this.savedFilters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBWNetworkProfile getNetworkProfile(String name) {
        List<DBWNetworkProfile> list = this.networkProfiles;
        synchronized (list) {
            return this.networkProfiles.stream().filter(profile -> CommonUtils.equalObjects((Object)profile.getProfileName(), (Object)name)).findFirst().orElse(null);
        }
    }

    @NotNull
    public List<DBWNetworkProfile> getNetworkProfiles() {
        return this.networkProfiles;
    }

    public void updateNetworkProfile(DBWNetworkProfile profile) {
        int i = 0;
        while (i < this.networkProfiles.size()) {
            if (CommonUtils.equalObjects((Object)this.networkProfiles.get(i).getProfileName(), (Object)profile.getProfileName())) {
                this.networkProfiles.set(i, profile);
                return;
            }
            ++i;
        }
        this.networkProfiles.add(profile);
    }

    public void removeNetworkProfile(DBWNetworkProfile profile) {
        try {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
            secretController.setSecretValue(profile.getSecretKeyId(), null);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Secret remove error", "Error removing network profile credentials from secret storage", (Throwable)e);
        }
        this.networkProfiles.remove(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBAAuthProfile getAuthProfile(String id) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return this.authProfiles.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBAAuthProfile> getAllAuthProfiles() {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return new ArrayList<DBAAuthProfile>(this.authProfiles.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBAAuthProfile> getApplicableAuthProfiles(@Nullable DBPDriver driver) {
        DBPDataSourceProviderRegistry dspRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return this.authProfiles.values().stream().filter(p -> {
                DBPAuthModelDescriptor authModel = dspRegistry.getAuthModel(p.getAuthModelId());
                return authModel != null && authModel.isApplicableTo(driver);
            }).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthProfile(DBAAuthProfile profile) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.put(profile.getProfileId(), profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthProfile(DBAAuthProfile profile) {
        if (this.getProject().isUseSecretStorage()) {
            try {
                DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
                secretController.setSecretValue(profile.getSecretKeyId(), null);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Secret remove error", "Error removing auth profile credentials from secret storage", (Throwable)e);
            }
        }
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.remove(profile.getProfileId());
        }
    }

    public void addDataSource(@NotNull DBPDataSourceContainer dataSource) throws DBException {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        this.addDataSourceToList(descriptor);
        if (!descriptor.isDetached()) {
            this.persistDataSourceUpdate(dataSource);
        }
        descriptor.persistSecretIfNeeded(true);
        this.notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)descriptor, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDataSourceToList(@NotNull DataSourceDescriptor descriptor) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            this.dataSources.put(descriptor.getId(), descriptor);
            DBPDataSourceConfigurationStorage storage = descriptor.getStorage();
            if (!this.storages.contains(storage) && !descriptor.isDetached()) {
                this.storages.add(storage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(@NotNull DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            this.dataSources.remove(descriptor.getId());
        }
        if (!descriptor.isDetached()) {
            this.persistDataSourceDelete(dataSource);
        }
        try {
            descriptor.removeSecretIfNeeded();
        }
        catch (DBException e) {
            log.error((Object)"Error deleting old secrets", (Throwable)e);
        }
        try {
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dataSource);
        }
        finally {
            descriptor.dispose();
        }
    }

    public void updateDataSource(@NotNull DBPDataSourceContainer dataSource) throws DBException {
        if (!(dataSource instanceof DataSourceDescriptor)) {
            return;
        }
        if (!this.dataSources.containsKey(dataSource.getId())) {
            this.addDataSource(dataSource);
        } else {
            if (!((DataSourceDescriptor)dataSource).isDetached()) {
                this.persistDataSourceUpdate(dataSource);
            }
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSource);
        }
    }

    protected void persistDataSourceUpdate(@NotNull DBPDataSourceContainer container) {
        this.saveDataSources();
    }

    protected void persistDataSourceDelete(@NotNull DBPDataSourceContainer container) {
        this.saveDataSources();
    }

    public void flushConfig() {
        if (this.project.isInMemory()) {
            return;
        }
        if (this.configSaver == null) {
            this.configSaver = new ConfigSaver();
        }
        this.configSaver.schedule(100L);
    }

    public void refreshConfig() {
        if (!this.saveInProgress) {
            this.loadDataSources(true);
        }
    }

    public Throwable getLastError() {
        Throwable error = this.lastError;
        this.lastError = null;
        return error;
    }

    public boolean hasError() {
        return this.lastError != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceListener(@NotNull DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            this.dataSourceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSourceListener(@NotNull DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            return this.dataSourceListeners.remove(listener);
        }
    }

    private void fireDataSourceEvent(DBPEvent.Action action, DBSObject object) {
        this.notifyDataSourceListeners(new DBPEvent(action, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataSourceListeners(final DBPEvent event) {
        ArrayList<DBPEventListener> listeners;
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            if (this.dataSourceListeners.isEmpty()) {
                return;
            }
            listeners = new ArrayList<DBPEventListener>(this.dataSourceListeners);
        }
        new Job("Notify datasource events"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (DBPEventListener listener : listeners) {
                    listener.handleDataSourceEvent(event);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Nullable
    public DBACredentialsProvider getAuthCredentialsProvider() {
        return this.authCredentialsProvider;
    }

    public void setAuthCredentialsProvider(DBACredentialsProvider authCredentialsProvider) {
        this.authCredentialsProvider = authCredentialsProvider;
    }

    public static List<DBPDataSourceContainer> getAllDataSources() {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            if (!project.isOpen() || !project.isRegistryLoaded()) continue;
            result.addAll(project.getDataSourceRegistry().getDataSources());
        }
        return result;
    }

    public Set<DBPDataSourceFolder> getTemporaryFolders() {
        HashSet<DBPDataSourceFolder> result = new HashSet<DBPDataSourceFolder>(Collections.emptySet());
        Set folders = this.getDataSources().stream().filter(DBPDataSourceContainer::isTemporary).map(DBPDataSourceContainer::getFolder).collect(Collectors.toSet());
        for (DBPDataSourceFolder folder : folders) {
            while (folder != null) {
                result.add(folder);
                folder = folder.getParent();
            }
        }
        return result;
    }

    private void loadDataSources(boolean refresh) {
        this.loadDataSources(this.configurationManager.getConfigurationStorages(), this.configurationManager, refresh, true);
    }

    @Override
    public void loadDataSources(@NotNull List<DBPDataSourceConfigurationStorage> storages, @NotNull DataSourceConfigurationManager manager, boolean refresh, boolean purgeUntouched) {
        if (!this.project.isOpen() || this.project.isInMemory()) {
            return;
        }
        this.savedFilters.clear();
        ParseResults parseResults = new ParseResults();
        for (DBPDataSourceConfigurationStorage cfgStorage : storages) {
            this.loadDataSources(cfgStorage, manager, false, parseResults);
        }
        if (refresh) {
            for (DBPDataSourceContainer ds : parseResults.updatedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)ds);
            }
            for (DBPDataSourceContainer ds : parseResults.addedDataSources) {
                this.addDataSourceToList((DataSourceDescriptor)ds);
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)ds);
            }
            if (purgeUntouched) {
                ArrayList<DataSourceDescriptor> removedDataSource = new ArrayList<DataSourceDescriptor>();
                for (DataSourceDescriptor ds : this.dataSources.values()) {
                    if (parseResults.addedDataSources.contains(ds) || parseResults.updatedDataSources.contains(ds) || ds.isProvided() || ds.isExternallyProvided() || ds.isDetached()) continue;
                    removedDataSource.add(ds);
                }
                for (DataSourceDescriptor ds : removedDataSource) {
                    this.dataSources.remove(ds.getId());
                    this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)ds);
                    ds.dispose();
                }
            }
        }
    }

    private void loadDataSources(@NotNull DBPDataSourceConfigurationStorage storage, @NotNull DataSourceConfigurationManager manager, boolean refresh, @NotNull ParseResults parseResults) {
        try {
            DataSourceSerializer serializer = storage instanceof DataSourceFileStorage && ((DataSourceFileStorage)storage).isLegacy() ? new DataSourceSerializerLegacy(this) : new DataSourceSerializerModern(this);
            serializer.parseDataSources(storage, manager, parseResults, refresh);
            this.updateProjectNature();
            this.lastError = null;
        }
        catch (Exception ex) {
            this.lastError = ex;
            log.error((Object)("Error loading datasource config from " + storage.getStorageId()), (Throwable)ex);
        }
    }

    @Override
    public void saveDataSources() {
        this.saveDataSources((DBRProgressMonitor)new VoidProgressMonitor());
    }

    protected void saveDataSources(DBRProgressMonitor monitor) {
        if (this.project.isInMemory()) {
            return;
        }
        this.updateProjectNature();
        this.saveInProgress = true;
        try {
            for (DBPDataSourceConfigurationStorage storage : this.storages) {
                if (storage instanceof DataSourceFileStorage && ((DataSourceFileStorage)storage).isLegacy()) {
                    ((DataSourceFileStorage)storage).convertToModern(this.project);
                }
                List<DataSourceDescriptor> localDataSources = this.getDataSources(storage);
                try {
                    DataSourceSerializerModern serializer = new DataSourceSerializerModern(this);
                    serializer.saveDataSources(monitor, this.configurationManager, storage, localDataSources);
                    try {
                        if (this.project.isUseSecretStorage() && !this.configurationManager.isSecure()) {
                            DBSSecretController.getProjectSecretController((DBPProject)this.project).flushChanges();
                        }
                        this.lastError = null;
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error saving secured preferences", e);
                        this.lastError = e;
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Error saving datasources configuration", (Throwable)ex);
                    this.lastError = ex;
                }
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSourceDescriptor> getDataSources(DBPDataSourceConfigurationStorage storage) {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor ds : this.dataSources.values()) {
                if (!CommonUtils.equalObjects((Object)ds.getStorage(), (Object)storage)) continue;
                result.add(ds);
            }
        }
        return result;
    }

    private void updateProjectNature() {
        if (this.isMultiUser()) {
            return;
        }
        try {
            IProjectDescription description;
            IProject eclipseProject = this.project.getEclipseProject();
            if (eclipseProject != null && (description = eclipseProject.getDescription()) != null) {
                Object[] natureIds = description.getNatureIds();
                if (!this.dataSources.isEmpty() && !ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                    description.setNatureIds((String[])ArrayUtils.add(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                    try {
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        log.debug((Object)"Can't set project nature", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public DBPProject getProject() {
        return this.project;
    }

    @Override
    public DataSourceConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public String toString() {
        return String.valueOf(this.project.getName()) + " (" + this.getClass().getSimpleName() + ")";
    }

    @Override
    public void saveConfigurationToManager(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceConfigurationManager configurationManager, @Nullable Predicate<DBPDataSourceContainer> filter) {
        List<DataSourceDescriptor> localDataSources = this.getDataSources();
        if (filter != null) {
            localDataSources.removeIf(filter.negate());
        }
        try {
            DataSourceSerializerModern serializer = new DataSourceSerializerModern(this);
            serializer.saveDataSources(monitor, configurationManager, this.getDefaultStorage(), localDataSources);
            try {
                if (!configurationManager.isSecure()) {
                    DBSSecretController.getProjectSecretController((DBPProject)this.project).flushChanges();
                }
                this.lastError = null;
            }
            catch (Throwable e) {
                this.lastError = e;
                log.error((Object)"Error saving secured preferences", e);
            }
        }
        catch (Exception ex) {
            this.lastError = ex;
            log.error((Object)"Error saving datasources configuration", (Throwable)ex);
        }
    }

    public void checkForErrors() throws DBException {
        Throwable lastError = this.getLastError();
        if (lastError != null) {
            if (lastError instanceof DBException) {
                throw (DBException)lastError;
            }
            throw new DBException(lastError.getMessage(), lastError.getCause());
        }
    }

    public void persistSecrets(DBSSecretController secretController) throws DBException {
        for (DBPDataSourceContainer dBPDataSourceContainer : this.getDataSources()) {
            dBPDataSourceContainer.persistSecrets(secretController);
        }
        for (DBWNetworkProfile dBWNetworkProfile : this.getNetworkProfiles()) {
            dBWNetworkProfile.persistSecrets(secretController);
        }
        for (DBAAuthProfile dBAAuthProfile : this.getAllAuthProfiles()) {
            dBAAuthProfile.persistSecrets(secretController);
        }
    }

    public void resolveSecrets(DBSSecretController secretController) throws DBException {
        for (DBPDataSourceContainer dBPDataSourceContainer : this.getDataSources()) {
            dBPDataSourceContainer.resolveSecrets(secretController);
        }
        for (DBWNetworkProfile dBWNetworkProfile : this.getNetworkProfiles()) {
            dBWNetworkProfile.resolveSecrets(secretController);
        }
        for (DBAAuthProfile dBAAuthProfile : this.getAllAuthProfiles()) {
            dBAAuthProfile.resolveSecrets(secretController);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Datasource configuration save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            DataSourceRegistry dataSourceRegistry = DataSourceRegistry.this;
            synchronized (dataSourceRegistry) {
                DataSourceRegistry.this.saveDataSources(monitor);
            }
            return Status.OK_STATUS;
        }
    }

    private class DisconnectTask
    implements DBRRunnableWithProgress {
        boolean disconnected;

        private DisconnectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            List dsSnapshot;
            monitor = new ProxyProgressMonitor((DBRProgressMonitor)monitor){

                public boolean isCanceled() {
                    return false;
                }
            };
            Map<String, DataSourceDescriptor> map = DataSourceRegistry.this.dataSources;
            synchronized (map) {
                dsSnapshot = CommonUtils.copyList(DataSourceRegistry.this.dataSources.values());
            }
            monitor.beginTask("Disconnect all databases", dsSnapshot.size());
            try {
                for (DataSourceDescriptor dataSource : dsSnapshot) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    if (dataSource.isConnected()) {
                        try {
                            monitor.subTask("Disconnect from [" + dataSource.getName() + "]");
                            this.disconnected = dataSource.disconnect((DBRProgressMonitor)monitor);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Can't shutdown data source '" + dataSource.getName() + "'"), (Throwable)ex);
                        }
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    static class ParseResults {
        Set<DBPDataSourceContainer> updatedDataSources = new LinkedHashSet<DBPDataSourceContainer>();
        Set<DBPDataSourceContainer> addedDataSources = new LinkedHashSet<DBPDataSourceContainer>();

        ParseResults() {
        }
    }
}

