/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.draw2dl.ChopboxAnchor;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPolicy;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.tools.DirectEditManager;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.ERDUIUtils;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.figures.EditableLabel;
import org.jkiss.dbeaver.erd.ui.figures.EntityFigure;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.model.ERDContainerDecorated;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.policy.EntityConnectionEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.EntityContainerEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.EntityEditPolicy;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class EntityPart
extends NodePart {
    protected DirectEditManager manager;

    public ERDEntity getEntity() {
        return (ERDEntity)this.getModel();
    }

    protected List<ERDEntityAttribute> getModelChildren() {
        return this.getEntity().getAttributes();
    }

    protected void createEditPolicies() {
        if (!this.getEditor().isReadOnly()) {
            boolean layoutEnabled = this.isLayoutEnabled();
            if (layoutEnabled) {
                this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new EntityConnectionEditPolicy());
                this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new EntityContainerEditPolicy());
                this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityEditPolicy());
            }
            this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ERDUIUtils.openObjectEditor(this.getDiagram(), (ERDObject)this.getEntity());
        } else {
            this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
        }
    }

    protected boolean isAttributeAssociationsSupported() {
        DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
        return store.getString("erd.routing.type").equals("Mikami-Tabuchi (Experimental)") && !ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)store);
    }

    public void handleNameChange() {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        label.setText(this.getEntity().getName());
        label.setVisible(true);
        this.refreshVisuals();
    }

    public String toString() {
        return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)this.getEntity().getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        label.setText(((DBSEntity)this.getEntity().getObject()).getName());
        label.setVisible(true);
        this.refreshVisuals();
        entityFigure.refreshColors();
    }

    @Override
    protected void commitRefresh(PropertyChangeEvent evt) {
        super.commitRefresh(evt);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        EntityFigure figure = this.getFigure();
        if (childEditPart instanceof AttributePart) {
            AttributeItemFigure childFigure = ((AttributePart)childEditPart).getFigure();
            figure.remove((IFigure)childFigure);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    protected EntityFigure createFigure() {
        EntityDiagram diagram = this.getDiagram();
        EntityFigure figure = this.createFigureImpl();
        ERDContainerDecorated.NodeVisualInfo visualInfo = diagram.getVisualInfo((DBSEntity)this.getEntity().getObject());
        if (visualInfo != null) {
            if (visualInfo.initBounds != null) {
                figure.setLocation(visualInfo.initBounds.getLocation());
            }
            if (visualInfo.bgColor != null) {
                figure.setBackgroundColor(visualInfo.bgColor);
            }
            if (this.getEntity().getAttributeVisibility() == null && visualInfo.attributeVisibility != null) {
                this.getEntity().setAttributeVisibility(visualInfo.attributeVisibility);
            }
        }
        return figure;
    }

    protected EntityFigure createFigureImpl() {
        return new EntityFigure(this);
    }

    public EntityFigure getFigure() {
        return (EntityFigure)super.getFigure();
    }

    protected void refreshVisuals() {
        EntityFigure entityFigure = this.getFigure();
        Point location = entityFigure.getLocation();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        this.getDiagramPart().setLayoutConstraint((EditPart)this, (IFigure)entityFigure, constraint);
    }

    public EntityFigure getContentPane() {
        return this.getFigure();
    }

    public void setSelected(int value) {
        super.setSelected(value);
        EntityFigure entityFigure = this.getFigure();
        if (value != 0) {
            entityFigure.setSelected(true);
        } else {
            entityFigure.setSelected(false);
        }
        entityFigure.repaint();
    }

    public ERDGraphicalViewer getViewer() {
        return (ERDGraphicalViewer)super.getViewer();
    }

    @Override
    public void activate() {
        super.activate();
        this.getViewer().handleTableActivate((DBSEntity)this.getEntity().getObject());
    }

    @Override
    public void deactivate() {
        this.getViewer().handleTableDeactivate((DBSEntity)this.getEntity().getObject());
        super.deactivate();
    }

    protected void registerVisuals() {
        super.registerVisuals();
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.put(this.getFigure().getNameLabel(), this);
        visualPartMap.put(this.getFigure().getKeyFigure(), this);
        visualPartMap.put(this.getFigure().getColumnsFigure(), this);
    }

    protected void unregisterVisuals() {
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.remove((Object)this.getFigure().getColumnsFigure());
        visualPartMap.remove((Object)this.getFigure().getKeyFigure());
        visualPartMap.remove((Object)this.getFigure().getNameLabel());
        super.unregisterVisuals();
    }

    public EditPart getTargetEditPart(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public DragTracker getDragTracker(Request request) {
        return super.getDragTracker(request);
    }

    @Override
    public ERDElement getElement() {
        return this.getEntity();
    }

    @Override
    protected List<ERDAssociation> getModelSourceConnections() {
        if (this.isAttributeAssociationsSupported()) {
            return super.getModelSourceConnections().stream().filter(erdAssociation -> ((DBSEntityAssociation)erdAssociation.getObject()).getConstraintType() == DBSEntityConstraintType.INHERITANCE).collect(Collectors.toList());
        }
        return super.getModelSourceConnections();
    }

    @Override
    protected List<ERDAssociation> getModelTargetConnections() {
        if (this.isAttributeAssociationsSupported()) {
            return super.getModelTargetConnections().stream().filter(erdAssociation -> ((DBSEntityAssociation)erdAssociation.getObject()).getConstraintType() == DBSEntityConstraintType.INHERITANCE).collect(Collectors.toList());
        }
        return super.getModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }
}

