/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.dbeaver.model.fs.nio.NIOFileInfo;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class NIOFileStore
extends FileStore {
    private final URI dbvfsURI;
    private final Path path;

    public NIOFileStore(URI dbvfsURI, Path path) {
        this.dbvfsURI = dbvfsURI;
        this.path = path;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return new String[0];
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return new NIOFileInfo(this.path);
    }

    public IFileStore getChild(String name) {
        return null;
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public IFileStore getParent() {
        return null;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(e));
        }
    }

    public URI toURI() {
        return this.dbvfsURI;
    }
}

