/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct;

import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;

public class DBSDocumentConstraint
implements DBSEntityConstraint,
DBSEntityReferrer {
    private final DBSDocumentContainer entity;

    public DBSDocumentConstraint(DBSDocumentContainer entity) {
        this.entity = entity;
    }

    @Override
    @NotNull
    public DBSDocumentContainer getParentObject() {
        return this.entity;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity.getDataSource();
    }

    @Override
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.PRIMARY_KEY;
    }

    @Override
    @NotNull
    public String getName() {
        return "DocumentKey";
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isPersisted() {
        return false;
    }

    @Override
    @Nullable
    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        DBSEntityAttribute attribute = this.entity.getDocumentAttribute(monitor);
        return Collections.singletonList(() -> attribute);
    }
}

