/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2dl.ChopboxAnchor;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPolicy;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.requests.DirectEditRequest;
import org.eclipse.gef3.tools.DirectEditManager;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.ui.directedit.ExtendedDirectEditManager;
import org.jkiss.dbeaver.erd.ui.directedit.FigureEditorLocator;
import org.jkiss.dbeaver.erd.ui.figures.NoteFigure;
import org.jkiss.dbeaver.erd.ui.model.ERDContainerDecorated;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.policy.EntityConnectionEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.NoteDirectEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.NoteEditPolicy;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.controls.MultilineTextCellEditor;

public class NotePart
extends NodePart {
    private DirectEditManager manager;

    public ERDNote getNote() {
        return (ERDNote)this.getModel();
    }

    protected void createEditPolicies() {
        if (!this.getEditor().isReadOnly()) {
            boolean layoutEnabled = this.isLayoutEnabled();
            if (layoutEnabled) {
                this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new EntityConnectionEditPolicy());
                this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NoteEditPolicy());
                this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NoteDirectEditPolicy());
            }
            this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.performDirectEdit();
        } else if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        } else {
            this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
        }
    }

    public Command getCommand(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
        return super.getCommand(request);
    }

    private boolean directEditHitTest(Point requestLoc) {
        NoteFigure figure = (NoteFigure)this.getFigure();
        figure.translateToRelative((Translatable)requestLoc);
        return figure.containsPoint(requestLoc);
    }

    private void performDirectEdit() {
        if (this.manager == null) {
            NoteFigure figure = (NoteFigure)this.getFigure();
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, MultilineTextCellEditor.class, new FigureEditorLocator((IFigure)figure), (IFigure)figure, value -> null);
        }
        this.manager.show();
    }

    public String toString() {
        return (String)this.getNote().getObject();
    }

    public void handleNameChange(String value) {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setText((String)this.getNote().getObject());
        noteFigure.setVisible(true);
        this.refreshVisuals();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setText((String)this.getNote().getObject());
        noteFigure.setVisible(true);
        this.refreshVisuals();
    }

    protected NoteFigure createFigure() {
        NoteFigure noteFigure = new NoteFigure(this.getNote());
        ERDContainerDecorated.NodeVisualInfo visualInfo = ((DiagramPart)this.getParent()).getDiagram().getVisualInfo(this.getNote(), true);
        Rectangle bounds = visualInfo.initBounds;
        if (bounds != null) {
            noteFigure.setBounds(bounds);
            noteFigure.setPreferredSize(bounds.getSize());
        } else if (noteFigure.getSize().isEmpty()) {
            noteFigure.setPreferredSize(new Dimension(100, 50));
        }
        if (visualInfo.transparent) {
            noteFigure.setOpaque(false);
        }
        if (visualInfo.bgColor != null) {
            noteFigure.setBackgroundColor(visualInfo.bgColor);
        }
        if (visualInfo.fgColor != null) {
            noteFigure.setForegroundColor(visualInfo.fgColor);
        }
        if (visualInfo.borderWidth != 1) {
            noteFigure.setBorder(this.createBorder(visualInfo.borderWidth));
        }
        if (visualInfo.font != null) {
            noteFigure.setFont(visualInfo.font);
        }
        return noteFigure;
    }

    protected void refreshVisuals() {
        NoteFigure notefigure = (NoteFigure)this.getFigure();
        Point location = notefigure.getLocation();
        DiagramPart parent = (DiagramPart)this.getParent();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        parent.setLayoutConstraint((EditPart)this, (IFigure)notefigure, constraint);
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == DBPNamedObject.class) {
            return this.getNote();
        }
        return super.getAdapter(key);
    }

    @Override
    public ERDElement getElement() {
        return this.getNote();
    }
}

