/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.dialogs;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ColumnInfoPanel;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IDataController;
import org.jkiss.dbeaver.ui.data.IRowController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public abstract class ValueViewDialog
extends BaseDialog
implements IValueEditorStandalone {
    private static int dialogCount = 0;
    public static final String SETTINGS_SECTION_DI = "ValueViewDialog";
    private IValueController valueController;
    private Object editedValue;
    private boolean columnInfoVisible = true;
    private ColumnInfoPanel columnPanel;
    private final IDialogSettings dialogSettings;
    private boolean opened;

    protected ValueViewDialog(IValueController valueController) {
        super(valueController.getValueSite().getShell(), "Value view", null);
        this.setShellStyle(1136);
        this.valueController = valueController;
        this.dialogSettings = UIUtils.getDialogSettings((String)SETTINGS_SECTION_DI);
        if (this.dialogSettings.get(this.getInfoVisiblePrefId()) != null) {
            this.columnInfoVisible = this.dialogSettings.getBoolean(this.getInfoVisiblePrefId());
        }
        ++dialogCount;
    }

    @Override
    public void createControl() {
    }

    @Override
    public boolean isReadOnly() {
        return this.getValueController().isReadOnly();
    }

    protected IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    @Nullable
    protected IValueEditor createPanelEditor(Composite placeholder) throws DBException {
        IValueEditor editor = this.valueController.getValueManager().createEditor(this.valueController instanceof IAttributeController ? new ProxyAttributeValueController((IAttributeController)this.valueController, placeholder) : new ProxyValueController<IValueController>(this.valueController, placeholder));
        if (editor != null) {
            editor.createControl();
            Control control = editor.getControl();
            if (control != null) {
                control.setFocus();
            }
        }
        return editor;
    }

    public IValueController getValueController() {
        return this.valueController;
    }

    @Override
    public void showValueEditor() {
        if (!this.opened) {
            this.open();
        } else {
            this.getShell().setFocus();
        }
    }

    @Override
    public void closeValueEditor() {
        this.valueController = null;
        this.setReturnCode(1);
        this.close();
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogGroup = super.createDialogArea(parent);
        if (this.valueController instanceof IAttributeController) {
            final Link columnHideLink = new Link(dialogGroup, 0);
            columnHideLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValueViewDialog.this.columnInfoVisible = !ValueViewDialog.this.columnInfoVisible;
                    ValueViewDialog.this.dialogSettings.put(ValueViewDialog.this.getInfoVisiblePrefId(), ValueViewDialog.this.columnInfoVisible);
                    ValueViewDialog.this.initColumnInfoVisibility(columnHideLink);
                    ValueViewDialog.this.getShell().layout();
                    int width = ValueViewDialog.this.getShell().getSize().x;
                    ValueViewDialog.this.getShell().setSize(width, ValueViewDialog.this.getShell().computeSize((int)-1, (int)-1).y);
                }
            });
            this.columnPanel = new ColumnInfoPanel(dialogGroup, 2048, this.valueController);
            this.columnPanel.setLayoutData(new GridData(1808));
            this.initColumnInfoVisibility(columnHideLink);
        }
        return dialogGroup;
    }

    private void initColumnInfoVisibility(Link columnHideLink) {
        this.columnPanel.setVisible(this.columnInfoVisible);
        ((GridData)this.columnPanel.getLayoutData()).exclude = !this.columnInfoVisible;
        columnHideLink.setText("Column Info: (<a>" + (this.columnInfoVisible ? "hide" : "show") + "</a>)");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ResultSetMessages.dialog_value_view_button_save, true).setEnabled(!this.valueController.isReadOnly());
        boolean required = false;
        this.createButton(parent, 9, ResultSetMessages.dialog_value_view_button_sat_null, false).setEnabled(!this.valueController.isReadOnly() && !DBUtils.isNullValue((Object)this.valueController.getValue()) && !required);
        this.createButton(parent, 1, ResultSetMessages.dialog_value_view_button_cancel, false);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        String sizeString = this.dialogSettings.get(this.getDialogSizePrefId());
        if (!CommonUtils.isEmpty((String)sizeString) && sizeString.contains(":")) {
            int divPos = sizeString.indexOf(58);
            shell.setSize(new Point(Integer.parseInt(sizeString.substring(0, divPos)), Integer.parseInt(sizeString.substring(divPos + 1))));
            shell.layout();
        }
        Monitor primary = shell.getMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 3;
        shell.setLocation(x += dialogCount * 20, y += dialogCount * 20);
    }

    private String getInfoVisiblePrefId() {
        return String.valueOf(this.getClass().getSimpleName()) + "-" + CommonUtils.escapeIdentifier((String)this.getValueController().getValueType().getTypeName()) + "-columnInfoVisible";
    }

    private String getDialogSizePrefId() {
        return String.valueOf(this.getClass().getSimpleName()) + "-" + CommonUtils.escapeIdentifier((String)this.getValueController().getValueType().getTypeName()) + "-dialogSize";
    }

    @Override
    public void dispose() {
    }

    public final int open() {
        try {
            this.opened = true;
            int result = super.open();
            if (result == 0) {
                this.getValueController().updateValue(this.editedValue, true);
            }
            int n = result;
            return n;
        }
        finally {
            --dialogCount;
            this.valueController = null;
        }
    }

    protected void okPressed() {
        try {
            this.editedValue = this.extractEditorValue();
            super.okPressed();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.dialog_value_view_dialog_error_updating_title, ResultSetMessages.dialog_value_view_dialog_error_updating_message, (Throwable)e);
            super.cancelPressed();
        }
    }

    protected void buttonPressed(int buttonId) {
        Point size = this.getShell().getSize();
        String sizeString = String.valueOf(size.x) + ":" + size.y;
        this.dialogSettings.put(this.getDialogSizePrefId(), sizeString);
        if (buttonId == 9) {
            if (!this.valueController.isReadOnly()) {
                this.editedValue = BaseValueManager.makeNullValue(this.valueController);
            }
            super.okPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.valueController instanceof IAttributeController) {
            DBDAttributeBinding meta = ((IAttributeController)this.valueController).getBinding();
            shell.setText(meta.getName());
        }
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
    }

    private static class ProxyAttributeValueController
    extends ProxyValueController<IAttributeController>
    implements IAttributeController {
        public ProxyAttributeValueController(IAttributeController valueController, Composite placeholder) {
            super(valueController, placeholder);
        }

        @Override
        @NotNull
        public IRowController getRowController() {
            return ((IAttributeController)this.valueController).getRowController();
        }

        @Override
        @NotNull
        public DBDAttributeBinding getBinding() {
            return ((IAttributeController)this.valueController).getBinding();
        }

        @Override
        @NotNull
        public String getColumnId() {
            return ((IAttributeController)this.valueController).getColumnId();
        }

        @Override
        @Nullable
        public DBDRowIdentifier getRowIdentifier() {
            return ((IAttributeController)this.valueController).getRowIdentifier();
        }
    }

    private static class ProxyValueController<VC extends IValueController>
    implements IValueController {
        protected final VC valueController;
        protected final Composite placeholder;

        ProxyValueController(VC valueController, Composite placeholder) {
            this.valueController = valueController;
            this.placeholder = placeholder;
        }

        @Override
        @NotNull
        public DBCExecutionContext getExecutionContext() {
            return this.valueController.getExecutionContext();
        }

        @Override
        @NotNull
        public IDataController getDataController() {
            return this.valueController.getDataController();
        }

        @Override
        public String getValueName() {
            return this.valueController.getValueName();
        }

        @Override
        public DBSTypedObject getValueType() {
            return this.valueController.getValueType();
        }

        @Override
        public Object getValue() {
            return this.valueController.getValue();
        }

        @Override
        public void updateValue(Object value, boolean updatePresentation) {
            this.valueController.updateValue(value, updatePresentation);
        }

        @Override
        public void updateSelectionValue(Object value) {
            this.valueController.updateSelectionValue(value);
        }

        @Override
        public DBDValueHandler getValueHandler() {
            return this.valueController.getValueHandler();
        }

        @Override
        public IValueManager getValueManager() {
            return this.valueController.getValueManager();
        }

        @Override
        public IValueController.EditType getEditType() {
            return IValueController.EditType.PANEL;
        }

        @Override
        public boolean isReadOnly() {
            return this.valueController.isReadOnly();
        }

        @Override
        public IWorkbenchPartSite getValueSite() {
            return this.valueController.getValueSite();
        }

        @Override
        public Composite getEditPlaceholder() {
            return this.placeholder;
        }

        @Override
        public void refreshEditor() {
            this.valueController.refreshEditor();
        }

        @Override
        public void showMessage(String message, DBPMessageType messageType) {
        }
    }
}

