/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectNetworkProfiles
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.project.settings.networkProfiles";
    private static final Log log = Log.getLog(PrefPageProjectNetworkProfiles.class);
    private DBPProject projectMeta;
    private Table profilesTable;
    private TabFolder handlersFolder;
    private ToolItem deleteProfileItem;
    private ToolItem copyProfileItem;
    private List<NetworkHandlerDescriptor> allHandlers = new ArrayList<NetworkHandlerDescriptor>();
    private DBWNetworkProfile selectedProfile;
    private Map<NetworkHandlerDescriptor, HandlerBlock> configurations = new HashMap<NetworkHandlerDescriptor, HandlerBlock>();

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        CustomSashForm divider = UIUtils.createPartDivider(null, (Composite)parent, (int)256);
        Composite profilesGroup = new Composite((Composite)divider, 2048);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        profilesGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        profilesGroup.setLayoutData((Object)gd);
        ToolBar toolbar = new ToolBar(profilesGroup, 131328);
        UIUtils.createToolItem((ToolBar)toolbar, (String)CoreMessages.pref_page_network_profiles_tool_create_title, (String)CoreMessages.pref_page_network_profiles_tool_create_text, (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectNetworkProfiles.this.createNewProfile(null);
            }
        });
        this.deleteProfileItem = UIUtils.createToolItem((ToolBar)toolbar, (String)CoreMessages.pref_page_network_profiles_tool_delete_title, (String)CoreMessages.pref_page_network_profiles_tool_delete_text, (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List usedBy = PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().getDataSourcesByProfile(PrefPageProjectNetworkProfiles.this.selectedProfile);
                if (!usedBy.isEmpty()) {
                    UIUtils.showMessageBox((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)CoreMessages.pref_page_network_profiles_tool_delete_dialog_error_title, (String)NLS.bind((String)CoreMessages.pref_page_network_profiles_tool_delete_dialog_error_info, (Object[])new Object[]{PrefPageProjectNetworkProfiles.this.selectedProfile.getProfileName(), usedBy.size(), usedBy.stream().sorted(Comparator.comparing(DBPNamedObject::getName)).map(x -> " - " + x.getName()).collect(Collectors.joining("\n"))}), (int)1);
                    return;
                }
                if (UIUtils.confirmAction((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)CoreMessages.pref_page_network_profiles_tool_delete_confirmation_title, (String)NLS.bind((String)CoreMessages.pref_page_network_profiles_tool_delete_confirmation_question, (Object)PrefPageProjectNetworkProfiles.this.selectedProfile.getProfileName()))) {
                    PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().removeNetworkProfile(PrefPageProjectNetworkProfiles.this.selectedProfile);
                    PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().flushConfig();
                    int index = PrefPageProjectNetworkProfiles.this.profilesTable.getSelectionIndex();
                    PrefPageProjectNetworkProfiles.this.profilesTable.remove(index);
                    PrefPageProjectNetworkProfiles.this.profilesTable.select(CommonUtils.clamp((int)index, (int)0, (int)(PrefPageProjectNetworkProfiles.this.profilesTable.getItemCount() - 1)));
                    PrefPageProjectNetworkProfiles.this.profilesTable.notifyListeners(13, new Event());
                    PrefPageProjectNetworkProfiles.this.updateControlsState();
                }
            }
        });
        this.copyProfileItem = UIUtils.createToolItem((ToolBar)toolbar, (String)CoreMessages.pref_page_network_profiles_tool_copy_title, (String)CoreMessages.pref_page_network_profiles_tool_copy_text, (DBPImage)UIIcon.ROW_COPY, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectNetworkProfiles.this.createNewProfile(PrefPageProjectNetworkProfiles.this.selectedProfile);
            }
        });
        this.profilesTable = new Table(profilesGroup, 4);
        gd = new GridData(1808);
        gd.minimumWidth = 150;
        this.profilesTable.setLayoutData((Object)gd);
        this.profilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectNetworkProfiles.this.saveHandlerSettings();
                Object[] selection = PrefPageProjectNetworkProfiles.this.profilesTable.getSelection();
                PrefPageProjectNetworkProfiles.this.selectedProfile = ArrayUtils.isEmpty((Object[])selection) ? null : (DBWNetworkProfile)selection[0].getData();
                PrefPageProjectNetworkProfiles.this.updateControlsState();
            }
        });
        this.handlersFolder = new TabFolder((Composite)divider, 0x800080);
        this.handlersFolder.setLayoutData((Object)new GridData(1808));
        for (NetworkHandlerDescriptor nhd : NetworkHandlerRegistry.getInstance().getDescriptors()) {
            if (nhd.hasObjectTypes()) continue;
            this.createHandlerTab(nhd);
        }
        this.handlersFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectNetworkProfiles.this.updateControlsState();
            }
        });
        divider.setWeights(new int[]{300, 700});
        this.performDefaults();
        return divider;
    }

    private void createNewProfile(@Nullable DBWNetworkProfile sourceProfile) {
        String profileName;
        String string = profileName = sourceProfile == null ? "" : sourceProfile.getProfileName();
        while (true) {
            if (CommonUtils.isEmptyTrimmed((String)(profileName = EnterNameDialog.chooseName((Shell)this.getShell(), (String)CoreMessages.pref_page_network_profiles_tool_create_dialog_profile_name, (String)profileName)))) {
                return;
            }
            if (this.projectMeta.getDataSourceRegistry().getNetworkProfile(profileName) == null) break;
            UIUtils.showMessageBox((Shell)this.getShell(), (String)CoreMessages.pref_page_network_profiles_tool_create_dialog_error_title, (String)NLS.bind((String)CoreMessages.pref_page_network_profiles_tool_create_dialog_error_info, (Object)profileName, (Object)this.projectMeta.getName()), (int)1);
        }
        DBWNetworkProfile newProfile = new DBWNetworkProfile(this.projectMeta);
        newProfile.setProfileName(profileName);
        if (sourceProfile != null) {
            newProfile.setProperties(new LinkedHashMap(sourceProfile.getProperties()));
            for (DBWHandlerConfiguration configuration : sourceProfile.getConfigurations()) {
                newProfile.getConfigurations().add(new DBWHandlerConfiguration(configuration));
            }
            for (HandlerBlock handler : this.configurations.values()) {
                DBWHandlerConfiguration configuration = handler.loadedConfigs.get(sourceProfile);
                if (configuration == null) continue;
                handler.loadedConfigs.put(newProfile, new DBWHandlerConfiguration(configuration));
            }
        }
        this.projectMeta.getDataSourceRegistry().updateNetworkProfile(newProfile);
        this.projectMeta.getDataSourceRegistry().flushConfig();
        TableItem item = new TableItem(this.profilesTable, 0);
        item.setText(newProfile.getProfileName());
        item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
        item.setData((Object)newProfile);
        this.profilesTable.select(this.profilesTable.getItemCount() - 1);
        this.profilesTable.notifyListeners(13, new Event());
    }

    private void saveHandlerSettings() {
        if (this.selectedProfile == null) {
            return;
        }
        TabItem[] tabItemArray = this.handlersFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem handlerTab = tabItemArray[n2];
            NetworkHandlerDescriptor handler = (NetworkHandlerDescriptor)handlerTab.getData();
            HandlerBlock handlerBlock = this.configurations.get(handler);
            DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(this.selectedProfile);
            if (handlerBlock.useHandlerCheck.getSelection()) {
                if (handlerConfiguration == null) {
                    handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)handler, null);
                }
                handlerConfiguration.setProperties(Collections.emptyMap());
                handlerBlock.configurator.saveSettings((Object)handlerConfiguration);
            }
            ++n2;
        }
    }

    private void updateControlsState() {
        NetworkHandlerDescriptor descriptor = this.getSelectedHandler();
        this.enableHandlerContent(descriptor);
        if (descriptor != null && this.selectedProfile != null) {
            HandlerBlock handlerBlock = this.configurations.get(descriptor);
            DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(this.selectedProfile);
            if (handlerConfiguration == null) {
                handlerBlock.configurator.loadSettings((Object)new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, null));
            } else {
                handlerBlock.configurator.loadSettings((Object)handlerConfiguration);
            }
        }
        this.deleteProfileItem.setEnabled(this.selectedProfile != null);
        this.copyProfileItem.setEnabled(this.selectedProfile != null);
    }

    @Nullable
    private NetworkHandlerDescriptor getSelectedHandler() {
        Object[] selection = this.handlersFolder.getSelection();
        return ArrayUtils.isEmpty((Object[])selection) ? null : (NetworkHandlerDescriptor)selection[0].getData();
    }

    private void createHandlerTab(final NetworkHandlerDescriptor descriptor) {
        IObjectPropertyConfigurator configurator;
        try {
            String implName = descriptor.getHandlerType().getImplName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor == null) {
                return;
            }
            configurator = configDescriptor.createConfigurator();
        }
        catch (DBException e) {
            log.error((Object)("Can't create network configurator '" + descriptor.getId() + "'"), (Throwable)e);
            return;
        }
        this.allHandlers.add(descriptor);
        TabItem tabItem = new TabItem(this.handlersFolder, 0);
        tabItem.setText(descriptor.getLabel());
        tabItem.setToolTipText(descriptor.getDescription());
        tabItem.setData((Object)descriptor);
        Composite composite = new Composite((Composite)this.handlersFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        final Button useHandlerCheck = UIUtils.createCheckbox((Composite)composite, (String)NLS.bind((String)CoreMessages.dialog_tunnel_checkbox_use_handler, (Object)descriptor.getLabel()), (boolean)false);
        useHandlerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageProjectNetworkProfiles.this.selectedProfile == null) {
                    useHandlerCheck.setSelection(false);
                    UIUtils.showMessageBox((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)CoreMessages.pref_page_network_profiles_tool_no_profile_error_title, (String)CoreMessages.pref_page_network_profiles_tool_no_profile_error_information, (int)2);
                    return;
                }
                HandlerBlock handlerBlock = PrefPageProjectNetworkProfiles.this.configurations.get(descriptor);
                DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(PrefPageProjectNetworkProfiles.this.selectedProfile);
                if (handlerConfiguration == null) {
                    handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, null);
                    handlerBlock.loadedConfigs.put(PrefPageProjectNetworkProfiles.this.selectedProfile, handlerConfiguration);
                }
                handlerConfiguration.setEnabled(useHandlerCheck.getSelection());
                PrefPageProjectNetworkProfiles.this.enableHandlerContent(descriptor);
            }
        });
        Composite handlerComposite = UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.configurations.put(descriptor, new HandlerBlock((IObjectPropertyConfigurator<Object, DBWHandlerConfiguration>)configurator, handlerComposite, useHandlerCheck));
        handlerComposite.setLayoutData((Object)new GridData(1808));
        configurator.createControl(handlerComposite, (Object)descriptor, () -> ((PrefPageProjectNetworkProfiles)this).updateApplyButton());
        this.enableHandlerContent(descriptor);
    }

    private void enableHandlerContent(NetworkHandlerDescriptor descriptor) {
        HandlerBlock handlerBlock = this.configurations.get(descriptor);
        DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(this.selectedProfile);
        handlerBlock.useHandlerCheck.setSelection(handlerConfiguration != null && handlerConfiguration.isEnabled());
        if (handlerConfiguration != null && handlerConfiguration.isEnabled()) {
            if (handlerBlock.blockEnableState != null) {
                handlerBlock.blockEnableState.restore();
                handlerBlock.blockEnableState = null;
            }
        } else if (handlerBlock.blockEnableState == null) {
            handlerBlock.blockEnableState = ControlEnableState.disable((Control)handlerBlock.blockControl);
        }
    }

    public void saveSettings(DBWNetworkProfile profile) {
        for (HandlerBlock handlerBlock : this.configurations.values()) {
            DBWHandlerConfiguration configuration = handlerBlock.loadedConfigs.get(profile);
            if (configuration == null) continue;
            profile.updateConfiguration(configuration);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.profilesTable.removeAll();
        if (this.projectMeta != null) {
            DBSSecretController secretController = null;
            if (this.projectMeta.isUseSecretStorage()) {
                secretController = DBSSecretController.getProjectSecretController((DBPProject)this.projectMeta);
            }
            for (DBWNetworkProfile profile : this.projectMeta.getDataSourceRegistry().getNetworkProfiles()) {
                if (secretController != null) {
                    try {
                        profile.resolveSecrets(secretController);
                    }
                    catch (DBException dBException) {
                        log.error((Object)("Error resolving secret configuration for profile " + profile.getProfileId()));
                    }
                }
                TableItem item = new TableItem(this.profilesTable, 0);
                item.setText(profile.getProfileName());
                item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
                item.setData((Object)profile);
                if (this.selectedProfile == null) {
                    this.selectedProfile = profile;
                    this.profilesTable.select(0);
                }
                for (NetworkHandlerDescriptor nhd : this.allHandlers) {
                    HandlerBlock handlerBlock = this.configurations.get(nhd);
                    DBWHandlerConfiguration configuration = profile.getConfiguration((DBWHandlerDescriptor)nhd);
                    if (configuration == null) continue;
                    handlerBlock.loadedConfigs.put(profile, configuration);
                }
            }
        }
        this.updateControlsState();
    }

    public boolean performOk() {
        this.saveHandlerSettings();
        TableItem[] tableItemArray = this.profilesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DBWNetworkProfile profile = (DBWNetworkProfile)item.getData();
            this.saveSettings(profile);
            this.projectMeta.getDataSourceRegistry().updateNetworkProfile(profile);
            ++n2;
        }
        this.projectMeta.getDataSourceRegistry().flushConfig();
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.projectMeta == null ? null : this.projectMeta.getEclipseProject();
    }

    public void setElement(IAdaptable element) {
        IProject iProject = element instanceof DBNNode ? ((DBNNode)element).getOwnerProject().getEclipseProject() : (IProject)GeneralUtils.adapt((Object)element, IProject.class);
        if (iProject != null) {
            this.projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(iProject);
        }
    }

    public void applyData(Object data) {
        DBWNetworkProfile profile = this.projectMeta.getDataSourceRegistry().getNetworkProfile(CommonUtils.toString((Object)data));
        if (profile != null) {
            TableItem[] items = this.profilesTable.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() == profile) {
                    this.profilesTable.select(i);
                    this.profilesTable.notifyListeners(13, new Event());
                    break;
                }
                ++i;
            }
        }
    }

    private static class HandlerBlock {
        private final IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> configurator;
        private final Composite blockControl;
        private final Button useHandlerCheck;
        private ControlEnableState blockEnableState;
        private final Map<DBWNetworkProfile, DBWHandlerConfiguration> loadedConfigs = new HashMap<DBWNetworkProfile, DBWHandlerConfiguration>();

        private HandlerBlock(IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> configurator, Composite blockControl, Button useHandlerCheck) {
            this.configurator = configurator;
            this.blockControl = blockControl;
            this.useHandlerCheck = useHandlerCheck;
        }
    }
}

