/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.data;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.dbeaver.ui.search.AbstractSearchPage;
import org.jkiss.dbeaver.ui.search.data.SearchDataParams;
import org.jkiss.dbeaver.ui.search.data.SearchDataQuery;
import org.jkiss.dbeaver.ui.search.internal.UISearchMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SearchDataPage
extends AbstractSearchPage {
    private static final String PROP_MASK = "search.data.mask";
    private static final String PROP_CASE_SENSITIVE = "search.data.case-sensitive";
    private static final String PROP_SAMPLE_ROWS = "search.data.sample-rows";
    private static final String PROP_FAST_SEARCH = "search.data.fast-search";
    private static final String PROP_SEARCH_NUMBERS = "search.data.search-numbers";
    private static final String PROP_SEARCH_LOBS = "search.data.search-lobs";
    private static final String PROP_SEARCH_FOREIGN = "search.data.search-foreign";
    private static final String PROP_HISTORY = "search.data.history";
    private static final String PROP_SOURCES = "search.data.object-source";
    private Combo searchText;
    private SearchDataParams params = new SearchDataParams();
    private Set<String> searchHistory = new LinkedHashSet<String>();
    private DatabaseNavigatorTree navigatorTree;
    private DBPProject currentProject = NavigatorUtils.getSelectedProject();

    public SearchDataPage() {
        super("Database objects search");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeDialogUnits((Control)parent);
        Composite searchGroup = UIUtils.createComposite((Composite)parent, (int)1);
        searchGroup.setLayoutData((Object)new GridData(1808));
        this.searchText = new Combo(searchGroup, 4);
        this.searchText.setLayoutData((Object)new GridData(768));
        UIUtils.addEmptyTextHint((Control)this.searchText, combo -> UISearchMessages.dialog_data_search_hint_text_string_to_search);
        if (this.params.searchString != null) {
            this.searchText.setText(this.params.searchString);
        }
        for (String history : this.searchHistory) {
            this.searchText.add(history);
        }
        this.searchText.addModifyListener(e -> {
            this.params.searchString = this.searchText.getText();
            this.updateEnablement();
        });
        SashForm optionsGroup = new SashForm(parent, 0);
        optionsGroup.setLayoutData((Object)new GridData(1808));
        Group databasesGroup = UIUtils.createControlGroup((Composite)optionsGroup, (String)UISearchMessages.dialog_data_search_control_group_databases, (int)1, (int)1808, (int)0);
        databasesGroup.setLayoutData((Object)new GridData(1808));
        DBPPlatform platform = DBWorkbench.getPlatform();
        DBNProject projectNode = platform.getNavigatorModel().getRoot().getProjectNode(this.currentProject);
        DBNProjectDatabases rootNode = projectNode == null ? platform.getNavigatorModel().getRoot() : projectNode.getDatabases();
        this.navigatorTree = new DatabaseNavigatorTree((Composite)databasesGroup, (DBNNode)rootNode, 2);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        this.navigatorTree.setLayoutData((Object)gd);
        TreeViewer treeViewer = this.navigatorTree.getViewer();
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        Class folderItemsClass = folder.getChildrenClass();
                        return folderItemsClass != null && (DBSObjectContainer.class.isAssignableFrom(folderItemsClass) || DBSEntity.class.isAssignableFrom(folderItemsClass));
                    }
                    if (element instanceof DBNProjectDatabases || element instanceof DBNLocalFolder || element instanceof DBNDataSource) {
                        return true;
                    }
                    if (element instanceof DBSWrapper) {
                        DBSObject object = ((DBSWrapper)element).getObject();
                        if (object instanceof DBSDataContainer && object instanceof DBSEntity && !((DBSDataContainer)object).isFeatureSupported("data.search")) {
                            return false;
                        }
                        return object instanceof DBSInstance || object instanceof DBSObjectContainer || object instanceof DBSDataContainer && object instanceof DBSEntity;
                    }
                }
                return false;
            }
        });
        treeViewer.addSelectionChangedListener(event -> this.updateEnablement());
        treeViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (node instanceof TreeNodeSpecial) {
                    ((TreeNodeSpecial)node).handleDefaultAction(this.navigatorTree);
                }
                ++n2;
            }
        });
        Group optionsGroup2 = UIUtils.createControlGroup((Composite)optionsGroup, (String)UISearchMessages.dialog_data_search_control_group_settings, (int)2, (int)768, (int)0);
        optionsGroup2.setLayoutData((Object)new GridData(802));
        if (this.params.maxResults <= 0) {
            this.params.maxResults = 10;
        }
        Spinner maxResultsSpinner = UIUtils.createLabelSpinner((Composite)optionsGroup2, (String)UISearchMessages.dialog_data_search_spinner_max_results, (String)UISearchMessages.dialog_data_search_spinner_max_results_tip, (int)this.params.maxResults, (int)1, (int)Integer.MAX_VALUE);
        maxResultsSpinner.setLayoutData((Object)new GridData(32));
        maxResultsSpinner.addModifyListener(e -> {
            int n = this.params.maxResults = maxResultsSpinner.getSelection();
        });
        final Button caseCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)UISearchMessages.dialog_search_objects_case_sensitive, (String)UISearchMessages.dialog_data_search_checkbox_case_sensitive_tip, (boolean)this.params.caseSensitive, (int)2);
        caseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDataPage.this.params.caseSensitive = caseCheckbox.getSelection();
            }
        });
        final Button fastSearchCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)UISearchMessages.dialog_data_search_checkbox_fast_search, (String)UISearchMessages.dialog_data_search_checkbox_fast_search_tip, (boolean)this.params.fastSearch, (int)2);
        fastSearchCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDataPage.this.params.fastSearch = fastSearchCheckbox.getSelection();
            }
        });
        final Button searchNumbersCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)UISearchMessages.dialog_data_search_checkbox_search_in_numbers, (String)UISearchMessages.dialog_data_search_checkbox_search_in_numbers_tip, (boolean)this.params.searchNumbers, (int)2);
        searchNumbersCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDataPage.this.params.searchNumbers = searchNumbersCheckbox.getSelection();
            }
        });
        Button searchLOBCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)UISearchMessages.dialog_data_search_checkbox_search_in_lob, (String)UISearchMessages.dialog_data_search_checkbox_search_in_lob_tip, (boolean)this.params.searchLOBs, (int)2);
        searchLOBCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDataPage.this.params.searchLOBs = searchNumbersCheckbox.getSelection();
            }
        });
        final Button searchForeignCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)UISearchMessages.dialog_data_search_checkbox_search_in_foreign_objects, (String)UISearchMessages.dialog_data_search_checkbox_search_in_foreign_objects_tip, (boolean)this.params.searchForeignObjects, (int)2);
        searchForeignCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDataPage.this.params.searchForeignObjects = searchForeignCheckbox.getSelection();
            }
        });
        CLabel infoLabel = UIUtils.createInfoLabel((Composite)optionsGroup2, (String)UISearchMessages.dialog_data_search_info_label_use_ctrl, (int)1808, (int)2);
        GridData gridData = new GridData(4, 0x1000008, true, true);
        gridData.horizontalSpan = 2;
        infoLabel.setLayoutData((Object)gridData);
        UIUtils.asyncExec(this::restoreCheckedNodes);
        if (!this.params.selectedNodes.isEmpty()) {
            this.navigatorTree.getViewer().setSelection((ISelection)new StructuredSelection(this.params.selectedNodes));
        }
        this.navigatorTree.setEnabled(true);
        this.setControl((Control)searchGroup);
    }

    @Override
    public SearchDataQuery createQuery() throws DBException {
        this.params.sources = this.getCheckedSources();
        if (!this.searchHistory.contains(this.params.searchString)) {
            this.searchHistory.add(this.params.searchString);
            this.searchText.add(this.params.searchString);
        }
        return SearchDataQuery.createQuery(this.params);
    }

    @Override
    public void loadState(DBPPreferenceStore store) {
        String history;
        this.params.searchString = store.getString(PROP_MASK);
        this.params.caseSensitive = store.getBoolean(PROP_CASE_SENSITIVE);
        this.params.fastSearch = store.getBoolean(PROP_FAST_SEARCH);
        this.params.searchNumbers = store.getString(PROP_SEARCH_NUMBERS) == null || store.getBoolean(PROP_SEARCH_NUMBERS);
        this.params.searchLOBs = store.getBoolean(PROP_SEARCH_LOBS);
        this.params.searchForeignObjects = store.getBoolean(PROP_SEARCH_FOREIGN);
        this.params.maxResults = store.getInt(PROP_SAMPLE_ROWS);
        int i = 0;
        while (!CommonUtils.isEmpty((String)(history = store.getString("search.data.history." + i)))) {
            this.searchHistory.add(history);
            ++i;
        }
        this.params.selectedNodes.clear();
        ISelection selection = this.container.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selItem = objectArray[n2];
                if (selItem instanceof DBNNode) {
                    this.params.selectedNodes.add((DBNNode)selItem);
                }
                ++n2;
            }
        }
    }

    @Override
    public void saveState(@NotNull DBPPreferenceStore store) {
        store.setValue(PROP_MASK, this.params.searchString);
        store.setValue(PROP_CASE_SENSITIVE, this.params.caseSensitive);
        store.setValue(PROP_SAMPLE_ROWS, this.params.maxResults);
        store.setValue(PROP_FAST_SEARCH, this.params.fastSearch);
        store.setValue(PROP_SEARCH_NUMBERS, this.params.searchNumbers);
        store.setValue(PROP_SEARCH_LOBS, this.params.searchLOBs);
        store.setValue(PROP_SEARCH_FOREIGN, this.params.searchForeignObjects);
        this.saveTreeState(store);
        int historyIndex = 0;
        for (String history : this.searchHistory) {
            if (historyIndex >= 20) break;
            store.setValue("search.data.history." + historyIndex, history);
            ++historyIndex;
        }
    }

    private Object[] getCheckedElements() {
        Object[] objects = ((IStructuredSelection)this.navigatorTree.getViewer().getSelection()).toArray();
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return new Object[0];
        }
        return objects;
    }

    private List<DBSDataContainer> getCheckedSources() {
        ArrayList<DBSDataContainer> result = new ArrayList<DBSDataContainer>();
        Object[] elements = this.getCheckedElements();
        RuntimeUtils.runTask(monitor -> {
            Object[] objectArray2 = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray2[n2];
                if (node instanceof DBNDatabaseNode) {
                    DBSObject object = ((DBNDatabaseNode)node).getObject();
                    try {
                        List containers = DBUtils.getAllDataContainersFromParentContainer((DBRProgressMonitor)monitor, (DBSObject)object);
                        if (!CommonUtils.isEmpty((Collection)containers)) {
                            result.addAll(containers);
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                ++n2;
            }
        }, (String)"Loading all objects for search", (long)5000L);
        return result;
    }

    @Override
    protected void updateEnablement() {
        this.container.setPerformActionEnabled(this.hasCheckedNodes());
    }

    private boolean hasCheckedNodes() {
        Object[] objectArray = this.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNNode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void saveTreeState(@NotNull DBPPreferenceStore store) {
        Object[] nodes;
        StringBuilder sourcesString = new StringBuilder();
        Object[] objectArray = nodes = this.getCheckedElements();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject object;
            Object node = objectArray[n2];
            if (node instanceof DBNDatabaseNode && ((object = ((DBNDatabaseNode)node).getObject()) instanceof DBSDataContainer || object instanceof DBSObjectContainer)) {
                if (sourcesString.length() > 0) {
                    sourcesString.append("|");
                }
                sourcesString.append(((DBNDatabaseNode)node).getNodeItemPath());
            }
            ++n2;
        }
        store.setValue(PROP_SOURCES, sourcesString.toString());
    }

    private List<DBNNode> loadTreeState(DBRProgressMonitor monitor) {
        return this.loadTreeState(monitor, NavigatorUtils.getSelectedProject(), DBWorkbench.getPlatform().getPreferenceStore().getString(PROP_SOURCES));
    }

    private void restoreCheckedNodes() {
        ArrayList checkedNodes = new ArrayList();
        try {
            this.container.getRunnableContext().run(false, true, monitor -> {
                monitor.beginTask("Load database nodes", 1);
                try {
                    monitor.subTask("Load tree state");
                    checkedNodes.addAll(this.loadTreeState((DBRProgressMonitor)new DefaultProgressMonitor(monitor)));
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data sources load", "Error loading settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (!checkedNodes.isEmpty()) {
            this.navigatorTree.getViewer().setSelection((ISelection)new StructuredSelection(checkedNodes));
            DBNDataSource node = DBNDataSource.getDataSourceNode((DBNNode)((DBNNode)checkedNodes.get(0)));
            if (node != null) {
                this.navigatorTree.getViewer().reveal((Object)node);
            }
            this.updateEnablement();
        }
    }
}

