/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIElementFontStyle;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomToolTipHandler;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCellRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumnRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridRowNested;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridRowRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridController;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridScrollBar;
import org.jkiss.dbeaver.ui.controls.lightgrid.NullScrollBar;
import org.jkiss.dbeaver.ui.controls.lightgrid.ScrollBarAdapter;
import org.jkiss.dbeaver.ui.dnd.LocalObjectTransfer;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public abstract class LightGrid
extends Canvas {
    private static final Log log = Log.getLog(LightGrid.class);
    private static final int MAX_TOOLTIP_LENGTH = 1000;
    protected static final int Event_ChangeSort = 1000;
    protected static final int Event_NavigateLink = 1001;
    protected static final int Event_FilterColumn = 1002;
    private static final int HORZ_SCROLL_INCREMENT = 12;
    private static final int COLUMN_RESIZER_THRESHOLD = 4;
    private static final int DEFAULT_ROW_HEADER_WIDTH = 30;
    private static final int MAX_ROW_HEADER_WIDTH = 400;
    private static final int MIN_COLUMN_HEADER_WIDTH = 32;
    private static final int SELECTION_DRAG_BORDER_THRESHOLD = 2;
    private boolean controlWasHidden;
    private static volatile Rectangle lastClientArea;
    private boolean scrollValuesObsolete = false;
    private int focusItem = -1;
    private final Set<GridPos> selectedCells = new TreeSet<GridPos>(new GridPos.PosComparator());
    private final List<GridPos> selectedCellsBeforeRangeSelect = new ArrayList<GridPos>();
    private final List<GridColumn> selectedColumns = new ArrayList<GridColumn>();
    private final IntKeyMap<Boolean> selectedRows = new IntKeyMap();
    private boolean cellDragSelectionOccurring = false;
    private boolean cellRowDragSelectionOccurring = false;
    private boolean cellColumnDragSelectionOccurring = false;
    private boolean cellDragCTRL = false;
    private boolean followupCellSelectionEventOwed = false;
    private boolean cellSelectedOnLastMouseDown;
    private boolean cellRowSelectedOnLastMouseDown;
    private boolean cellColumnSelectedOnLastMouseDown;
    private boolean headerColumnDragStarted;
    private boolean rowHeaderDragStarted;
    private GridColumn shiftSelectionAnchorColumn;
    private GridColumn focusColumn;
    private final GridPos focusCell = new GridPos(-1, -1);
    private final List<GridColumn> topColumns = new ArrayList<GridColumn>();
    private final List<GridColumn> columns = new ArrayList<GridColumn>();
    private int maxColumnDepth = 0;
    protected IGridRow[] gridRows = new IGridRow[0];
    private final Map<RowLocation, RowExpandState> expandedRows = new HashMap<RowLocation, RowExpandState>();
    private int maxColumnDefWidth = 1000;
    private final GridColumnRenderer columnHeaderRenderer;
    private final GridRowRenderer rowHeaderRenderer;
    private final GridCellRenderer cellRenderer;
    private boolean rowHeaderVisible = false;
    private boolean columnHeadersVisible = false;
    private int selectionType = 4;
    private int itemHeight = 1;
    private int rowHeaderWidth = 0;
    private int headerHeight = 0;
    private boolean hoveringOnHeader = false;
    private boolean hoveringOnColumnIcon = false;
    private boolean hoveringOnColumnSorter = false;
    private boolean hoveringOnColumnFilter = false;
    private boolean hoveringOnLink = false;
    private boolean hoveringOnRowHeader = false;
    private GridColumn columnBeingSorted;
    private GridColumn columnBeingFiltered;
    private boolean hoveringOnColumnResizer = false;
    private GridColumn columnBeingResized;
    private boolean resizingColumn = false;
    private int resizingStartX = 0;
    private int resizingColumnStartWidth = 0;
    private int hoveringItem;
    private GridColumn hoveringColumn;
    private GridColumn draggingColumn;
    private Integer hoveringRow;
    private Integer draggingRow;
    private Object hoveringDetail = null;
    private boolean linesVisible = true;
    @NotNull
    private final IGridScrollBar vScroll;
    @NotNull
    private final IGridScrollBar hScroll;
    private int shiftSelectionAnchorItem;
    private boolean columnScrolling = false;
    private Listener disposeListener;
    final GC sizingGC = new GC((Drawable)this);
    FontMetrics fontMetrics = this.sizingGC.getFontMetrics();
    Font normalFont = this.getFont();
    Font boldFont = UIUtils.makeBoldFont((Font)this.normalFont);
    Font italicFont = UIUtils.modifyFont((Font)this.normalFont, (int)2);
    @NotNull
    private Color lineColor;
    private Color lineSelectedColor;
    private Color backgroundColor;
    private Color foregroundColor;
    @NotNull
    private Cursor sortCursor;
    private final CustomToolTipHandler toolTipHandler;
    private int topIndex = -1;
    private int bottomIndex = -1;
    private boolean bottomIndexShownCompletely = false;
    private String displayedToolTipText;
    private boolean hoveringOnHeaderDragArea = false;

    private static int checkStyle(int style) {
        int mask = 369625894;
        int newStyle = style & mask;
        return newStyle |= 0x20000000;
    }

    public LightGrid(Composite parent, int style) {
        super(parent, LightGrid.checkStyle(style));
        this.columnHeaderRenderer = new GridColumnRenderer(this);
        this.rowHeaderRenderer = new GridRowRenderer(this);
        this.cellRenderer = new GridCellRenderer(this);
        Display display = this.getDisplay();
        this.lineColor = JFaceColors.getErrorBackground((Display)display);
        this.lineSelectedColor = JFaceColors.getErrorBorder((Display)display);
        this.sortCursor = display.getSystemCursor(21);
        if ((style & 2) != 0) {
            this.selectionType = 2;
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setVisible(false);
            this.vScroll = new ScrollBarAdapter(this.getVerticalBar(), true);
        } else {
            this.vScroll = new NullScrollBar();
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setVisible(false);
            this.hScroll = new ScrollBarAdapter(this.getHorizontalBar(), false);
        } else {
            this.hScroll = new NullScrollBar();
        }
        this.scrollValuesObsolete = true;
        this.toolTipHandler = new CustomToolTipHandler((Control)this);
        this.initListeners();
        this.recalculateSizes(true);
        this.addDragAndDropSupport();
        this.setDragDetect(false);
    }

    @NotNull
    public abstract IGridContentProvider getContentProvider();

    @NotNull
    public abstract IGridLabelProvider getLabelProvider();

    @Nullable
    public abstract IGridController getGridController();

    public void setMaxColumnDefWidth(int maxColumnDefWidth) {
        this.maxColumnDefWidth = maxColumnDefWidth;
    }

    private void collectRowsFromElements(List<IGridRow> result, Object[] elements) {
        int index = 0;
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element != null) {
                GridRow row = new GridRow(element, i, index);
                result.add(row);
                ++index;
                int maxColLength = this.getNestedRowsCount(row);
                if (maxColLength > 0) {
                    index = this.collectNestedRows(result, row, index, maxColLength);
                }
            }
            ++i;
        }
    }

    private int getNestedRowsCount(IGridRow row) {
        if (this.expandedRows.isEmpty()) {
            return 0;
        }
        RowExpandState rowState = this.expandedRows.get(new RowLocation(row));
        return rowState != null && rowState.isAnyColumnExpanded() ? rowState.getMaxLength() : 0;
    }

    private int collectNestedRows(List<IGridRow> result, IGridRow parentRow, int index, int colLength) {
        int i = 0;
        while (i < colLength) {
            GridRowNested nestedRow = new GridRowNested(parentRow, index++);
            result.add(nestedRow);
            int maxNestedColLength = this.getNestedRowsCount(nestedRow);
            if (maxNestedColLength > 0) {
                index = this.collectNestedRows(result, nestedRow, index, maxNestedColLength);
            }
            ++i;
        }
        return index;
    }

    public void refreshData(boolean refreshColumns, boolean keepState, boolean fitValue) {
        GridPos savedFocus = keepState ? this.getFocusPos() : null;
        int savedHSB = keepState ? this.hScroll.getSelection() : -1;
        int savedVSB = keepState ? this.vScroll.getSelection() : -1;
        HashMap<Object, Integer> oldWidths = null;
        if (keepState && !this.controlWasHidden) {
            oldWidths = new HashMap<Object, Integer>();
            if (!this.columns.isEmpty()) {
                for (GridColumn column : this.columns) {
                    oldWidths.put(column.getElement(), column.getWidth());
                }
            }
        }
        if (this.controlWasHidden) {
            refreshColumns = true;
        }
        boolean bl = this.controlWasHidden = this.getClientArea().height == 0;
        if (refreshColumns) {
            this.removeAll();
        } else {
            this.deselectAll();
            this.topIndex = -1;
            this.bottomIndex = -1;
        }
        IGridContentProvider contentProvider = this.getContentProvider();
        Object[] columnElements = null;
        if (refreshColumns) {
            this.maxColumnDepth = 0;
            Object[] objectArray = columnElements = contentProvider.getElements(true);
            int n = columnElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object columnElement = objectArray[n2];
                GridColumn column = new GridColumn(this, columnElement);
                this.createChildColumns(column);
                ++n2;
            }
        }
        this.refreshRowsData();
        this.displayedToolTipText = null;
        if (refreshColumns) {
            boolean hasChildColumns = false;
            boolean hasPinnedColumns = false;
            Iterator<GridColumn> iter = this.columns.iterator();
            while (iter.hasNext()) {
                GridColumn column = iter.next();
                if (column.getParent() == null) {
                    this.topColumns.add(column);
                    column.setPinIndex(contentProvider.getColumnPinIndex(column));
                    if (column.isPinned()) {
                        hasPinnedColumns = true;
                    }
                } else {
                    hasChildColumns = true;
                }
                if (column.getChildren() == null) continue;
                iter.remove();
            }
            if (hasPinnedColumns) {
                Comparator pinnedComparator = (o1, o2) -> o1.isPinned() == o2.isPinned() ? o1.getPinIndex() - o2.getPinIndex() : (o1.isPinned() ? -1 : 1);
                this.columns.sort(pinnedComparator);
                this.topColumns.sort(pinnedComparator);
            }
            if (hasChildColumns || hasPinnedColumns) {
                columnElements = new Object[this.columns.size()];
                int i = 0;
                while (i < this.columns.size()) {
                    columnElements[i] = this.columns.get(i).getElement();
                    ++i;
                }
            }
            this.scrollValuesObsolete = true;
            if (this.getColumnCount() == 1 && (fitValue || this.getGridController().isMaximizeSingleColumn())) {
                GridColumn column = this.getColumn(0);
                int columnWidth = column.computeHeaderWidth();
                int gridWidth = this.getCurrentOrLastClientArea().width - this.getRowHeaderWidth() - this.getHScrollSelectionInPixels() - this.getVerticalBar().getSize().x;
                if (gridWidth > columnWidth) {
                    columnWidth = gridWidth;
                }
                column.setWidth(columnWidth);
            } else {
                int clientWidth;
                int totalWidth = 0;
                for (GridColumn curColumn : this.topColumns) {
                    curColumn.pack(false);
                    totalWidth += curColumn.getWidth();
                }
                if (!fitValue && totalWidth > (clientWidth = this.getCurrentOrLastClientArea().width) && clientWidth != 0) {
                    int normalWidth = 0;
                    ArrayList<GridColumn> fatColumns = new ArrayList<GridColumn>();
                    for (GridColumn curColumn : this.columns) {
                        int curColumnWidthPercent = (int)((double)curColumn.getWidth() / (double)clientWidth * 100.0);
                        if (CommonUtils.isEmpty(curColumn.getChildren()) && curColumnWidthPercent > this.maxColumnDefWidth) {
                            fatColumns.add(curColumn);
                            continue;
                        }
                        normalWidth += curColumn.getWidth();
                    }
                    if (!fatColumns.isEmpty()) {
                        int freeSpace = (clientWidth - normalWidth - this.getBorderWidth() - this.rowHeaderWidth - this.vScroll.getWidth()) / fatColumns.size();
                        int freeSpacePercent = (int)((double)freeSpace / (double)clientWidth * 100.0);
                        int newFatWidth = freeSpacePercent > this.maxColumnDefWidth ? freeSpace : (int)((double)this.maxColumnDefWidth / 100.0 * (double)clientWidth);
                        for (GridColumn curColumn : fatColumns) {
                            curColumn.setWidth(newFatWidth);
                        }
                    }
                }
            }
            if (oldWidths != null && oldWidths.size() == this.columns.size()) {
                for (GridColumn column : this.columns) {
                    Integer newWidth = (Integer)oldWidths.get(column.getElement());
                    if (newWidth == null) continue;
                    column.setWidth(newWidth);
                }
            }
        }
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.recalculateSizes(true);
        this.updateScrollbars();
        if (savedFocus != null) {
            int itemCount = this.getItemCount();
            savedFocus.row = itemCount == 0 ? -1 : Math.min(savedFocus.row, itemCount - 1);
            savedFocus.col = Math.min(savedFocus.col, this.getColumnCount() - 1);
            this.setFocusItem(savedFocus.row);
            if (savedFocus.col >= 0) {
                this.setFocusColumn(savedFocus.col);
            }
            if (savedFocus.isValid()) {
                this.selectCell(savedFocus);
            }
        }
        if (savedHSB >= 0) {
            this.hScroll.setSelection(Math.min(this.hScroll.getMaximum(), savedHSB));
        }
        if (savedVSB >= 0) {
            this.vScroll.setSelection(Math.min(this.vScroll.getMaximum(), savedVSB));
        }
    }

    public void refreshRowsData() {
        Object[] initialElements = this.getContentProvider().getElements(false);
        ArrayList<IGridRow> rows = new ArrayList<IGridRow>(initialElements.length);
        this.collectRowsFromElements(rows, initialElements);
        this.gridRows = rows.toArray(new IGridRow[0]);
    }

    private Rectangle getCurrentOrLastClientArea() {
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0) {
            if (lastClientArea == null) {
                return clientArea;
            }
            return lastClientArea;
        }
        lastClientArea = clientArea;
        return clientArea;
    }

    private void createChildColumns(GridColumn parent) {
        Object[] children = this.getContentProvider().getChildren(parent);
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                GridColumn column = new GridColumn(parent, child);
                this.createChildColumns(column);
                ++n2;
            }
        }
        this.maxColumnDepth = Math.max(this.maxColumnDepth, parent.getLevel());
    }

    @Nullable
    public GridCell posToCell(GridPos pos) {
        if (pos.col < 0 || pos.row < 0) {
            return null;
        }
        if (pos.col >= this.columns.size() || pos.row >= this.gridRows.length) {
            return null;
        }
        return new GridCell(this.columns.get(pos.col), this.gridRows[pos.row]);
    }

    @NotNull
    public GridPos cellToPos(GridCell cell) {
        int colIndex = this.columns.indexOf(cell.col);
        int rowIndex = ArrayUtils.indexOf((Object[])this.gridRows, (Object)cell.row);
        return new GridPos(colIndex, rowIndex);
    }

    public IGridColumn getColumnByElement(Object element) {
        for (IGridColumn iGridColumn : this.columns) {
            if (iGridColumn.getElement() != element) continue;
            return iGridColumn;
        }
        return null;
    }

    public Object getColumnElement(int col) {
        return this.columns.get(col).getElement();
    }

    public int getColumnIndex(int x, int y) {
        Point dragPoint = this.getDisplay().map(null, (Control)this, new Point(x, y));
        GridColumn column = this.getColumn(dragPoint);
        return column == null ? -1 : column.getIndex();
    }

    public Rectangle getColumnBounds(int col) {
        return this.getColumn(col).getBounds();
    }

    public IGridRow getRowByElement(int fromIndex, Object element) {
        int i = fromIndex;
        while (i < this.gridRows.length) {
            if (this.gridRows[i].getElement() == element) {
                return this.gridRows[i];
            }
            ++i;
        }
        return null;
    }

    public IGridRow getRow(int row) {
        return this.gridRows[row];
    }

    public Object getRowElement(int row) {
        return this.gridRows[row].getElement();
    }

    public Color getBackground() {
        if (this.backgroundColor == null) {
            this.backgroundColor = super.getBackground();
        }
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        super.setBackground(this.backgroundColor);
    }

    public Color getForeground() {
        if (this.foregroundColor == null) {
            this.foregroundColor = super.getForeground();
        }
        return this.foregroundColor;
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
        super.setForeground(this.foregroundColor);
        this.getContentProvider().resetColors();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
        this.addListener(14, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point prefSize = null;
        if (wHint == -1 || hHint == -1) {
            prefSize = this.getTableSize();
            prefSize.x += 2 * this.getBorderWidth();
            prefSize.y += 2 * this.getBorderWidth();
        }
        int x = 0;
        int y = 0;
        if (wHint == -1) {
            x += prefSize.x;
            if (this.getVerticalBar() != null) {
                x += this.getVerticalBar().getSize().x;
            }
        } else {
            x = wHint;
        }
        if (hHint == -1) {
            y += prefSize.y;
            if (this.getHorizontalBar() != null) {
                y += this.getHorizontalBar().getSize().y;
            }
        } else {
            y = hHint;
        }
        return new Point(x, y);
    }

    public void deselectAll() {
        this.checkWidget();
        this.selectedCells.clear();
        this.updateSelectionCache();
        this.redraw();
    }

    @NotNull
    public GridColumn getColumn(int index) {
        return this.columns.get(index);
    }

    @Nullable
    private GridColumn getColumn(Point point) {
        int pinnedColumnsWidth;
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
            return null;
        }
        int x2 = 0;
        if (this.rowHeaderVisible) {
            if (point.x <= this.rowHeaderWidth) {
                return null;
            }
            x2 += this.rowHeaderWidth;
        }
        if ((pinnedColumnsWidth = this.getPinnedColumnsWidth()) > 0 && point.x <= pinnedColumnsWidth + this.rowHeaderWidth) {
            return this.getColumnWithOffset(point, x2, true);
        }
        x2 += pinnedColumnsWidth;
        return this.getColumnWithOffset(point, x2 -= this.getHScrollSelectionInPixels(), false);
    }

    @Nullable
    private GridColumn getColumnWithOffset(Point point, int x2, boolean pinned) {
        GridColumn overThis = null;
        for (GridColumn column : this.columns) {
            if (column.isPinned() != pinned) continue;
            if (point.x >= x2 && point.x < x2 + column.getWidth()) {
                GridColumn parent = column.getParent();
                while (parent != null) {
                    Point parentLoc = this.getOrigin(parent, -1);
                    if (point.y >= parentLoc.y && point.y <= parentLoc.y + parent.getHeaderHeight(false, false)) {
                        column = parent;
                        break;
                    }
                    parent = parent.getParent();
                }
                overThis = column;
                break;
            }
            x2 += column.getWidth();
        }
        return overThis;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    Collection<GridColumn> getColumns() {
        return this.columns;
    }

    public IGridScrollBar getHorizontalScrollBarProxy() {
        return this.hScroll;
    }

    public IGridScrollBar getVerticalScrollBarProxy() {
        return this.vScroll;
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    private int getRowHeaderWidth() {
        return this.rowHeaderWidth;
    }

    public int getRow(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
            return -1;
        }
        Rectangle clientArea = this.getClientArea();
        if (point.x < 0 || point.x > clientArea.width) {
            return -1;
        }
        Point p = new Point(point.x, point.y);
        int y2 = 0;
        if (this.columnHeadersVisible) {
            if (p.y <= this.headerHeight) {
                return -1;
            }
            y2 += this.headerHeight;
        }
        int row = this.getTopIndex();
        int currItemHeight = this.getItemHeight();
        int itemCount = this.getItemCount();
        while (row < itemCount && y2 <= clientArea.height) {
            if (p.y >= y2 && p.y < y2 + currItemHeight + 1) {
                return row;
            }
            y2 += currItemHeight + 1;
            ++row;
        }
        return -1;
    }

    public int getItemCount() {
        return this.gridRows.length;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    private void setItemHeight(int height) {
        this.checkWidget();
        if (height < 1) {
            SWT.error((int)5);
        }
        this.itemHeight = height;
        this.setScrollValuesObsolete();
        this.redraw();
    }

    @NotNull
    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(@NotNull Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getLineSelectedColor() {
        return this.lineSelectedColor;
    }

    public void setLineSelectedColor(Color lineSelectedColor) {
        this.lineSelectedColor = lineSelectedColor;
    }

    public boolean isLinesVisible() {
        return this.linesVisible;
    }

    private int getNextVisibleItem(int index) {
        if (index >= this.getItemCount()) {
            return -1;
        }
        if (index == this.getItemCount() - 1) {
            return index;
        }
        return index + 1;
    }

    private int getPreviousVisibleItem(int index) {
        if (index == 0) {
            return -1;
        }
        return index - 1;
    }

    @Nullable
    private GridColumn getPreviousVisibleColumn(GridColumn column) {
        int index = this.indexOf(column);
        if (index <= 0) {
            return null;
        }
        return this.columns.get(index - 1);
    }

    @Nullable
    private GridColumn getNextVisibleColumn(GridColumn column) {
        int index = this.indexOf(column);
        if (index < 0 || index >= this.columns.size() - 1) {
            return null;
        }
        return this.columns.get(index + 1);
    }

    private int getCellSelectionCount() {
        return this.selectedCells.size();
    }

    public int getSelectionIndex() {
        if (this.selectedCells.isEmpty()) {
            return -1;
        }
        return this.selectedCells.iterator().next().row;
    }

    public int getTopIndex() {
        if (this.topIndex != -1) {
            return this.topIndex;
        }
        this.topIndex = !this.vScroll.getVisible() ? 0 : this.vScroll.getSelection();
        return this.topIndex;
    }

    public int getBottomIndex() {
        if (this.bottomIndex != -1) {
            return this.bottomIndex;
        }
        if (this.getItemCount() == 0) {
            this.bottomIndex = 0;
        } else if (this.getVisibleGridHeight() < 1) {
            this.bottomIndex = this.getTopIndex();
        } else {
            int visibleGridHeight = this.getVisibleGridHeight();
            RowRange range = this.getRowRange(this.getTopIndex(), visibleGridHeight, false, false);
            this.bottomIndex = range.endIndex;
            this.bottomIndexShownCompletely = range.height <= visibleGridHeight;
        }
        return this.bottomIndex;
    }

    @Nullable
    private RowRange getRowRange(int startIndex, int endIndex) {
        int itemCount = this.getItemCount();
        if (startIndex == -1 && (startIndex = 0) == itemCount) {
            return null;
        }
        if (endIndex == -1 && (endIndex = itemCount - 1) <= 0) {
            return null;
        }
        if (startIndex < 0 || endIndex < 0 || startIndex >= itemCount || endIndex >= itemCount || endIndex < startIndex) {
            SWT.error((int)5);
        }
        RowRange range = new RowRange();
        range.startIndex = startIndex;
        range.endIndex = endIndex;
        range.rows = range.endIndex - range.startIndex + 1;
        range.height = (this.getItemHeight() + 1) * range.rows - 1;
        return range;
    }

    private RowRange getRowRange(int startIndex, int availableHeight, boolean forceEndCompletelyInside, boolean inverse) {
        int otherIndex;
        if (startIndex == -1) {
            startIndex = !inverse ? 0 : this.getItemCount() - 1;
        }
        RowRange range = new RowRange();
        if (startIndex < 0 || startIndex >= this.getItemCount()) {
            range.startIndex = 0;
            range.endIndex = 0;
            range.height = 0;
            range.rows = 0;
            return range;
        }
        if (availableHeight <= 0) {
            range.startIndex = startIndex;
            range.endIndex = startIndex;
            range.rows = 0;
            range.height = 0;
            return range;
        }
        int availableRows = (availableHeight + 1) / (this.getItemHeight() + 1);
        if ((this.getItemHeight() + 1) * range.rows - 1 + 1 < availableHeight && !forceEndCompletelyInside) {
            ++availableRows;
        }
        if ((otherIndex = startIndex + (availableRows - 1) * (!inverse ? 1 : -1)) < 0) {
            otherIndex = 0;
        }
        if (otherIndex >= this.getItemCount()) {
            otherIndex = this.getItemCount() - 1;
        }
        range.startIndex = !inverse ? startIndex : otherIndex;
        range.endIndex = !inverse ? otherIndex : startIndex;
        range.rows = range.endIndex - range.startIndex + 1;
        range.height = (this.getItemHeight() + 1) * range.rows - 1;
        return range;
    }

    private int getGridHeight() {
        RowRange range = this.getRowRange(-1, -1);
        return range != null ? range.height : 0;
    }

    private int getVisibleGridHeight() {
        Rectangle clientArea = this.getClientArea();
        return this.getVisibleGridHeight(clientArea);
    }

    private int getVisibleGridHeight(Rectangle clientArea) {
        return clientArea.height - (this.columnHeadersVisible ? this.headerHeight : 0);
    }

    int indexOf(GridColumn column) {
        if (column == null) {
            return -1;
        }
        int index = this.columns.indexOf(column = column.getFirstLeaf());
        if (index < 0) {
            log.warn((Object)("Bad column [" + column.getElement() + "]"));
        }
        return index;
    }

    private boolean isRowHeaderVisible() {
        return this.rowHeaderVisible;
    }

    private boolean isCellSelected(GridPos cell) {
        if (cell == null) {
            SWT.error((int)4);
        }
        return this.selectedCells.contains(cell);
    }

    public boolean isHoveringOnHeader() {
        return this.hoveringOnHeader;
    }

    public boolean isHoveringOnRowHeader() {
        return this.hoveringOnRowHeader;
    }

    public void removeAll() {
        this.checkWidget();
        this.deselectAll();
        this.vScroll.setSelection(0);
        this.hScroll.setSelection(0);
        this.focusItem = -1;
        this.focusColumn = null;
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.shiftSelectionAnchorColumn = null;
        this.topColumns.clear();
        this.columns.clear();
        this.expandedRows.clear();
        this.gridRows = new IGridRow[0];
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.selectCells(this.getCells(index));
        this.redraw();
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (this.selectionType == 4 && start != end) {
            return;
        }
        int i = start;
        while (i <= end) {
            if (i >= 0) {
                if (i > this.getItemCount() - 1) break;
                this.selectCells(this.getCells(i));
            }
            ++i;
        }
        this.redraw();
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
            return;
        }
        if (this.selectionType == 4 && indices.length > 1) {
            return;
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            if (j >= 0 && j < this.getItemCount()) {
                this.selectCells(this.getCells(j));
            }
            ++n2;
        }
        this.redraw();
    }

    public void selectAll() {
        this.checkWidget();
        if (this.selectionType == 4) {
            return;
        }
        this.selectAllCells();
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        this.columnHeadersVisible = show;
        this.redraw();
    }

    public void setLinesVisible(boolean linesVisible) {
        this.checkWidget();
        this.linesVisible = linesVisible;
        this.redraw();
    }

    public void setRowHeaderVisible(boolean show) {
        this.checkWidget();
        this.rowHeaderVisible = show;
        this.redraw();
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.getItemCount()) {
            this.selectedCells.clear();
            this.selectCells(this.getCells(index));
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (this.selectionType == 4 && start != end) {
            return;
        }
        this.selectedCells.clear();
        int i = start;
        while (i <= end) {
            if (i >= 0) {
                if (i > this.getItemCount() - 1) break;
                this.selectCells(this.getCells(i));
            }
            ++i;
        }
        this.redraw();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (this.selectionType == 4 && indices.length > 1) {
            return;
        }
        this.selectedCells.clear();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            if (j >= 0) {
                if (j > this.getItemCount() - 1) break;
                this.selectCells(this.getCells(j));
            }
            ++n2;
        }
        this.redraw();
    }

    private void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        if (!this.vScroll.getVisible()) {
            return;
        }
        this.vScroll.setSelection(index);
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.redraw();
    }

    public void showColumn(int column) {
        GridColumn col = this.getColumn(column);
        this.showColumn(col);
    }

    public void showColumn(Object element) {
        for (GridColumn column : this.columns) {
            if (column.getElement() != element) continue;
            this.showColumn(column);
            break;
        }
    }

    private void showColumn(@NotNull GridColumn col) {
        int pinnedColumnsWidth;
        this.checkWidget();
        if (!this.hScroll.getVisible()) {
            return;
        }
        int x = this.getColumnHeaderXPosition(col);
        int firstVisibleX = 0;
        if (this.rowHeaderVisible) {
            firstVisibleX = this.rowHeaderWidth;
        }
        if ((pinnedColumnsWidth = this.getPinnedColumnsWidth()) > 0 && !col.isPinned()) {
            firstVisibleX += pinnedColumnsWidth;
        }
        Rectangle clientArea = this.getClientArea();
        if (x >= firstVisibleX && x + col.getWidth() <= firstVisibleX + (clientArea.width - firstVisibleX)) {
            return;
        }
        if (!this.getColumnScrolling()) {
            if (x < firstVisibleX) {
                this.hScroll.setSelection(this.getHScrollSelectionInPixels() - (firstVisibleX - x));
            } else if (col.getWidth() > clientArea.width - firstVisibleX) {
                this.hScroll.setSelection(this.getHScrollSelectionInPixels() + (x - firstVisibleX));
            } else {
                this.hScroll.setSelection(this.getHScrollSelectionInPixels() + ((x -= clientArea.width - firstVisibleX - col.getWidth()) - firstVisibleX));
            }
        } else if (x < firstVisibleX || col.getWidth() > clientArea.width - firstVisibleX) {
            int sel = this.indexOf(col);
            this.hScroll.setSelection(sel);
        } else {
            int availableWidth = clientArea.width - firstVisibleX - col.getWidth();
            GridColumn prevCol = this.getPreviousVisibleColumn(col);
            GridColumn currentScrollTo = col;
            while (true) {
                if (prevCol == null || prevCol.getWidth() > availableWidth) {
                    int sel = this.indexOf(currentScrollTo);
                    this.hScroll.setSelection(sel);
                    break;
                }
                availableWidth -= prevCol.getWidth();
                currentScrollTo = prevCol;
                prevCol = this.getPreviousVisibleColumn(prevCol);
            }
        }
        this.redraw();
    }

    private boolean isShown(int row) {
        this.checkWidget();
        if (row == -1) {
            SWT.error((int)5);
        }
        int firstVisibleIndex = this.getTopIndex();
        int lastVisibleIndex = this.getBottomIndex();
        return row >= firstVisibleIndex && row < lastVisibleIndex || row == lastVisibleIndex && this.bottomIndexShownCompletely;
    }

    public void showItem(int item) {
        this.showItem(item, -1);
    }

    public void showItem(int item, int topOffset) {
        this.checkWidget();
        this.updateScrollbars();
        if (this.getVisibleGridHeight() < 1) {
            return;
        }
        if (topOffset >= 0) {
            this.setTopIndex(Math.max(0, item - topOffset));
            return;
        }
        if (this.isShown(item)) {
            return;
        }
        int newTopIndex = item;
        if (newTopIndex >= this.getBottomIndex()) {
            RowRange range = this.getRowRange(newTopIndex, this.getVisibleGridHeight(), true, true);
            newTopIndex = range.startIndex;
        }
        if (newTopIndex != this.topIndex) {
            this.setTopIndex(newTopIndex);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.scrollValuesObsolete) {
            this.updateScrollbars();
        }
        if (this.selectedCells.isEmpty()) {
            return;
        }
        GridPos cell = this.selectedCells.iterator().next();
        this.showItem(cell.row);
        this.showColumn(cell.col);
    }

    private void computeHeaderSizes(boolean decreaseSize) {
        int oldRowHeaderWidth = this.rowHeaderWidth;
        this.itemHeight = this.fontMetrics.getHeight() + 3;
        int colHeaderHeight = 0;
        for (GridColumn column : this.topColumns) {
            colHeaderHeight = Math.max(column.getHeaderHeight(true, true), colHeaderHeight);
        }
        this.headerHeight = colHeaderHeight;
        if (this.headerHeight <= 0) {
            this.headerHeight = 6 + this.fontMetrics.getHeight() + 6;
        }
        int newRowHeaderWidth = 30;
        int i = 0;
        while (i < this.gridRows.length) {
            IGridRow row = this.gridRows[i];
            int width = this.rowHeaderRenderer.computeHeaderWidth(row, row.getRowDepth());
            newRowHeaderWidth = Math.max(newRowHeaderWidth, width);
            ++i;
        }
        if (newRowHeaderWidth > 400) {
            newRowHeaderWidth = 400;
        }
        if (newRowHeaderWidth > oldRowHeaderWidth || decreaseSize) {
            this.rowHeaderWidth = newRowHeaderWidth;
        }
    }

    private int getColumnHeaderXPosition(@NotNull GridColumn column) {
        int x = 0;
        x -= this.getHScrollSelectionInPixels();
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        column = column.getFirstLeaf();
        for (GridColumn column2 : this.columns) {
            if (column2 == column) break;
            x += column2.getWidth();
        }
        return x;
    }

    private int getHScrollSelectionInPixels() {
        int selection = this.hScroll.getSelection();
        if (this.columnScrolling) {
            int pixels = 0;
            int i = 0;
            while (i < selection && i < this.columns.size()) {
                pixels += this.columns.get(i).getWidth();
                ++i;
            }
            selection = pixels;
        }
        return selection;
    }

    private Point getTableSize() {
        int x = 0;
        int y = 0;
        if (this.columnHeadersVisible) {
            y += this.headerHeight;
        }
        y += this.getGridHeight();
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        for (GridColumn column : this.columns) {
            x += column.getWidth();
        }
        return new Point(x, y);
    }

    private void handleColumnResizerDragging(int x) {
        int newWidth = this.resizingColumnStartWidth + (x - this.resizingStartX);
        if (newWidth < 32) {
            newWidth = 32;
        }
        Rectangle clientArea = this.getClientArea();
        if (this.columnScrolling) {
            int maxWidth = clientArea.width;
            if (this.rowHeaderVisible) {
                maxWidth -= this.rowHeaderWidth;
            }
            if (newWidth > maxWidth) {
                newWidth = maxWidth;
            }
        }
        if (newWidth == this.columnBeingResized.getWidth()) {
            return;
        }
        this.columnBeingResized.setWidth(newWidth, false);
        this.scrollValuesObsolete = true;
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
    }

    private void handleHoverOnColumnHeader(int x, int y) {
        boolean overSorter = false;
        boolean overResizer = false;
        boolean overFilter = false;
        this.hoveringOnHeader = false;
        boolean overIcon = false;
        if (y <= this.headerHeight) {
            int x2 = 0;
            if (this.rowHeaderVisible) {
                x2 += this.rowHeaderWidth;
            }
            if (x < (x2 -= this.getHScrollSelectionInPixels())) {
                int ltSort = this.getContentProvider().getSortOrder(null);
                if (ltSort != 0 && x > x2 - GridColumnRenderer.SORT_WIDTH - 6 && x < x2 - 6 && y > 6) {
                    this.columnBeingSorted = null;
                    overSorter = true;
                }
            } else if (x > this.getRowHeaderWidth()) {
                for (GridColumn column : this.columns) {
                    if (x >= x2 && x <= x2 + column.getWidth()) {
                        this.hoveringOnHeader = true;
                        if (column.isOverFilterButton(x - x2, y)) {
                            this.columnBeingFiltered = column;
                            overFilter = true;
                            break;
                        }
                        if (column.isOverIcon(x, y)) {
                            overIcon = true;
                            break;
                        }
                        if ((x2 += column.getWidth()) < x - 4 || x2 > x + 4) continue;
                        overResizer = true;
                        this.columnBeingResized = column;
                        break;
                    }
                    x2 += column.getWidth();
                }
            }
        }
        if (overSorter != this.hoveringOnColumnSorter) {
            if (overSorter) {
                this.setCursor(this.sortCursor);
            } else {
                this.columnBeingSorted = null;
                this.setCursor(null);
            }
            this.hoveringOnColumnSorter = overSorter;
        } else if (overIcon != this.hoveringOnColumnIcon) {
            this.setCursor(overIcon ? this.sortCursor : null);
            this.hoveringOnColumnIcon = overIcon;
        }
        if (overFilter) {
            this.setCursor(this.sortCursor);
        }
        if (overFilter != this.hoveringOnColumnFilter) {
            if (!overSorter) {
                this.columnBeingFiltered = null;
                this.setCursor(null);
            }
            this.hoveringOnColumnFilter = overFilter;
        }
        if (overResizer != this.hoveringOnColumnResizer) {
            if (overResizer) {
                this.setCursor(this.getDisplay().getSystemCursor(9));
            } else {
                this.columnBeingResized = null;
                if (!this.hoveringOnColumnSorter) {
                    this.setCursor(null);
                }
            }
            this.hoveringOnColumnResizer = overResizer;
        }
        this.hoveringOnHeaderDragArea = this.hoveringOnHeader && !overSorter && !overResizer && !overFilter;
    }

    private void handleHoverOnRowHeader(int x, int y) {
        this.hoveringRow = null;
        this.draggingRow = null;
        if (!(this.rowHeaderVisible && y <= this.headerHeight || x > this.rowHeaderWidth)) {
            this.hoveringOnRowHeader = true;
            int row = this.getRow(new Point(x, y));
            if (row != -1) {
                this.hoveringRow = row;
            }
        } else {
            this.hoveringOnRowHeader = false;
        }
    }

    @Nullable
    public GridPos getCell(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
            return null;
        }
        if (point.x < 0 || point.x > this.getClientArea().width) {
            return null;
        }
        int item = this.getRow(point);
        GridColumn column = this.getColumn(point);
        if (item >= 0 && column != null) {
            return new GridPos(this.indexOf(column), item);
        }
        return null;
    }

    public int getMaxVisibleRows() {
        int y = 0;
        if (this.columnHeadersVisible) {
            y += this.headerHeight;
        }
        Rectangle clientArea = this.getClientArea();
        int availableHeight = clientArea.height - y;
        int itemHeight = this.getItemHeight();
        return availableHeight / itemHeight + 1;
    }

    private int getPinnedColumnsWidth() {
        int x = 0;
        int k = 0;
        while (k < this.columns.size()) {
            if (!this.columns.get(k).isPinned()) break;
            x += this.columns.get(k).getWidth();
            ++k;
        }
        return x;
    }

    private void onPaint(@NotNull PaintEvent e) {
        int firstVisibleIndex;
        GC gc = e.gc;
        gc.setBackground(this.getBackground());
        if (this.scrollValuesObsolete) {
            this.updateScrollbars();
            this.scrollValuesObsolete = false;
        }
        int y = 0;
        if (this.columnHeadersVisible) {
            this.paintHeader(gc);
            y += this.headerHeight;
        }
        Rectangle clientArea = this.getClientArea();
        int availableHeight = clientArea.height - y;
        int itemHeight = this.getItemHeight();
        int visibleRows = availableHeight / itemHeight + 1;
        if (this.getItemCount() > 0 && availableHeight > 0) {
            RowRange range = this.getRowRange(this.getTopIndex(), availableHeight, false, false);
            visibleRows = range.height >= availableHeight ? range.rows : range.rows + (availableHeight - range.height) / itemHeight + 1;
        }
        int row = firstVisibleIndex = this.getTopIndex();
        int hScrollSelectionInPixels = this.getHScrollSelectionInPixels();
        GridPos testPos = new GridPos(-1, -1);
        Rectangle cellBounds = new Rectangle(0, 0, 0, 0);
        int pinnedColumnsWidth = this.getPinnedColumnsWidth();
        int i = 0;
        while (i < visibleRows) {
            int x = 0;
            x -= hScrollSelectionInPixels;
            if (row >= 0 && row < this.getItemCount()) {
                boolean cellInRowSelected = this.selectedRows.containsKey(row);
                if (this.rowHeaderVisible) {
                    x += this.rowHeaderWidth - 1;
                }
                x += pinnedColumnsWidth;
                int k = 0;
                int columnsSize = this.columns.size();
                while (k < columnsSize) {
                    GridColumn column = this.columns.get(k);
                    if (!column.isPinned()) {
                        int width = column.getWidth();
                        if (x + width >= 0 && x < clientArea.width) {
                            cellBounds.x = x;
                            cellBounds.y = y;
                            cellBounds.width = width;
                            cellBounds.height = itemHeight;
                            testPos.col = k;
                            testPos.row = row;
                            this.cellRenderer.paint(gc, cellBounds, this.selectedCells.contains(testPos), this.focusItem == row && this.focusColumn == column, column, this.gridRows[row]);
                        }
                        x += width;
                    }
                    ++k;
                }
                if (x < clientArea.width) {
                    this.drawEmptyCell(gc, x, y, clientArea.width - x + 1, itemHeight);
                }
                x = 0;
                if (this.rowHeaderVisible) {
                    if (y >= this.headerHeight) {
                        cellBounds.x = 0;
                        cellBounds.y = y;
                        cellBounds.width = this.rowHeaderWidth;
                        cellBounds.height = itemHeight + 1;
                        gc.setClipping(cellBounds);
                        try {
                            IGridRow gridRow = this.gridRows[row];
                            this.rowHeaderRenderer.paint(gc, cellBounds, cellInRowSelected, gridRow.getRowDepth(), this.getRowState(gridRow), gridRow);
                        }
                        finally {
                            gc.setClipping(null);
                        }
                    }
                    x += this.rowHeaderWidth;
                }
                k = 0;
                while (k < this.columns.size()) {
                    GridColumn pc = this.columns.get(k);
                    if (!pc.isPinned()) break;
                    int width = pc.getWidth();
                    cellBounds.x = x;
                    cellBounds.y = y;
                    cellBounds.width = width;
                    cellBounds.height = itemHeight;
                    testPos.col = k;
                    testPos.row = row;
                    ++cellBounds.height;
                    gc.setClipping(cellBounds);
                    --cellBounds.height;
                    try {
                        this.cellRenderer.paint(gc, cellBounds, this.selectedCells.contains(testPos), this.focusItem == row && this.focusColumn == pc, pc, this.gridRows[row]);
                    }
                    finally {
                        gc.setClipping(null);
                    }
                    x += width;
                    ++k;
                }
                y += itemHeight + 1;
            } else {
                if (this.rowHeaderVisible) {
                    x += this.rowHeaderWidth;
                }
                x += pinnedColumnsWidth;
                for (GridColumn column : this.columns) {
                    if (column.isPinned()) continue;
                    this.drawEmptyCell(gc, x, y, column.getWidth(), itemHeight);
                    x += column.getWidth();
                }
                if (x < clientArea.width) {
                    this.drawEmptyCell(gc, x, y, clientArea.width - x + 1, itemHeight);
                }
                x = 0;
                if (this.rowHeaderVisible) {
                    this.drawEmptyRowHeader(gc, x, y, this.rowHeaderWidth, itemHeight + 1);
                    x += this.rowHeaderWidth;
                }
                for (GridColumn column : this.columns) {
                    if (!column.isPinned()) break;
                    this.drawEmptyCell(gc, x, y, column.getWidth(), itemHeight);
                    x += column.getWidth();
                }
                y += itemHeight + 1;
            }
            ++row;
            ++i;
        }
        if (this.isLinesVisible()) {
            gc.setForeground(this.getLineColor());
            int startY = 0;
            int startX = 0;
            int width = clientArea.width;
            int height = clientArea.height;
            if (this.rowHeaderVisible) {
                startX += this.rowHeaderWidth - 1;
                width -= this.rowHeaderWidth;
            }
            if (this.columnHeadersVisible) {
                startY += this.headerHeight - 1;
                height -= this.headerHeight;
            }
            y = startY;
            int i2 = 0;
            while (i2 < visibleRows) {
                gc.drawLine(startX, y += itemHeight + 1, startX + width, y);
                ++i2;
            }
            int leftSpan = this.getPinnedColumnsWidth();
            if (this.rowHeaderVisible) {
                leftSpan += this.rowHeaderWidth;
            }
            int x = startX;
            x -= hScrollSelectionInPixels;
            int k = 0;
            int columnsSize = this.columns.size();
            while (k < columnsSize) {
                if ((x += this.columns.get(k).getWidth()) >= leftSpan) {
                    gc.drawLine(x, startY, x, startY + height);
                }
                ++k;
            }
        }
        if (pinnedColumnsWidth > 0) {
            gc.setForeground(this.getLineSelectedColor());
            gc.drawLine(this.rowHeaderWidth + pinnedColumnsWidth - 1, 0, this.rowHeaderWidth + pinnedColumnsWidth - 1, y);
            gc.drawLine(this.rowHeaderWidth + pinnedColumnsWidth, 0, this.rowHeaderWidth + pinnedColumnsWidth, y);
        }
        if (!this.columns.isEmpty() && this.gridRows.length > 0) {
            int lastRow = row >= this.gridRows.length ? this.gridRows.length - 1 : row;
            this.getContentProvider().validateDataPresence(this.columns.get(this.columns.size() - 1), this.gridRows[lastRow]);
        }
    }

    private void paintHeader(@NotNull GC gc) {
        int x = 0;
        x -= this.getHScrollSelectionInPixels();
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        x += this.getPinnedColumnsWidth();
        Rectangle clientArea = this.getClientArea();
        int i = 0;
        int columnsSize = this.topColumns.size();
        while (i < columnsSize) {
            GridColumn column = this.topColumns.get(i);
            if (!column.isPinned()) {
                if (x > clientArea.width) break;
                this.paintColumnHeader(gc, x, column);
                x += column.getWidth();
            }
            ++i;
        }
        if (x < clientArea.width) {
            this.drawEmptyColumnHeader(gc, x, 0, clientArea.width - x, this.headerHeight);
        }
        x = 0;
        if (this.rowHeaderVisible) {
            this.drawTopLeftCell(gc, 0, 0, this.rowHeaderWidth, this.headerHeight);
            x += this.rowHeaderWidth;
        }
        for (GridColumn column : this.topColumns) {
            if (!column.isPinned()) break;
            this.paintColumnHeader(gc, x, column);
            x += column.getWidth();
        }
    }

    private int paintColumnHeader(@NotNull GC gc, int x, GridColumn column) {
        int columnHeight = column.getHeaderHeight(false, false);
        int y = 0;
        if (x + column.getWidth() >= 0) {
            this.paintColumnsHeader(gc, column, x, y, columnHeight, 0);
        }
        return y;
    }

    private void paintColumnsHeader(GC gc, @NotNull GridColumn column, int x, int y, int columnHeight, int level) {
        List<GridColumn> children = column.getChildren();
        int paintHeight = columnHeight;
        if (CommonUtils.isEmpty(children)) {
            paintHeight = columnHeight + (this.headerHeight - y - columnHeight);
        }
        Rectangle bounds = new Rectangle(x, y, column.getWidth(), paintHeight);
        boolean hover = this.hoveringOnHeader && this.hoveringColumn == column;
        this.columnHeaderRenderer.paint(gc, bounds, this.selectedColumns.contains(column) || this.focusColumn == column, hover, column);
        if (!CommonUtils.isEmpty(children)) {
            ++level;
            int childX = x;
            for (GridColumn child : children) {
                this.paintColumnsHeader(gc, child, childX, y + columnHeight, columnHeight, level);
                childX += child.getWidth();
            }
        }
    }

    public void updateScrollbars() {
        Point preferredSize = this.getTableSize();
        Rectangle clientArea = this.getClientArea();
        int doublePass = 1;
        while (doublePass <= 2) {
            if (preferredSize.y > clientArea.height) {
                this.vScroll.setVisible(true);
            } else {
                this.vScroll.setVisible(false);
                this.vScroll.setValues(0, 0, 1, 1, 1, 1);
            }
            if (preferredSize.x > clientArea.width) {
                this.hScroll.setVisible(true);
            } else {
                this.hScroll.setVisible(false);
                this.hScroll.setValues(0, 0, 1, 1, 1, 1);
            }
            clientArea = this.getClientArea();
            ++doublePass;
        }
        if (this.vScroll.getVisible()) {
            int max = this.getItemCount() + 1;
            int thumb = (this.getVisibleGridHeight(clientArea) + 1) / (this.getItemHeight() + 1);
            int selection = Math.min(this.vScroll.getSelection(), max);
            this.vScroll.setValues(selection, 0, max, thumb, 1, thumb);
        }
        if (this.hScroll.getVisible()) {
            int hiddenArea;
            if (!this.columnScrolling) {
                hiddenArea = preferredSize.x - clientArea.width + 1 + (this.vScroll.getVisible() ? this.vScroll.getWidth() : 0);
                int selection = Math.min(this.hScroll.getSelection(), hiddenArea - 1);
                this.hScroll.setValues(selection, 0, hiddenArea + clientArea.width - 1, clientArea.width, 12, clientArea.width);
            } else {
                hiddenArea = preferredSize.x - clientArea.width + 1;
                int max = 0;
                int i = 0;
                while (hiddenArea > 0 && i < this.getColumnCount()) {
                    GridColumn col = this.columns.get(i);
                    ++i;
                    hiddenArea -= col.getWidth();
                    ++max;
                }
                ++max;
                int visCols = this.columns.size();
                max = Math.min(visCols, max);
                int selection = Math.min(this.hScroll.getSelection(), max);
                this.hScroll.setValues(selection, 0, max, 1, 1, 1);
            }
        }
    }

    @Nullable
    private Event updateCellSelection(@NotNull GridPos newCell, int stateMask, boolean dragging, boolean reverseDuplicateSelections, EventSource eventSource) {
        return this.updateCellSelection(Collections.singletonList(newCell), stateMask, dragging, reverseDuplicateSelections, eventSource);
    }

    @Nullable
    private Event updateCellSelection(@NotNull List<GridPos> newCells, int stateMask, boolean dragging, boolean reverseDuplicateSelections, EventSource eventSource) {
        boolean ctrl;
        if (RuntimeUtils.isMacOS() && (stateMask & 0x40000) == 262144) {
            return null;
        }
        boolean shift = (stateMask & SWT.MOD2) == SWT.MOD2;
        boolean bl = ctrl = (stateMask & SWT.MOD1) == SWT.MOD1;
        if (eventSource == EventSource.KEYBOARD) {
            ctrl = false;
        }
        if (!shift) {
            this.shiftSelectionAnchorColumn = null;
            this.shiftSelectionAnchorItem = -1;
        }
        ArrayList<GridPos> oldSelection = null;
        if (!shift && !ctrl) {
            if (newCells.size() == 1 && newCells.size() == this.selectedCells.size() && newCells.get(0).equals(this.selectedCells.iterator().next())) {
                return null;
            }
            this.selectedCells.clear();
            for (GridPos newCell : newCells) {
                this.addToCellSelection(newCell);
            }
        } else if (shift) {
            GridPos newCell = newCells.get(0);
            oldSelection = new ArrayList<GridPos>(this.selectedCells);
            if (this.focusColumn == null || this.focusItem < 0) {
                return null;
            }
            this.shiftSelectionAnchorColumn = this.getColumn(newCell.col);
            this.shiftSelectionAnchorItem = newCell.row;
            if (ctrl) {
                this.selectedCells.clear();
                this.selectedCells.addAll(this.selectedCellsBeforeRangeSelect);
            } else {
                this.selectedCells.clear();
            }
            GridColumn currentColumn = this.focusColumn;
            int currentItem = this.focusItem;
            GridColumn endColumn = this.getColumn(newCell.col);
            int endItem = newCell.row;
            Point newRange = this.getSelectionRange(currentItem, currentColumn, endItem, endColumn);
            currentColumn = this.getColumn(newRange.x);
            endColumn = this.getColumn(newRange.y);
            GridColumn startCol = currentColumn;
            if (currentItem > endItem) {
                int temp = currentItem;
                currentItem = endItem;
                endItem = temp;
            }
            boolean firstLoop = true;
            do {
                if (!firstLoop) {
                    ++currentItem;
                }
                firstLoop = false;
                boolean firstLoop2 = true;
                currentColumn = startCol;
                do {
                    int index;
                    if (!firstLoop2 && (currentColumn = (index = this.indexOf(currentColumn) + 1) < this.columns.size() ? this.columns.get(index) : null) != null && this.indexOf(currentColumn) > this.indexOf(endColumn)) {
                        currentColumn = null;
                    }
                    firstLoop2 = false;
                    if (currentColumn == null) continue;
                    GridPos cell = new GridPos(this.indexOf(currentColumn), currentItem);
                    this.addToCellSelection(cell);
                } while (currentColumn != endColumn && currentColumn != null);
            } while (currentItem != endItem);
            if (this.selectedCells.equals(newCells)) {
                return null;
            }
        } else {
            boolean alt = (stateMask & SWT.MOD3) == SWT.MOD3;
            boolean reverse = reverseDuplicateSelections;
            if (!this.selectedCells.containsAll(newCells)) {
                reverse = false;
            }
            if (dragging) {
                this.selectedCells.clear();
                this.selectedCells.addAll(this.selectedCellsBeforeRangeSelect);
            }
            if (reverse) {
                if (alt && newCells.size() == 1) {
                    int row = newCells.get((int)0).row;
                    newCells = new ArrayList<GridPos>();
                    for (GridColumn col : this.selectedColumns) {
                        newCells.add(new GridPos(col.getIndex(), row));
                    }
                }
                this.selectedCells.removeAll(newCells);
            } else {
                if (alt && newCells.size() == 1) {
                    int row = newCells.get((int)0).row;
                    newCells = new ArrayList<GridPos>();
                    for (GridColumn col : this.selectedColumns) {
                        newCells.add(new GridPos(col.getIndex(), row));
                    }
                }
                for (GridPos newCell : newCells) {
                    this.addToCellSelection(newCell);
                }
            }
        }
        if (oldSelection != null && oldSelection.size() == this.selectedCells.size() && this.selectedCells.containsAll(oldSelection)) {
            return null;
        }
        this.updateSelectionCache();
        Event e = new Event();
        if (dragging) {
            e.detail = 1;
            this.followupCellSelectionEventOwed = true;
        }
        Rectangle clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
        return e;
    }

    private boolean addToCellSelection(GridPos newCell) {
        if (newCell.col < 0 || newCell.col >= this.columns.size()) {
            return false;
        }
        return this.selectedCells.add(newCell);
    }

    private void updateSelectionCache() {
        this.selectedColumns.clear();
        this.selectedRows.clear();
        IntKeyMap columnIndices = new IntKeyMap();
        for (GridPos cell : this.selectedCells) {
            if (cell.col >= 0) {
                columnIndices.put(cell.col, (Object)Boolean.TRUE);
            }
            if (cell.row < 0) continue;
            this.selectedRows.put(cell.row, (Object)Boolean.TRUE);
        }
        for (Integer columnIndex : columnIndices.keySet()) {
            this.selectedColumns.add(this.columns.get(columnIndex));
        }
        this.selectedColumns.sort(Comparator.comparingInt(GridColumn::getIndex));
    }

    private void initListeners() {
        this.disposeListener = this::onDispose;
        this.addListener(12, this.disposeListener);
        this.addPaintListener(this::onPaint);
        this.addListener(11, e -> this.onResize());
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().addListener(13, e -> this.onScrollSelection());
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().addListener(13, e -> this.onScrollSelection());
        }
        this.addListener(1, this::onKeyDown);
        this.addTraverseListener(e -> {
            boolean bl = e.doit = true;
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                LightGrid.this.onMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                LightGrid.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                LightGrid.this.onMouseUp(e);
            }
        });
        this.addMouseMoveListener(this::onMouseMove);
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                LightGrid.this.onMouseExit(e);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                LightGrid.this.onFocusIn();
                LightGrid.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                LightGrid.this.redraw();
            }
        });
        this.addListener(37, this::onMouseVerticalWheel);
        this.addListener(38, this::onMouseHorizontalWheel);
    }

    private void onFocusIn() {
        this.setDefaultFocusRow();
    }

    public void setDefaultFocusRow() {
        if (this.getItemCount() > 0 && this.focusItem < 0) {
            this.focusItem = 0;
        }
    }

    private void onDispose(Event event) {
        this.removeAll();
        this.removeListener(12, this.disposeListener);
        this.notifyListeners(12, event);
        event.type = 0;
        UIUtils.dispose((Resource)this.boldFont);
        UIUtils.dispose((Resource)this.italicFont);
        UIUtils.dispose((Resource)this.sizingGC);
    }

    private void onMouseVerticalWheel(Event e) {
        if (this.vScroll.getVisible()) {
            this.vScroll.handleMouseWheel(e);
            if (this.getVerticalBar() == null) {
                e.doit = false;
            }
        } else if (this.hScroll.getVisible()) {
            this.hScroll.handleMouseWheel(e);
            if (this.getHorizontalBar() == null) {
                e.doit = false;
            }
        }
    }

    private void onMouseHorizontalWheel(Event e) {
        if (this.hScroll.getVisible() & this.columnScrolling) {
            this.scrollHorizontally(e.count);
            e.doit = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onMouseDown(MouseEvent e) {
        GridPos cell;
        if (!((this.getStyle() & 0x80000) == 524288 || (cell = this.getCell(new Point(e.x, e.y))) != null && cell.equalsTo(this.getFocusPos()))) {
            this.forceFocus();
        }
        Event selectionEvent = null;
        this.cellSelectedOnLastMouseDown = false;
        this.cellRowSelectedOnLastMouseDown = false;
        this.cellColumnSelectedOnLastMouseDown = false;
        if (this.hoveringOnColumnSorter) {
            this.handleHoverOnColumnHeader(e.x, e.y);
            if (this.hoveringOnColumnSorter) {
                return;
            }
        }
        if (this.hoveringOnColumnFilter) {
            this.handleHoverOnColumnHeader(e.x, e.y);
            if (this.hoveringOnColumnFilter) {
                return;
            }
        }
        if (this.hoveringOnColumnResizer) {
            if (e.button != 1) return;
            this.resizingColumn = true;
            this.resizingStartX = e.x;
            this.resizingColumnStartWidth = this.columnBeingResized.getWidth();
            return;
        }
        Point point = new Point(e.x, e.y);
        int row = this.getRow(point);
        if (this.isListening(29)) {
            if (this.hoveringOnHeaderDragArea && this.hoveringColumn != null) {
                if (e.button == 1 && this.dragDetect(e)) {
                    this.headerColumnDragStarted = true;
                    return;
                }
            } else if (this.hoveringOnRowHeader && this.hoveringRow != null && e.button == 1 && this.selectedRows.containsKey((Object)this.hoveringRow) && this.dragDetect(e)) {
                this.rowHeaderDragStarted = true;
                return;
            }
        }
        this.headerColumnDragStarted = false;
        this.rowHeaderDragStarted = false;
        GridColumn col = null;
        if (row >= 0) {
            col = this.getColumn(point);
            if (this.getContentProvider().isVoidCell(col, this.gridRows[row])) {
                return;
            }
            boolean isSelectedCell = false;
            if (col != null) {
                isSelectedCell = this.selectedCells.contains(new GridPos(col.getIndex(), row));
            }
            if (col == null && this.rowHeaderVisible && e.x <= this.rowHeaderWidth) {
                IGridRow gridRow;
                boolean shift = (e.stateMask & SWT.MOD2) != 0;
                boolean ctrl = false;
                if (!shift) {
                    boolean bl = ctrl = (e.stateMask & SWT.MOD1) != 0;
                }
                if (e.button == 1 && !shift && !ctrl && this.getRowState(gridRow = this.gridRows[row]) != IGridContentProvider.ElementState.NONE && GridRowRenderer.isOverExpander(e.x, gridRow.getRowDepth())) {
                    this.toggleRowExpand(this.getRow(row), null);
                    return;
                }
                ArrayList<GridPos> cells = new ArrayList<GridPos>();
                if (e.button == 1) {
                    if (shift) {
                        this.getCells(row, this.focusItem, cells);
                    } else {
                        this.getCells(row, cells);
                    }
                    int newStateMask = 0;
                    if (ctrl) {
                        newStateMask = SWT.MOD1;
                    }
                    selectionEvent = this.updateCellSelection(cells, newStateMask, shift, ctrl, EventSource.MOUSE);
                    boolean bl = this.cellRowSelectedOnLastMouseDown = this.getCellSelectionCount() > 0;
                    if (!shift) {
                        this.focusColumn = this.getColumn(new Point(this.rowHeaderWidth + 1, e.y));
                        this.focusItem = row;
                    }
                } else {
                    this.focusItem = row;
                }
                this.showItem(row);
                this.redraw();
            } else {
                if (e.button != 1 && (e.button != 3 || col == null || isSelectedCell)) return;
                if (col != null) {
                    if (e.stateMask != SWT.MOD2) {
                        this.focusColumn = col;
                        this.focusItem = row;
                    }
                    selectionEvent = this.updateCellSelection(new GridPos(col.getIndex(), row), e.stateMask, false, true, EventSource.MOUSE);
                    selectionEvent = new Event();
                    this.cellSelectedOnLastMouseDown = this.getCellSelectionCount() > 0;
                    this.showItem(row);
                    this.redraw();
                }
            }
        } else if (e.button == 1 && this.rowHeaderVisible && e.x <= this.rowHeaderWidth && e.y < this.headerHeight) {
            if (this.getItemCount() == 0) {
                return;
            }
            selectionEvent = this.selectAllCellsInternal(e.stateMask);
            this.focusColumn = this.getColumn(new Point(this.rowHeaderWidth + 1, 1));
            this.focusItem = this.getTopIndex();
        } else if (this.columnHeadersVisible && e.y <= this.headerHeight) {
            col = this.getColumn(point);
            if (col == null) {
                return;
            }
            if (e.button == 1) {
                ArrayList<GridPos> cells = new ArrayList<GridPos>();
                this.getCells(col, cells);
                selectionEvent = this.updateCellSelection(cells, e.stateMask, false, true, EventSource.MOUSE);
            }
            this.cellColumnSelectedOnLastMouseDown = this.getCellSelectionCount() > 0;
            this.focusColumn = col;
            this.showColumn(col);
            this.redraw();
        } else {
            GridColumn column = this.getColumn(point);
            if (column == null) {
                return;
            }
            if (this.getItemCount() > 0) {
                this.focusColumn = column;
            }
            this.cellColumnSelectedOnLastMouseDown = true;
        }
        if (selectionEvent == null) return;
        selectionEvent.stateMask = e.stateMask;
        selectionEvent.button = e.button;
        selectionEvent.data = new GridCell(col, row < 0 ? null : this.gridRows[row]);
        selectionEvent.x = e.x;
        selectionEvent.y = e.y;
        this.notifyListeners(13, selectionEvent);
    }

    public boolean isCellExpanded(@NotNull IGridCell cell) {
        RowLocation gridPos = new RowLocation(cell.getRow());
        RowExpandState rowState = this.expandedRows.get(gridPos);
        return rowState != null && rowState.isColumnExpanded(cell.getColumn());
    }

    private boolean isRowExpanded(IGridRow gridRow) {
        RowLocation gridPos = new RowLocation(gridRow);
        RowExpandState rowState = this.expandedRows.get(gridPos);
        return rowState != null && rowState.isAllColumnsExpanded();
    }

    @NotNull
    private IGridContentProvider.ElementState getRowState(@NotNull IGridRow row) {
        if (row.getParent() != null) {
            return IGridContentProvider.ElementState.NONE;
        }
        if (this.isRowExpanded(row)) {
            return IGridContentProvider.ElementState.EXPANDED;
        }
        if (this.getContentProvider().isElementExpandable(row)) {
            return IGridContentProvider.ElementState.COLLAPSED;
        }
        return IGridContentProvider.ElementState.NONE;
    }

    public void toggleRowExpand(@NotNull IGridRow gridRow, @Nullable IGridColumn gridColumn) {
        IGridContentProvider provider = this.getContentProvider();
        RowLocation gridPos = new RowLocation(gridRow);
        RowExpandState rowState = this.expandedRows.get(gridPos);
        if (rowState == null) {
            rowState = new RowExpandState();
            for (GridColumn column : this.columns) {
                if (!provider.hasChildren(gridRow) && !provider.hasChildren(column)) continue;
                int size = provider.getCollectionSize(column, gridRow);
                rowState.columns.put(column, new CellExpandState(size));
            }
            this.expandedRows.put(gridPos, rowState);
        }
        if (gridColumn == null) {
            boolean wasExpanded = rowState.isAllColumnsExpanded();
            for (CellExpandState state : rowState.columns.values()) {
                boolean bl = state.expanded = !wasExpanded;
            }
        } else {
            CellExpandState state = rowState.columns.computeIfAbsent(gridColumn, col -> new CellExpandState(provider.getCollectionSize((IGridColumn)col, gridRow)));
            state.expanded = !state.expanded;
        }
        this.refreshRowsData();
        this.recalculateSizes(false);
        this.updateScrollbars();
        this.redraw();
    }

    private void onMouseDoubleClick(MouseEvent e) {
        if (e.button == 1) {
            if (this.hoveringOnColumnResizer) {
                this.columnBeingResized.pack(true);
                this.resizingColumn = false;
                this.scrollValuesObsolete = true;
                this.handleHoverOnColumnHeader(e.x, e.y);
                this.redraw();
                return;
            }
            Point point = new Point(e.x, e.y);
            int row = this.getRow(point);
            GridColumn col = this.getColumn(point);
            if (row >= 0) {
                if (col != null) {
                    if (this.isListening(14)) {
                        Event newEvent = new Event();
                        newEvent.data = new GridCell(col, this.gridRows[row]);
                        this.notifyListeners(14, newEvent);
                    }
                } else {
                    IGridRow gridRow = this.gridRows[row];
                    if (this.getRowState(gridRow) != IGridContentProvider.ElementState.NONE && !GridRowRenderer.isOverExpander(e.x, gridRow.getRowDepth())) {
                        this.toggleRowExpand(gridRow, null);
                    }
                }
            }
        }
    }

    private void onMouseUp(MouseEvent e) {
        if (this.focusColumn != null && this.focusItem >= 0 && e.button == 1 && this.cellRenderer.isOverLink(this.focusColumn, this.focusItem, e.x, e.y)) {
            Event event = new Event();
            event.x = e.x;
            event.y = e.y;
            event.stateMask = e.stateMask;
            event.data = new GridCell(this.focusColumn, this.gridRows[this.focusItem]);
            this.notifyListeners(1001, event);
            return;
        }
        this.cellSelectedOnLastMouseDown = false;
        if (this.hoveringOnColumnSorter) {
            this.handleHoverOnColumnHeader(e.x, e.y);
            if (this.hoveringOnColumnSorter && e.button == 1) {
                Event event = new Event();
                event.x = e.x;
                event.y = e.y;
                event.data = this.columnBeingSorted == null ? null : this.columnBeingSorted.getElement();
                event.stateMask = e.stateMask;
                this.notifyListeners(1000, event);
                return;
            }
        }
        if (this.hoveringOnColumnFilter) {
            this.handleHoverOnColumnHeader(e.x, e.y);
            if (this.hoveringOnColumnFilter && e.button == 1) {
                Event event = new Event();
                event.x = e.x;
                event.y = e.y;
                event.data = this.columnBeingFiltered == null ? null : this.columnBeingFiltered.getElement();
                event.stateMask = e.stateMask;
                this.notifyListeners(1002, event);
                return;
            }
        }
        if (this.resizingColumn) {
            this.resizingColumn = false;
            this.handleHoverOnColumnHeader(e.x, e.y);
            return;
        }
        if (this.cellDragSelectionOccurring || this.cellRowDragSelectionOccurring || this.cellColumnDragSelectionOccurring) {
            this.cellDragSelectionOccurring = false;
            this.cellRowDragSelectionOccurring = false;
            this.cellColumnDragSelectionOccurring = false;
            this.setCursor(null);
            if (this.followupCellSelectionEventOwed) {
                Event se = new Event();
                se.button = e.button;
                Point point = new Point(e.x, e.y);
                GridColumn column = this.getColumn(point);
                int rowIndex = this.getRow(point);
                if (column != null && rowIndex >= 0) {
                    se.data = new GridCell(column, this.gridRows[rowIndex]);
                }
                se.stateMask = e.stateMask;
                se.x = e.x;
                se.y = e.y;
                se.detail = 4;
                this.notifyListeners(13, se);
                this.followupCellSelectionEventOwed = false;
            }
        }
    }

    private void onMouseMove(MouseEvent e) {
        Event selectionEvent = null;
        if ((e.stateMask & 0x80000) == 0) {
            this.handleHovering(e.x, e.y);
        } else {
            int ctrlFlag;
            if (this.resizingColumn) {
                this.handleColumnResizerDragging(e.x);
                return;
            }
            if (!this.cellDragSelectionOccurring && this.cellSelectedOnLastMouseDown) {
                this.cellDragSelectionOccurring = true;
                this.setCursor(this.getDisplay().getSystemCursor(2));
                boolean bl = this.cellDragCTRL = (e.stateMask & SWT.MOD1) != 0;
                if (this.cellDragCTRL) {
                    this.selectedCellsBeforeRangeSelect.clear();
                    this.selectedCellsBeforeRangeSelect.addAll(this.selectedCells);
                }
            }
            if (!this.cellRowDragSelectionOccurring && this.cellRowSelectedOnLastMouseDown) {
                this.cellRowDragSelectionOccurring = true;
                this.setCursor(this.getDisplay().getSystemCursor(2));
                boolean bl = this.cellDragCTRL = (e.stateMask & SWT.MOD1) != 0;
                if (this.cellDragCTRL) {
                    this.selectedCellsBeforeRangeSelect.clear();
                    this.selectedCellsBeforeRangeSelect.addAll(this.selectedCells);
                }
            }
            if (!this.cellColumnDragSelectionOccurring && this.cellColumnSelectedOnLastMouseDown) {
                this.cellColumnDragSelectionOccurring = true;
                this.setCursor(this.getDisplay().getSystemCursor(2));
                boolean bl = this.cellDragCTRL = (e.stateMask & SWT.MOD1) != 0;
                if (this.cellDragCTRL) {
                    this.selectedCellsBeforeRangeSelect.clear();
                    this.selectedCellsBeforeRangeSelect.addAll(this.selectedCells);
                }
            }
            int n = ctrlFlag = this.cellDragCTRL ? SWT.MOD1 : 0;
            if (this.cellDragSelectionOccurring && this.handleCellHover(e.x, e.y)) {
                GridColumn intentColumn = this.hoveringColumn;
                int intentItem = this.hoveringItem;
                if (this.hoveringItem < 0) {
                    intentItem = e.y > this.headerHeight ? Math.min(this.getItemCount() - 1, this.getBottomIndex() + 1) : Math.max(0, this.getTopIndex() - 1);
                }
                if (this.hoveringColumn == null) {
                    intentColumn = e.x > this.rowHeaderWidth ? this.columns.get(this.columns.size() - 1) : this.columns.get(0);
                }
                this.showColumn(intentColumn);
                this.showItem(intentItem);
                GridPos newCell = new GridPos(intentColumn.getIndex(), intentItem);
                selectionEvent = this.updateCellSelection(newCell, ctrlFlag | SWT.MOD2, true, false, EventSource.MOUSE);
            }
            if (this.cellRowDragSelectionOccurring && this.handleCellHover(e.x, e.y)) {
                int intentItem = this.hoveringItem;
                if (this.hoveringItem < 0) {
                    intentItem = e.y > this.headerHeight ? this.getTopIndex() + 1 : (this.getTopIndex() > 0 ? this.getTopIndex() - 1 : 0);
                }
                ArrayList<GridPos> cells = new ArrayList<GridPos>();
                this.getCells(intentItem, this.focusItem, cells);
                this.showItem(intentItem);
                selectionEvent = this.updateCellSelection(cells, ctrlFlag, true, false, EventSource.MOUSE);
            }
            GridColumn prevHoveringColumn = this.hoveringColumn;
            if (this.cellColumnDragSelectionOccurring && this.handleCellHover(e.x, e.y)) {
                boolean dragging;
                ArrayList<GridPos> newSelected = new ArrayList<GridPos>();
                GridColumn iterCol = this.hoveringColumn;
                if (iterCol != null) {
                    boolean decreasing = this.indexOf(iterCol) > this.indexOf(this.focusColumn);
                    dragging = true;
                    while (iterCol != null) {
                        this.getCells(iterCol, newSelected);
                        if (iterCol != this.focusColumn) {
                            iterCol = decreasing ? this.getPreviousVisibleColumn(iterCol) : this.getNextVisibleColumn(iterCol);
                            continue;
                        }
                        break;
                    }
                } else {
                    dragging = false;
                    if (e.x <= this.rowHeaderWidth) {
                        GridColumn prev;
                        GridColumn gridColumn = prev = prevHoveringColumn == null ? null : this.getPreviousVisibleColumn(prevHoveringColumn);
                        if (prev != null) {
                            this.showColumn(prev);
                            this.getCells(prev, newSelected);
                            ctrlFlag = SWT.MOD1;
                        }
                    }
                }
                selectionEvent = this.updateCellSelection(newSelected, ctrlFlag, dragging, false, EventSource.MOUSE);
            }
        }
        if (selectionEvent != null) {
            selectionEvent.stateMask = e.stateMask;
            selectionEvent.button = e.button;
            Point point = new Point(e.x, e.y);
            GridColumn column = this.getColumn(point);
            int rowIndex = this.getRow(point);
            if (column != null && rowIndex >= 0) {
                selectionEvent.data = new GridCell(column, this.gridRows[rowIndex]);
            }
            selectionEvent.x = e.x;
            selectionEvent.y = e.y;
            this.notifyListeners(13, selectionEvent);
        }
    }

    private void handleHovering(int x, int y) {
        this.handleCellHover(x, y);
        if (this.columnHeadersVisible) {
            this.handleHoverOnColumnHeader(x, y);
        }
        if (!this.hoveringOnHeader && this.rowHeaderVisible) {
            this.handleHoverOnRowHeader(x, y);
        }
    }

    private void refreshHoverState() {
        Point p = this.getDisplay().map(null, (Control)this, this.getDisplay().getCursorLocation());
        this.handleHovering(p.x, p.y);
    }

    private void onMouseExit(MouseEvent e) {
        this.hoveringItem = -1;
        this.hoveringDetail = null;
        this.hoveringColumn = null;
    }

    public void scrollHorizontally(int count) {
        Rectangle clientArea = this.getClientArea();
        GridColumn leftColumn = null;
        GridColumn rightColumn = null;
        for (GridColumn column : this.columns) {
            if (column.isPinned()) {
                clientArea.x += column.getWidth();
                continue;
            }
            Rectangle bounds = column.getBounds();
            if (leftColumn == null) {
                if (bounds.x + bounds.width < clientArea.x) continue;
                leftColumn = column;
                continue;
            }
            if (bounds.x + bounds.width < clientArea.width) continue;
            rightColumn = column;
            break;
        }
        GridColumn scrollTo = null;
        if (count > 0) {
            if (leftColumn != null) {
                scrollTo = leftColumn;
            }
        } else if (rightColumn != null) {
            scrollTo = rightColumn;
        }
        if (scrollTo != null) {
            this.showColumn(scrollTo);
        }
    }

    private void onKeyDown(Event e) {
        boolean shiftPressed;
        if (this.focusColumn == null) {
            if (this.columns.size() == 0) {
                return;
            }
            this.focusColumn = this.getColumn(0);
        }
        if (e.character == '\r' && this.focusItem >= 0 && this.focusItem < this.gridRows.length) {
            Event newEvent = new Event();
            newEvent.data = new GridCell(this.focusColumn, this.gridRows[this.focusItem]);
            this.notifyListeners(14, newEvent);
            return;
        }
        int newSelection = -1;
        GridColumn newColumnFocus = null;
        int impliedFocusItem = this.focusItem;
        GridColumn impliedFocusColumn = this.focusColumn;
        boolean ctrlPressed = (e.stateMask & SWT.MOD1) != 0;
        boolean bl = shiftPressed = (e.stateMask & SWT.MOD2) != 0;
        if (this.shiftSelectionAnchorColumn != null) {
            impliedFocusItem = this.shiftSelectionAnchorItem;
            impliedFocusColumn = this.shiftSelectionAnchorColumn;
        }
        switch (e.keyCode) {
            case 0x1000004: {
                if (impliedFocusItem < 0) break;
                newSelection = impliedFocusItem;
                int index = this.indexOf(impliedFocusColumn) + 1;
                if (index < this.columns.size()) {
                    newColumnFocus = this.columns.get(index);
                    break;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000003: {
                if (impliedFocusItem < 0) break;
                newSelection = impliedFocusItem;
                int index = this.indexOf(impliedFocusColumn);
                if (index > 0) {
                    newColumnFocus = this.columns.get(index - 1);
                    break;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000001: {
                if (impliedFocusItem >= 0) {
                    newSelection = this.getPreviousVisibleItem(impliedFocusItem);
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000002: {
                if (impliedFocusItem >= 0) {
                    newSelection = this.getNextVisibleItem(impliedFocusItem);
                } else if (this.getItemCount() > 0) {
                    newSelection = 0;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000007: {
                newSelection = ctrlPressed || this.columns.size() == 1 ? 0 : impliedFocusItem;
                newColumnFocus = this.columns.get(0);
                break;
            }
            case 0x1000008: {
                newSelection = (ctrlPressed || this.columns.size() == 1) && this.getItemCount() > 0 ? this.getItemCount() - 1 : impliedFocusItem;
                newColumnFocus = this.columns.get(this.columns.size() - 1);
                break;
            }
            case 0x1000005: {
                int topIndex;
                newSelection = topIndex = this.getTopIndex();
                if (impliedFocusItem >= 0 && impliedFocusItem == topIndex || this.focusItem == topIndex) {
                    RowRange range = this.getRowRange(this.getTopIndex(), this.getVisibleGridHeight(), false, true);
                    newSelection = range.startIndex;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000006: {
                int tmpItem;
                int bottomIndex;
                newSelection = bottomIndex = this.getBottomIndex();
                if (!this.isShown(bottomIndex) && (tmpItem = this.getPreviousVisibleItem(newSelection)) >= 0) {
                    newSelection = tmpItem;
                }
                if (impliedFocusItem >= 0 && impliedFocusItem >= bottomIndex - 1 || this.focusItem == bottomIndex - 1) {
                    RowRange range = this.getRowRange(this.getBottomIndex(), this.getVisibleGridHeight(), true, false);
                    newSelection = range.endIndex;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 43: 
            case 45: 
            case 61: 
            case 16777259: 
            case 16777261: {
                if (this.focusItem < 0) break;
                IGridRow gridRow = this.gridRows[this.focusItem];
                if (!this.getContentProvider().hasChildren(gridRow)) break;
                boolean isPlus = e.keyCode == 43 || e.keyCode == 61 || e.keyCode == 16777259;
                boolean isExpanded = this.isCellExpanded(new GridCell(this.focusColumn, gridRow));
                if (isExpanded != isPlus) break;
                this.toggleRowExpand(this.gridRows[this.focusItem], this.focusColumn);
                break;
            }
            case 32: {
                this.toggleCellValue(this.focusColumn, this.gridRows[this.focusItem]);
            }
        }
        if (newSelection < 0) {
            return;
        }
        if (newColumnFocus != null) {
            Event selEvent = this.updateCellSelection(new GridPos(newColumnFocus.getIndex(), newSelection), e.stateMask, false, false, EventSource.KEYBOARD);
            if (!shiftPressed) {
                this.focusColumn = newColumnFocus;
            }
            this.showColumn(newColumnFocus);
            if (!shiftPressed) {
                this.focusItem = newSelection < 0 ? -1 : newSelection;
            }
            this.showItem(newSelection);
            GridCell newPos = newSelection >= 0 && newSelection < this.gridRows.length ? new GridCell(newColumnFocus, this.gridRows[newSelection]) : null;
            if (selEvent != null) {
                selEvent.stateMask = e.stateMask;
                selEvent.character = e.character;
                selEvent.keyCode = e.keyCode;
                selEvent.data = newPos;
                this.notifyListeners(13, selEvent);
            }
        }
    }

    protected void toggleCellValue(IGridColumn column, IGridRow row) {
    }

    private void onResize() {
        this.scrollValuesObsolete = true;
        this.topIndex = -1;
        this.bottomIndex = -1;
    }

    private void onScrollSelection() {
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.refreshHoverState();
        Rectangle clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
    }

    Point getOrigin(GridColumn column, int item) {
        int y;
        int x;
        block9: {
            block8: {
                x = 0;
                if (this.rowHeaderVisible) {
                    x += this.rowHeaderWidth;
                }
                if (!column.isPinned()) {
                    x -= this.getHScrollSelectionInPixels();
                }
                int i = 0;
                while (i < this.columns.size()) {
                    GridColumn colIter = this.columns.get(i);
                    if (colIter == column) break;
                    x += colIter.getWidth();
                    ++i;
                }
                y = 0;
                if (item < 0) break block8;
                if (this.columnHeadersVisible) {
                    y += this.headerHeight;
                }
                int currIndex = this.getTopIndex();
                if (item == -1) {
                    SWT.error((int)5);
                }
                while (currIndex != item) {
                    if (currIndex < item) {
                        y += this.getItemHeight() + 1;
                        ++currIndex;
                        continue;
                    }
                    if (currIndex <= item) continue;
                    --currIndex;
                    y -= this.getItemHeight() + 1;
                }
                break block9;
            }
            if (!this.columnHeadersVisible || column.getParent() == null) break block9;
            GridColumn parent = column.getParent();
            while (parent != null) {
                y += parent.getHeaderHeight(false, false);
                parent = parent.getParent();
            }
        }
        return new Point(x, y);
    }

    private boolean handleCellHover(int x, int y) {
        Point point = new Point(x, y);
        GridColumn col = this.getColumn(point);
        int row = this.getRow(point);
        Integer detail = (this.hoveringOnColumnSorter ? 1000000 : 0) + (this.hoveringOnColumnFilter ? 1000000 : 0) + y;
        boolean hoverChange = false;
        if (this.hoveringItem != row || !CommonUtils.equalObjects((Object)this.hoveringDetail, (Object)detail) || this.hoveringColumn != col || y <= this.headerHeight) {
            this.hoveringItem = row;
            this.hoveringDetail = detail;
            this.hoveringColumn = col;
            hoverChange = true;
        }
        boolean overLink = false;
        if (col != null && row >= 0 && this.cellRenderer.isOverLink(col, row, x, y)) {
            overLink = true;
        }
        if (overLink) {
            if (!this.hoveringOnLink) {
                this.setCursor(this.sortCursor);
            }
        } else if (this.hoveringOnLink) {
            this.setCursor(null);
        }
        this.hoveringOnLink = overLink;
        if (hoverChange) {
            String newTip = null;
            if (this.hoveringItem >= 0 && this.hoveringColumn != null) {
                if (overLink) {
                    newTip = this.getContentProvider().getCellLinkText(col, this.gridRows[row]);
                }
                if (CommonUtils.isEmpty(newTip)) {
                    newTip = this.getCellToolTip(this.hoveringColumn, this.hoveringItem);
                }
            } else if (this.columnHeadersVisible && this.hoveringColumn != null && y <= this.headerHeight) {
                newTip = this.hoveringOnColumnFilter ? DataEditorsMessages.pref_page_database_resultsets_label_show_attr_filters : this.hoveringColumn.getHeaderTooltip();
            } else if (this.rowHeaderVisible && this.hoveringItem >= 0 && x <= this.rowHeaderWidth) {
                newTip = this.getLabelProvider().getToolTipText(this.getRow(this.hoveringItem));
            }
            if (newTip != null && !newTip.equals(this.displayedToolTipText)) {
                this.toolTipHandler.updateToolTipText(newTip);
            } else if (newTip == null && this.displayedToolTipText != null) {
                this.toolTipHandler.updateToolTipText(null);
            }
            this.displayedToolTipText = newTip;
        }
        return hoverChange;
    }

    protected void setScrollValuesObsolete() {
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    void newColumn(GridColumn column, int index) {
        if (index == -1) {
            this.columns.add(column);
        } else {
            this.columns.add(index, column);
        }
    }

    public void recalculateSizes(boolean decreaseSize) {
        int oldHeaderHeight = this.headerHeight;
        this.computeHeaderSizes(decreaseSize);
        if (oldHeaderHeight != this.headerHeight) {
            this.scrollValuesObsolete = true;
        }
    }

    public GridPos getFocusPos() {
        this.checkWidget();
        int x = -1;
        if (this.focusColumn != null) {
            x = this.focusColumn.getIndex();
        }
        this.focusCell.col = x;
        this.focusCell.row = this.focusItem;
        return this.focusCell;
    }

    @Nullable
    public Object getFocusColumnElement() {
        return this.focusColumn == null ? null : this.focusColumn.getElement();
    }

    @Nullable
    public Object getFocusRowElement() {
        if (this.focusItem < 0 || this.focusItem >= this.gridRows.length) {
            return null;
        }
        return this.gridRows[this.focusItem].getElement();
    }

    @Nullable
    public IGridRow getFocusRow() {
        if (this.focusItem < 0 || this.focusItem >= this.gridRows.length) {
            return null;
        }
        return this.gridRows[this.focusItem];
    }

    @Nullable
    public GridCell getFocusCell() {
        return this.posToCell(this.getFocusPos());
    }

    public void setFocusItem(int item) {
        this.checkWidget();
        this.focusItem = item;
    }

    public void setFocusColumn(int col) {
        this.checkWidget();
        GridColumn column = this.getColumn(col);
        if (column == null || column.getGrid() != this) {
            SWT.error((int)5);
            return;
        }
        this.focusColumn = column;
    }

    public void resetFocus() {
        this.focusColumn = null;
        this.focusItem = -1;
    }

    private boolean getColumnScrolling() {
        this.checkWidget();
        return this.columnScrolling;
    }

    public void setColumnScrolling(boolean columnScrolling) {
        this.checkWidget();
        this.columnScrolling = columnScrolling;
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    public void selectCell(@NotNull GridPos cell) {
        this.checkWidget();
        this.addToCellSelection(cell);
        this.updateSelectionCache();
        this.redraw();
    }

    public void selectCells(@NotNull Collection<GridPos> cells) {
        this.checkWidget();
        for (GridPos cell : cells) {
            this.addToCellSelection(cell);
        }
        this.updateSelectionCache();
        this.redraw();
    }

    public void selectAllCells() {
        this.checkWidget();
        this.selectAllCellsInternal(0);
    }

    @Nullable
    private Event selectAllCellsInternal(int stateMask) {
        if (this.columns.size() == 0) {
            return null;
        }
        if (this.getItemCount() == 0) {
            return null;
        }
        GridColumn oldFocusColumn = this.focusColumn;
        int oldFocusItem = this.focusItem;
        this.focusColumn = this.columns.get(0);
        this.focusItem = 0;
        List<GridPos> cells = this.getAllCells();
        Event selectionEvent = this.updateCellSelection(cells, stateMask, false, true, EventSource.KEYBOARD);
        this.focusColumn = oldFocusColumn;
        this.focusItem = oldFocusItem;
        this.updateSelectionCache();
        this.redraw();
        return selectionEvent;
    }

    public void setCellSelection(@NotNull GridPos cell) {
        this.checkWidget();
        if (!this.isValidCell(cell)) {
            SWT.error((int)5);
        }
        this.selectedCells.clear();
        this.addToCellSelection(cell);
        this.updateSelectionCache();
        this.redraw();
    }

    @NotNull
    public Collection<GridPos> getSelection() {
        if (this.isDisposed()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.selectedCells);
    }

    public List<GridCell> getCellSelection() {
        if (this.isDisposed() || this.selectedCells.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GridCell> cells = new ArrayList<GridCell>(this.selectedCells.size());
        for (GridPos pos : this.selectedCells) {
            GridCell cell = this.posToCell(pos);
            if (cell == null) continue;
            cells.add(cell);
        }
        return cells;
    }

    public int getCellSelectionSize() {
        return this.selectedCells.size();
    }

    @NotNull
    public List<IGridColumn> getColumnSelection() {
        if (this.selectedColumns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IGridColumn> selection = new ArrayList<IGridColumn>();
        for (GridColumn col : this.selectedColumns) {
            selection.add(col);
        }
        return selection;
    }

    public int getColumnSelectionSize() {
        return this.selectedColumns.size();
    }

    public boolean isRowSelected(int row) {
        return this.selectedRows.containsKey(row);
    }

    public Collection<Integer> getRowSelection() {
        return Collections.unmodifiableCollection(this.selectedRows.keySet());
    }

    public int getRowSelectionSize() {
        return this.selectedRows.size();
    }

    private void getCells(GridColumn col, List<GridPos> cells) {
        if (col.getChildren() != null) {
            int i = 0;
            while (i < this.columns.size()) {
                if (this.columns.get(i).isParent(col)) {
                    int k = 0;
                    while (k < this.getItemCount()) {
                        cells.add(new GridPos(i, k));
                        ++k;
                    }
                }
                ++i;
            }
        } else {
            int colIndex = col.getIndex();
            int i = 0;
            while (i < this.getItemCount()) {
                cells.add(new GridPos(colIndex, i));
                ++i;
            }
        }
    }

    private void getCells(int row, List<GridPos> cells) {
        int i = 0;
        while (i < this.columns.size()) {
            cells.add(new GridPos(i, row));
            ++i;
        }
    }

    private List<GridPos> getAllCells() {
        int itemCount = this.getItemCount();
        int columnCount = this.columns.size();
        ArrayList<GridPos> cells = new ArrayList<GridPos>(itemCount * columnCount);
        int i = 0;
        while (i < itemCount) {
            int k = 0;
            while (k < columnCount) {
                cells.add(new GridPos(k, i));
                ++k;
            }
            ++i;
        }
        return cells;
    }

    private List<GridPos> getCells(int row) {
        ArrayList<GridPos> cells = new ArrayList<GridPos>();
        this.getCells(row, cells);
        return cells;
    }

    private void getCells(int startRow, int endRow, List<GridPos> cells) {
        boolean descending = startRow < endRow;
        int iterItem = endRow;
        while (true) {
            this.getCells(iterItem, cells);
            if (iterItem == startRow) break;
            if (descending) {
                --iterItem;
                continue;
            }
            ++iterItem;
        }
    }

    private Point getSelectionRange(int fromItem, GridColumn fromColumn, int toItem, GridColumn toColumn) {
        if (this.indexOf(fromColumn) > this.indexOf(toColumn)) {
            GridColumn temp = fromColumn;
            fromColumn = toColumn;
            toColumn = temp;
        }
        if (fromItem > toItem) {
            int temp = fromItem;
            fromItem = toItem;
            toItem = temp;
        }
        boolean firstTime = true;
        int iterItem = fromItem;
        int fromIndex = fromColumn.getIndex();
        int toIndex = toColumn.getIndex();
        do {
            if (!firstTime) {
                ++iterItem;
            } else {
                firstTime = false;
            }
            Point cols = this.getRowSelectionRange(fromColumn, toColumn);
            if (cols.x == fromIndex && cols.y == toIndex) continue;
            GridColumn newFrom = this.getColumn(cols.x);
            GridColumn newTo = this.getColumn(cols.y);
            return this.getSelectionRange(fromItem, newFrom, toItem, newTo);
        } while (iterItem != toItem);
        return new Point(fromColumn.getIndex(), toColumn.getIndex());
    }

    private Point getRowSelectionRange(GridColumn fromColumn, GridColumn toColumn) {
        int newFrom = fromColumn.getIndex();
        int newTo = toColumn.getIndex();
        return new Point(newFrom, newTo);
    }

    private boolean isValidCell(GridPos cell) {
        if (cell.col < 0 || cell.col >= this.columns.size()) {
            return false;
        }
        return cell.row >= 0 && cell.row < this.getItemCount();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.sizingGC.setFont(font);
        this.fontMetrics = this.sizingGC.getFontMetrics();
        this.normalFont = font;
        UIUtils.dispose((Resource)this.boldFont);
        UIUtils.dispose((Resource)this.italicFont);
        this.boldFont = UIUtils.makeBoldFont((Font)this.normalFont);
        this.italicFont = UIUtils.modifyFont((Font)this.normalFont, (int)2);
    }

    @NotNull
    public Font getFont(@NotNull UIElementFontStyle style) {
        switch (style) {
            case ITALIC: {
                return this.italicFont;
            }
            case BOLD: {
                return this.boldFont;
            }
        }
        return this.normalFont;
    }

    public String getCellText(IGridColumn colElement, IGridRow rowElement) {
        Object text = this.getContentProvider().getCellValue(colElement, rowElement, true);
        return this.getCellText(text);
    }

    @NotNull
    String getCellText(Object cellValue) {
        String text = String.valueOf(cellValue);
        if (text.length() > 1000) {
            text = String.valueOf(text.substring(0, 1000)) + " ...";
        }
        return text;
    }

    @Nullable
    private String getCellToolTip(GridColumn col, int row) {
        if (col == null || row < 0 || row >= this.gridRows.length) {
            return null;
        }
        String toolTip = this.getCellText(col, this.gridRows[row]);
        if (toolTip == null) {
            return null;
        }
        Point ttSize = this.sizingGC.textExtent(toolTip);
        if (ttSize.x > col.getWidth() || ttSize.y > this.getItemHeight()) {
            int gridHeight = this.getBounds().height;
            if (ttSize.y > gridHeight) {
                StringBuilder newToolTip = new StringBuilder();
                StringTokenizer st = new StringTokenizer(toolTip, "'\n");
                int maxLineNumbers = gridHeight / this.getItemHeight();
                int lineNumber = 0;
                while (st.hasMoreTokens()) {
                    newToolTip.append(st.nextToken()).append('\n');
                    if (++lineNumber >= maxLineNumbers) break;
                }
                toolTip = newToolTip.toString();
            }
            return toolTip;
        }
        return "";
    }

    public Rectangle getCellBounds(int columnIndex, int rowIndex) {
        if (!this.isShown(rowIndex)) {
            return new Rectangle(-1000, -1000, 0, 0);
        }
        GridColumn column = this.getColumn(columnIndex);
        Point origin = this.getOrigin(column, rowIndex);
        if (origin.x < 0 && this.isRowHeaderVisible()) {
            return new Rectangle(-1000, -1000, 0, 0);
        }
        return new Rectangle(origin.x, origin.y, column.getWidth(), this.getItemHeight());
    }

    void setDefaultBackground(GC gc) {
        Color background = this.getLabelProvider().getBackground(null);
        if (background != null) {
            gc.setBackground(background);
        }
    }

    private void drawEmptyColumnHeader(GC gc, int x, int y, int width, int height) {
        gc.setBackground(this.getLabelProvider().getHeaderBackground(null, false));
        gc.fillRectangle(x, y, width + 1, height + 1);
    }

    private void drawEmptyRowHeader(GC gc, int x, int y, int width, int height) {
        gc.setBackground(this.getLabelProvider().getHeaderBackground(null, false));
        gc.fillRectangle(x, y, width, height + 1);
        gc.setForeground(this.getLabelProvider().getHeaderBorder(null));
        gc.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        gc.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
    }

    private void drawEmptyCell(GC gc, int x, int y, int width, int height) {
        IGridLabelProvider labelProvider = this.getLabelProvider();
        Color foreground = labelProvider.getForeground(null);
        this.setDefaultBackground(gc);
        gc.setForeground(foreground);
        gc.fillRectangle(x, y, width + 1, height);
    }

    private void drawTopLeftCell(GC gc, int x, int y, int width, int height) {
        int sortOrder = this.getContentProvider().getSortOrder(null);
        gc.setBackground(this.getLabelProvider().getHeaderBackground(null, false));
        gc.fillRectangle(x, y, width - 1, height + 1);
        gc.setForeground(this.getLabelProvider().getHeaderBorder(null));
        gc.drawLine(x + width - 1, y, x + width - 1, y + height);
        gc.drawLine(x, y + height - 1, x + width, y + height - 1);
        if (this.getContentProvider().isGridReadOnly()) {
            Image roIcon = DBeaverIcons.getImage((DBPImage)UIIcon.BUTTON_READ_ONLY);
            gc.drawImage(roIcon, x + 3, y + 3);
        }
        if (sortOrder != 0) {
            int arrowWidth = GridColumnRenderer.SORT_WIDTH;
            Rectangle sortBounds = new Rectangle(x + width - 6 - arrowWidth, y + 6, arrowWidth, height);
            GridColumnRenderer.paintSort(gc, sortBounds, sortOrder, true);
        }
    }

    private void addDragAndDropSupport() {
        DragSource source = new DragSource((Control)this, 3);
        source.setTransfer(new Transfer[]{GridColumnTransfer.INSTANCE, TextTransfer.getInstance()});
        source.addDragListener(new DragSourceListener(){
            private Image dragImage;
            private long lastDragEndTime;

            public void dragStart(DragSourceEvent event) {
                if (this.lastDragEndTime > 0L && System.currentTimeMillis() - this.lastDragEndTime < 100L) {
                    event.doit = false;
                } else {
                    Rectangle columnBounds;
                    if (LightGrid.this.headerColumnDragStarted && LightGrid.this.hoveringColumn != null) {
                        LightGrid.this.draggingColumn = LightGrid.this.hoveringColumn;
                        columnBounds = LightGrid.this.hoveringColumn.getBounds();
                    } else if (LightGrid.this.rowHeaderDragStarted && LightGrid.this.hoveringRow != null) {
                        LightGrid.this.draggingRow = LightGrid.this.hoveringRow;
                        int rowFromTop = LightGrid.this.hoveringRow - LightGrid.this.getTopIndex();
                        columnBounds = new Rectangle(0, rowFromTop * LightGrid.this.getItemHeight(), LightGrid.this.getRowHeaderWidth(), LightGrid.this.getItemHeight());
                    } else {
                        event.doit = false;
                        return;
                    }
                    if (this.dragImage != null) {
                        this.dragImage.dispose();
                        this.dragImage = null;
                    }
                    GC gc = new GC((Drawable)LightGrid.this);
                    this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                    gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                    event.image = this.dragImage;
                    gc.dispose();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (LightGrid.this.draggingColumn != null) {
                    if (GridColumnTransfer.INSTANCE.isSupportedType(event.dataType)) {
                        ArrayList<Object> elements = new ArrayList<Object>();
                        if (LightGrid.this.isDragSingleColumn()) {
                            elements.add(LightGrid.this.draggingColumn.getElement());
                        } else {
                            for (GridColumn col : LightGrid.this.selectedColumns) {
                                elements.add(col.getElement());
                            }
                        }
                        event.data = elements;
                    } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                        if (LightGrid.this.selectedColumns.size() > 1 && !LightGrid.this.isDragSingleColumn()) {
                            StringBuilder text = new StringBuilder();
                            for (GridColumn column : LightGrid.this.selectedColumns) {
                                if (text.length() > 0) {
                                    text.append(", ");
                                }
                                text.append(LightGrid.this.getLabelProvider().getText(column));
                            }
                            event.data = text.toString();
                        } else {
                            event.data = LightGrid.this.getLabelProvider().getText(LightGrid.this.draggingColumn);
                        }
                    }
                } else if (LightGrid.this.draggingRow != null) {
                    if (GridColumnTransfer.INSTANCE.isSupportedType(event.dataType)) {
                        ArrayList<Object> elements = new ArrayList<Object>();
                        if (LightGrid.this.isDragSingleRow()) {
                            elements.add(LightGrid.this.getRowElement(LightGrid.this.draggingRow));
                        } else {
                            for (Integer row : LightGrid.this.selectedRows.keySet()) {
                                elements.add(LightGrid.this.getRowElement(row));
                            }
                        }
                        event.data = elements;
                    } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                        Set<Integer> rows;
                        List<GridColumn> columns = LightGrid.this.selectedColumns;
                        if (columns.isEmpty()) {
                            columns = LightGrid.this.columns;
                        }
                        if ((rows = LightGrid.this.selectedRows.keySet()).isEmpty()) {
                            rows = Collections.singleton(LightGrid.this.draggingRow);
                        }
                        StringBuilder text = new StringBuilder();
                        for (Integer row : rows) {
                            if (text.length() > 0) {
                                text.append("\n");
                            }
                            int i = 0;
                            while (i < columns.size()) {
                                GridColumn column = columns.get(i);
                                Object cellText = LightGrid.this.getContentProvider().getCellValue(column, LightGrid.this.getRow(row), true);
                                if (i > 0) {
                                    text.append(", ");
                                }
                                text.append(cellText);
                                ++i;
                            }
                        }
                        event.data = text.toString();
                    }
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LightGrid.this.draggingColumn = null;
                LightGrid.this.draggingRow = null;
                if (this.dragImage != null) {
                    UIUtils.dispose((Resource)this.dragImage);
                    this.dragImage = null;
                }
                this.lastDragEndTime = System.currentTimeMillis();
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this, 3);
        dropTarget.setTransfer(new Transfer[]{GridColumnTransfer.INSTANCE, TextTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    this.moveColumns(event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = !this.isDropSupported(event) ? 0 : 2;
                event.feedback = 1;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                if (!LightGrid.this.hoveringOnHeaderDragArea) {
                    return false;
                }
                if (LightGrid.this.draggingColumn == null || LightGrid.this.draggingColumn.getGrid() != LightGrid.this) {
                    return false;
                }
                GridColumn overColumn = this.getOverColumn(event);
                return overColumn != null && LightGrid.this.draggingColumn != overColumn && LightGrid.this.draggingColumn.isPinned() == overColumn.isPinned();
            }

            private GridColumn getOverColumn(DropTargetEvent event) {
                Point dragPoint = LightGrid.this.getDisplay().map(null, (Control)LightGrid.this, new Point(event.x, event.y));
                return LightGrid.this.getColumn(dragPoint);
            }

            private void moveColumns(DropTargetEvent event) {
                GridColumn overColumn = this.getOverColumn(event);
                if (overColumn == null || LightGrid.this.draggingColumn == null || LightGrid.this.draggingColumn == overColumn) {
                    return;
                }
                IGridController gridController = LightGrid.this.getGridController();
                if (gridController != null) {
                    Point dropPoint = LightGrid.this.getDisplay().map(null, (Control)LightGrid.this, new Point(event.x, event.y));
                    Rectangle columnBounds = overColumn.getBounds();
                    IGridController.DropLocation location = dropPoint.x > columnBounds.x + columnBounds.width / 2 ? IGridController.DropLocation.DROP_AFTER : IGridController.DropLocation.DROP_BEFORE;
                    gridController.moveColumn(LightGrid.this.draggingColumn.getElement(), overColumn.getElement(), location);
                }
                LightGrid.this.draggingColumn = null;
            }
        });
    }

    private boolean isDragSingleColumn() {
        return this.draggingColumn != null && !this.selectedColumns.contains(this.draggingColumn);
    }

    private boolean isDragSingleRow() {
        return this.draggingRow != null && !this.selectedRows.containsKey((Object)this.draggingRow);
    }

    static class CellExpandState {
        final int size;
        boolean expanded;

        public CellExpandState(int size) {
            this.size = size;
        }
    }

    public static enum EventSource {
        MOUSE,
        KEYBOARD;

    }

    public static final class GridColumnTransfer
    extends LocalObjectTransfer<List<Object>> {
        public static final GridColumnTransfer INSTANCE = new GridColumnTransfer();
        private static final String TYPE_NAME = "LighGrid.GridColumn Transfer" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
        private static final int TYPEID = GridColumnTransfer.registerType((String)TYPE_NAME);

        private GridColumnTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }
    }

    static class RowExpandState {
        private final Map<IGridColumn, CellExpandState> columns = new HashMap<IGridColumn, CellExpandState>();

        RowExpandState() {
        }

        public int getMaxLength() {
            int size = 0;
            for (CellExpandState state : this.columns.values()) {
                if (!state.expanded) continue;
                size = Math.max(size, state.size);
            }
            return size;
        }

        public boolean isColumnExpanded(@NotNull IGridColumn column) {
            CellExpandState state = this.columns.get(column);
            return state != null && state.expanded;
        }

        public boolean isAnyColumnExpanded() {
            for (CellExpandState state : this.columns.values()) {
                if (!state.expanded) continue;
                return true;
            }
            return false;
        }

        public boolean isAllColumnsExpanded() {
            for (CellExpandState state : this.columns.values()) {
                if (state.expanded) continue;
                return false;
            }
            return true;
        }
    }

    static class RowLocation {
        int[] location;

        public RowLocation(IGridRow row) {
            if (row.getParent() == null) {
                this.location = new int[]{row.getRelativeIndex()};
            } else {
                this.location = new int[row.getRowDepth() + 1];
                int index = this.location.length - 1;
                IGridRow r = row;
                while (r != null) {
                    this.location[index--] = r.getRelativeIndex();
                    r = r.getParent();
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof RowLocation && Arrays.equals(this.location, ((RowLocation)obj).location);
        }

        public int hashCode() {
            return Arrays.hashCode(this.location);
        }

        public String toString() {
            return Arrays.toString(this.location);
        }
    }

    private static class RowRange {
        public int startIndex;
        public int endIndex;
        public int rows;
        public int height;

        private RowRange() {
        }
    }
}

