/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SelectActiveDataSourceHandler
extends AbstractDataSourceHandler
implements IElementUpdater {
    private static final int MAX_MENU_ITEM_SIZE = 25;

    static IDataSourceContainerUpdate getDataSourceContainerProvider(IWorkbenchPart workbenchPart) {
        DBPContextProvider contextProvider = (DBPContextProvider)GeneralUtils.adapt((Object)workbenchPart, DBPContextProvider.class);
        if (contextProvider == null) {
            return null;
        }
        if (contextProvider instanceof IDataSourceContainerUpdate) {
            return (IDataSourceContainerUpdate)contextProvider;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (SelectActiveDataSourceHandler.getDataSourceContainerProvider((IWorkbenchPart)activeEditor) == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        DBPDataSourceContainer dataSource = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
        DBPProject activeProject = SelectActiveDataSourceHandler.getActiveProject(dataSource, activeEditor);
        SelectActiveDataSourceHandler.openDataSourceSelector(workbenchWindow, activeProject, dataSource);
        return null;
    }

    @NotNull
    private static DBPProject getActiveProject(@Nullable DBPDataSourceContainer dataSource, @Nullable IEditorPart activeEditor) {
        DBPProject activeProject;
        DBPProject dBPProject = activeProject = dataSource == null ? null : dataSource.getProject();
        if (activeProject == null && activeEditor != null) {
            IFile curFile = EditorUtils.getFileFromInput((IEditorInput)activeEditor.getEditorInput());
            activeProject = curFile != null ? DBPPlatformDesktop.getInstance().getWorkspace().getProject(curFile.getProject()) : DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        }
        return activeProject;
    }

    public static void openDataSourceSelector(IWorkbenchWindow workbenchWindow, DBPProject activeProject, DBPDataSourceContainer dataSource) {
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof IDataSourceContainerUpdate)) {
            return;
        }
        SelectDataSourceDialog dialog = new SelectDataSourceDialog(UIUtils.getActiveWorkbenchShell(), activeProject, dataSource);
        dialog.setModeless(true);
        if (dialog.open() == 1) {
            return;
        }
        DBPDataSourceContainer newDataSource = dialog.getDataSource();
        if (newDataSource == dataSource) {
            return;
        }
        ((IDataSourceContainerUpdate)activeEditor).setDataSourceContainer(newDataSource);
    }

    public void updateElement(UIElement element, Map parameters) {
        DBIcon connectionIcon;
        String connectionName;
        if ("true".equals(parameters.get("noCustomLabel"))) {
            return;
        }
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        DBPDataSourceContainer dataSource = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
        if (dataSource == null) {
            connectionName = "< N/A >";
            connectionIcon = DBIcon.TREE_DATABASE;
        } else {
            connectionName = dataSource.getName();
            connectionIcon = dataSource.getDriver().getIcon();
        }
        if (workbenchWindow != null) {
            GC gc = new GC((Drawable)workbenchWindow.getShell());
            try {
                connectionName = UITextUtils.getShortText((GC)gc, (String)connectionName, (int)200);
            }
            finally {
                gc.dispose();
            }
        }
        element.setText(connectionName);
        element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)connectionIcon));
        element.setTooltip(UINavigatorMessages.toolbar_datasource_selector_combo_datasource_tooltip);
    }

    private static List<? extends DBPDataSourceContainer> getAvailableDataSources() {
        IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
        if (workbenchWindow != null && workbenchWindow.getActivePage() != null) {
            DBPDataSourceContainer dataSourceContainer;
            IFile curFile;
            IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
            if (activeEditor != null && (curFile = EditorUtils.getFileFromInput((IEditorInput)activeEditor.getEditorInput())) != null) {
                DBPDataSourceContainer fileDataSource = EditorUtils.getFileDataSource((IFile)curFile);
                if (fileDataSource != null) {
                    return fileDataSource.getRegistry().getDataSources();
                }
                DBPProject projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(curFile.getProject());
                if (projectMeta != null) {
                    return projectMeta.getDataSourceRegistry().getDataSources();
                }
            }
            if ((dataSourceContainer = SelectActiveDataSourceHandler.getDataSourceContainerFromPart(workbenchWindow.getActivePage().getActivePart())) != null) {
                return dataSourceContainer.getRegistry().getDataSources();
            }
            return DataSourceRegistry.getAllDataSources();
        }
        return Collections.emptyList();
    }

    public static class MenuContributor
    extends DataSourceMenuContributor {
        @Override
        protected void fillContributionItems(List<IContributionItem> menuItems) {
            final IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
                return;
            }
            final IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
            if (!(activeEditor instanceof IDataSourceContainerUpdate)) {
                return;
            }
            List<? extends DBPDataSourceContainer> dataSources = SelectActiveDataSourceHandler.getAvailableDataSources();
            ArrayList<? extends DBPDataSourceContainer> connectedDataSources = new ArrayList<DBPDataSourceContainer>(dataSources);
            connectedDataSources.removeIf(o -> !o.isConnected());
            dataSources.removeAll(connectedDataSources);
            ArrayList<DBPDataSourceContainer> singleDataSources = new ArrayList<DBPDataSourceContainer>();
            TreeMap<DBPDriver, List> driverMap = new TreeMap<DBPDriver, List>(DBUtils.nameComparator());
            for (DBPDataSourceContainer dBPDataSourceContainer : dataSources) {
                List driverDS = driverMap.computeIfAbsent(dBPDataSourceContainer.getDriver(), k -> new ArrayList());
                driverDS.add(dBPDataSourceContainer);
            }
            Iterator iterator = driverMap.entrySet().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next().getValue();
                if (list.size() != 1) continue;
                singleDataSources.add((DBPDataSourceContainer)list.get(0));
                iterator.remove();
            }
            singleDataSources.sort(DBUtils.nameComparator());
            final DBPDataSourceContainer dBPDataSourceContainer = SelectActiveDataSourceHandler.getDataSourceContainerFromPart(workbenchWindow.getActivePage().getActivePart());
            for (DBPDataSourceContainer dBPDataSourceContainer2 : connectedDataSources) {
                DBNDatabaseNode dsNode = DBNUtils.getNodeByObject((DBSObject)dBPDataSourceContainer2);
                menuItems.add((IContributionItem)new ActionContributionItem((IAction)this.createDataSourceChangeAction((IDataSourceContainerUpdate)activeEditor, dBPDataSourceContainer, dBPDataSourceContainer2, dsNode)));
            }
            if (!driverMap.isEmpty()) {
                menuItems.add((IContributionItem)new Separator());
                for (Map.Entry entry : driverMap.entrySet()) {
                    DBPDriver driver = (DBPDriver)entry.getKey();
                    MenuManager driverMenu = new MenuManager(driver.getName(), DBeaverIcons.getImageDescriptor((DBPImage)driver.getIcon()), driver.getId());
                    for (DBPDataSourceContainer ds : (List)entry.getValue()) {
                        driverMenu.add((IAction)this.createDataSourceChangeAction((IDataSourceContainerUpdate)activeEditor, dBPDataSourceContainer, ds, null));
                    }
                    menuItems.add((IContributionItem)driverMenu);
                }
            }
            if (!singleDataSources.isEmpty()) {
                menuItems.add((IContributionItem)new Separator());
                for (DBPDataSourceContainer dBPDataSourceContainer3 : singleDataSources) {
                    menuItems.add((IContributionItem)new ActionContributionItem((IAction)this.createDataSourceChangeAction((IDataSourceContainerUpdate)activeEditor, dBPDataSourceContainer, dBPDataSourceContainer3, DBNUtils.getNodeByObject((DBSObject)dBPDataSourceContainer3))));
                }
            }
            if (menuItems.size() > 25) {
                while (menuItems.size() > 25) {
                    menuItems.remove(menuItems.size() - 1);
                }
                menuItems.add((IContributionItem)new Separator());
                menuItems.add((IContributionItem)new ActionContributionItem((IAction)new Action("Other ..."){

                    public void run() {
                        SelectActiveDataSourceHandler.openDataSourceSelector(workbenchWindow, SelectActiveDataSourceHandler.getActiveProject(dBPDataSourceContainer, activeEditor), dBPDataSourceContainer);
                    }
                }));
            }
        }

        private Action createDataSourceChangeAction(final IDataSourceContainerUpdate activeEditor, final DBPDataSourceContainer curDataSource, final DBPDataSourceContainer newDataSource, DBNDatabaseNode dsNode) {
            return new Action(newDataSource.getName(), 2, dsNode){
                {
                    super($anonymous0, $anonymous1);
                    if (dBNDatabaseNode != null) {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)dBNDatabaseNode.getNodeIcon()));
                    }
                }

                public boolean isChecked() {
                    return newDataSource == curDataSource;
                }

                public void run() {
                    activeEditor.setDataSourceContainer(newDataSource);
                }
            };
        }
    }
}

