/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.util.Arrays;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class AbstractNativeToolWizardPage<WIZARD extends AbstractNativeToolWizard>
extends ActiveWizardPage {
    protected final WIZARD wizard;
    protected Text outputFolderText;
    protected Text outputFileText;
    protected Text extraCommandArgsText;

    protected AbstractNativeToolWizardPage(WIZARD wizard, String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.wizard = wizard;
    }

    protected boolean determinePageCompletion() {
        Object settings = ((AbstractNativeToolWizard)((Object)this.wizard)).getSettings();
        if (settings.getClientHome() == null) {
            this.setErrorMessage(TaskNativeUIMessages.tools_wizard_message_no_client_home);
            return false;
        }
        if (settings instanceof AbstractImportExportSettings && ((AbstractImportExportSettings)settings).getOutputFolderPattern() == null) {
            this.setErrorMessage(TaskNativeUIMessages.tools_wizard_message_no_output_folder);
            return false;
        }
        return super.determinePageCompletion();
    }

    protected void createCheckButtons(Composite buttonsPanel, Table table) {
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)TaskNativeUIMessages.tools_wizard_page_dialog_button_all, (SelectionListener)new CheckListener(table, true));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)TaskNativeUIMessages.tools_wizard_page_dialog_button_none, (SelectionListener)new CheckListener(table, false));
    }

    protected void createOutputFolderInput(@NotNull Composite outputGroup, @NotNull AbstractImportExportSettings settings) {
        this.outputFolderText = DialogUtils.createOutputFolderChooser((Composite)outputGroup, (String)TaskNativeUIMessages.tools_wizard_page_dialog_folder_pattern, (String)settings.getOutputFolderPattern(), e -> this.updateState());
        this.outputFileText = UIUtils.createLabelText((Composite)outputGroup, (String)TaskNativeUIMessages.tools_wizard_page_dialog_file_pattern, (String)settings.getOutputFilePattern());
        UIUtils.setContentProposalToolTip((Control)this.outputFileText, (String)TaskNativeUIMessages.tools_wizard_page_dialog_folder_pattern_tip, (String[])NativeToolUtils.ALL_VARIABLES);
        ContentAssistUtils.installContentProposal((Control)this.outputFileText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(NativeToolUtils.ALL_VARIABLES).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.outputFileText.addModifyListener(e -> settings.setOutputFilePattern(this.outputFileText.getText()));
        UIUtils.setContentProposalToolTip((Control)this.outputFolderText, (String)TaskNativeUIMessages.tools_wizard_page_dialog_file_pattern_tip, (String[])NativeToolUtils.LIMITED_VARIABLES);
        ContentAssistUtils.installContentProposal((Control)this.outputFolderText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(NativeToolUtils.LIMITED_VARIABLES).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.fixOutputFileExtension();
    }

    protected void createExtraArgsInput(Composite outputGroup) {
        this.extraCommandArgsText = UIUtils.createLabelText((Composite)outputGroup, (String)TaskNativeUIMessages.tools_wizard_page_dialog_label_extra_command_args, (String)((AbstractNativeToolWizard)((Object)this.wizard)).getSettings().getExtraCommandArgs());
        this.extraCommandArgsText.setToolTipText(TaskNativeUIMessages.tools_wizard_page_dialog_tooltip_extra_command_args);
        ContentAssistUtils.installContentProposal((Control)this.extraCommandArgsText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[0]));
        this.extraCommandArgsText.addModifyListener(e -> ((AbstractNativeToolWizard)((Object)((Object)this.wizard))).getSettings().setExtraCommandArgs(this.extraCommandArgsText.getText()));
    }

    protected void fixOutputFileExtension() {
        boolean isDotWithEmptyExt;
        String ext;
        String name;
        String text = this.outputFileText.getText();
        int idxOfExtStart = text.lastIndexOf(46);
        if (idxOfExtStart > -1 && idxOfExtStart <= text.length()) {
            name = text.substring(0, idxOfExtStart);
            ext = text.substring(idxOfExtStart + 1);
        } else {
            name = text;
            ext = "";
        }
        String newExt = this.getExtension();
        boolean bl = isDotWithEmptyExt = ext.isEmpty() && idxOfExtStart > -1;
        if (!isDotWithEmptyExt && ext.equalsIgnoreCase(newExt)) {
            return;
        }
        if (!newExt.isEmpty()) {
            newExt = "." + newExt;
        }
        text = String.valueOf(name) + newExt;
        this.outputFileText.setText(text);
    }

    protected String getExtension() {
        return "sql";
    }

    public void saveState() {
        if (this.extraCommandArgsText != null) {
            ((AbstractNativeToolWizard)((Object)this.wizard)).getSettings().setExtraCommandArgs(this.extraCommandArgsText.getText());
        }
    }

    protected void updateState() {
        this.saveState();
        this.setPageComplete(true);
    }

    protected void updateTableCheckedStatus(@NotNull Table table, boolean check) {
    }

    private class CheckListener
    extends SelectionAdapter {
        private final Table table;
        private final boolean check;

        public CheckListener(Table table, boolean check) {
            this.table = table;
            this.check = check;
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(this.check);
                ++n2;
            }
            AbstractNativeToolWizardPage.this.updateTableCheckedStatus(this.table, this.check);
            AbstractNativeToolWizardPage.this.updateState();
        }
    }
}

