/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.LocalProjectImpl;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class EclipseWorkspaceImpl
extends BaseWorkspaceImpl
implements DBPWorkspaceEclipse {
    private static final Log log = Log.getLog(EclipseWorkspaceImpl.class);
    private final String workspaceId = EclipseWorkspaceImpl.readWorkspaceId();
    private final ProjectListener projectListener = new ProjectListener();

    public EclipseWorkspaceImpl(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        super(platform, eclipseWorkspace);
        this.getEclipseWorkspace().addResourceChangeListener((IResourceChangeListener)this.projectListener);
    }

    @Override
    public final void initializeProjects() {
        try {
            this.getAuthContext().addSession(this.acquireWorkspaceSession((DBRProgressMonitor)new VoidProgressMonitor()));
        }
        catch (DBException e) {
            if (!(e instanceof DBInterruptedException)) {
                log.debug((Object)e);
                DBWorkbench.getPlatformUI().showMessageBox("Authentication error", "Error authenticating application user: \n" + e.getMessage(), true);
            }
            this.dispose();
            System.exit(101);
        }
        this.loadWorkspaceProjects();
        if (DBWorkbench.getPlatform().getApplication().isStandalone() && CommonUtils.isEmpty((Map)this.projects) && this.isDefaultProjectNeeded()) {
            try {
                this.createDefaultProject();
            }
            catch (CoreException e) {
                log.error((Object)"Can't create default project", (Throwable)e);
            }
        }
        if (this.getActiveProject() == null && !this.projects.isEmpty()) {
            this.setActiveProject((DBPProject)this.projects.values().iterator().next());
        }
        if (this.activeProject != null && !this.activeProject.isOpen()) {
            try {
                this.activeProject.ensureOpen();
            }
            catch (IllegalStateException e) {
                log.error((Object)"Error opening active project", (Throwable)e);
            }
        }
    }

    protected boolean isDefaultProjectNeeded() {
        return DBWorkbench.getPlatform().getApplication().getDefaultProjectName() != null;
    }

    @Override
    public void dispose() {
        this.getEclipseWorkspace().removeResourceChangeListener((IResourceChangeListener)this.projectListener);
        super.dispose();
    }

    protected void loadWorkspaceProjects() {
        String activeProjectName = this.getPlatform().getPreferenceStore().getString("project.active");
        IWorkspaceRoot root = this.getEclipseWorkspace().getRoot();
        Object[] allProjects = root.getProjects();
        if (ArrayUtils.isEmpty((Object[])allProjects)) {
            try {
                this.reloadWorkspace((DBRProgressMonitor)new LoggingProgressMonitor(log));
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            allProjects = root.getProjects();
        }
        Object[] objectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object project = objectArray[n2];
            if (project.exists() && !project.isHidden() && this.isProjectAccessible((IProject)project)) {
                LocalProjectImpl projectMetadata = (LocalProjectImpl)this.projects.get(project);
                if (projectMetadata == null) {
                    projectMetadata = this.createProjectFrom((IProject)project);
                }
                this.projects.put(project, projectMetadata);
                if (this.activeProject == null || !CommonUtils.isEmpty((String)activeProjectName) && project.getName().equals(activeProjectName)) {
                    this.activeProject = projectMetadata;
                }
            }
            ++n2;
        }
    }

    protected void reloadWorkspace(DBRProgressMonitor monitor) {
    }

    protected boolean isProjectAccessible(IProject project) {
        return true;
    }

    protected LocalProjectImpl createProjectFrom(IProject project) {
        return new LocalProjectImpl(this, project, this.getAuthContext());
    }

    private IProject createDefaultProject() throws CoreException {
        String baseProjectName;
        String projectName = baseProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
        int i = 1;
        while (true) {
            IProject project;
            if (!(project = this.getEclipseWorkspace().getRoot().getProject(projectName)).exists()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                project.create((IProgressMonitor)monitor);
                project.open((IProgressMonitor)monitor);
                IProjectDescription description = this.getEclipseWorkspace().newProjectDescription(project.getName());
                description.setComment("General DBeaver project");
                description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
                project.setDescription(description, (IProgressMonitor)monitor);
                return project;
            }
            projectName = String.valueOf(baseProjectName) + i;
            ++i;
        }
    }

    @NotNull
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    private void handleResourceChange(LocalProjectImpl projectMetadata, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            IPath movedToPath = delta.getMovedToPath();
            if (movedToPath != null) {
                IPath oldPath = delta.getProjectRelativePath();
                IPath newPath = movedToPath.makeRelativeTo(projectMetadata.getEclipseProject().getFullPath());
                projectMetadata.moveResourceCache(oldPath, newPath);
            } else {
                projectMetadata.removeResourceFromCache(delta.getProjectRelativePath());
            }
        } else {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(31, 8);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                this.handleResourceChange(projectMetadata, childDelta);
                ++n2;
            }
        }
    }

    private class ProjectListener
    implements IResourceChangeListener {
        private ProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                Arrays.stream(event.getDelta().getAffectedChildren()).filter(delta -> delta.getResource() instanceof IProject).sorted(Comparator.comparingInt(IResourceDelta::getKind).reversed()).forEach(delta -> {
                    IProject project = (IProject)delta.getResource();
                    if (!EclipseWorkspaceImpl.this.projects.containsKey(project)) {
                        if (delta.getKind() == 1) {
                            LocalProjectImpl projectMetadata = EclipseWorkspaceImpl.this.createProjectFrom(project);
                            EclipseWorkspaceImpl.this.projects.put(project, projectMetadata);
                            EclipseWorkspaceImpl.this.fireProjectAdd(projectMetadata);
                            if (EclipseWorkspaceImpl.this.activeProject == null) {
                                EclipseWorkspaceImpl.this.activeProject = projectMetadata;
                                EclipseWorkspaceImpl.this.fireActiveProjectChange(null, EclipseWorkspaceImpl.this.activeProject);
                            }
                        }
                    } else if (delta.getKind() == 2) {
                        LocalProjectImpl projectMetadata = (LocalProjectImpl)EclipseWorkspaceImpl.this.projects.remove(project);
                        EclipseWorkspaceImpl.this.fireProjectRemove(projectMetadata);
                        if (projectMetadata == EclipseWorkspaceImpl.this.activeProject) {
                            EclipseWorkspaceImpl.this.activeProject = null;
                            EclipseWorkspaceImpl.this.fireActiveProjectChange(projectMetadata, null);
                        }
                    } else {
                        LocalProjectImpl projectMetadata = (LocalProjectImpl)EclipseWorkspaceImpl.this.projects.get(project);
                        if (projectMetadata != null) {
                            EclipseWorkspaceImpl.this.handleResourceChange(projectMetadata, (IResourceDelta)delta);
                        }
                    }
                });
            }
        }
    }
}

